/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.tmdb.TmdbController;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbUtils;
import org.tinymediamanager.scraper.tmdb.entities.Videos;
import org.tinymediamanager.scraper.tmdb.enumerations.VideoType;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

class TmdbTrailerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTrailerProvider.class);
    private final TmdbController api;

    TmdbTrailerProvider(TmdbController api) {
        this.api = api;
    }

    List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getTrailers(): {}", (Object)options);
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, options.getMediaType(), imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb from imdb - '{}'", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        String language = TmdbMetadataProvider.getRequestLanguage(options.getLanguage());
        LOGGER.debug("TMDB: getTrailers(tmdbId): {}", (Object)tmdbId);
        ArrayList<Videos.Video> videos = new ArrayList<Videos.Video>();
        try {
            Videos tmdbVideosWoLang;
            Videos tmdbVideos;
            if (options.getMediaType() == MediaType.MOVIE) {
                tmdbVideos = (Videos)this.api.moviesService().videos(tmdbId, language).execute().body();
                tmdbVideosWoLang = (Videos)this.api.moviesService().videos(tmdbId, "").execute().body();
                videos.addAll(tmdbVideos.results);
                videos.addAll(tmdbVideosWoLang.results);
            } else if (options.getMediaType() == MediaType.TV_SHOW) {
                tmdbVideos = (Videos)this.api.tvService().videos(tmdbId, language).execute().body();
                tmdbVideosWoLang = (Videos)this.api.tvService().videos(tmdbId, "").execute().body();
                videos.addAll(tmdbVideos.results);
                videos.addAll(tmdbVideosWoLang.results);
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get trailer: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (Videos.Video video : ListUtils.nullSafe(videos)) {
            if (VideoType.TRAILER != video.type) continue;
            MediaTrailer trailer = new MediaTrailer();
            trailer.setName(video.name);
            trailer.setQuality(video.size + "p");
            trailer.setProvider(video.site);
            trailer.setScrapedBy("tmdb");
            trailer.setUrl(video.key);
            if ("youtube".equalsIgnoreCase(video.site)) {
                StringBuilder sb = new StringBuilder();
                sb.append("http://www.youtube.com/watch?v=");
                sb.append(video.key);
                if (MetadataUtil.unboxInteger(video.size) >= 720) {
                    sb.append("&hd=1");
                }
                trailer.setUrl(sb.toString());
            }
            if (trailers.contains(trailer)) continue;
            trailers.add(trailer);
        }
        return trailers;
    }
}

