/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTmdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbUtils;
import org.tinymediamanager.scraper.tmdb.entities.AppendToResponse;
import org.tinymediamanager.scraper.tmdb.entities.BaseCompany;
import org.tinymediamanager.scraper.tmdb.entities.BaseKeyword;
import org.tinymediamanager.scraper.tmdb.entities.BaseTvEpisode;
import org.tinymediamanager.scraper.tmdb.entities.BaseTvShow;
import org.tinymediamanager.scraper.tmdb.entities.CastMember;
import org.tinymediamanager.scraper.tmdb.entities.ContentRating;
import org.tinymediamanager.scraper.tmdb.entities.CrewMember;
import org.tinymediamanager.scraper.tmdb.entities.FindResults;
import org.tinymediamanager.scraper.tmdb.entities.Genre;
import org.tinymediamanager.scraper.tmdb.entities.Image;
import org.tinymediamanager.scraper.tmdb.entities.Network;
import org.tinymediamanager.scraper.tmdb.entities.TvEpisode;
import org.tinymediamanager.scraper.tmdb.entities.TvSeason;
import org.tinymediamanager.scraper.tmdb.entities.TvShow;
import org.tinymediamanager.scraper.tmdb.entities.TvShowResultsPage;
import org.tinymediamanager.scraper.tmdb.enumerations.AppendToResponseItem;
import org.tinymediamanager.scraper.tmdb.enumerations.ExternalSource;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

public class TmdbTvShowMetadataProvider
extends TmdbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowTmdbMetadataProvider,
ITvShowImdbMetadataProvider,
ITvShowTvdbMetadataProvider,
IRatingProvider,
IMediaIdProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(600L, 5L);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().addBoolean("includeAdultShows", false);
        info.getConfig().addBoolean("scrapeLanguageNames", true);
        info.getConfig().addBoolean("titleFallback", false);
        info.getConfig().addSelect("titleFallbackLanguage", PT, "en-US");
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Response httpResponse;
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        Exception savedException = null;
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = Utils.removeSortableName(options.getSearchQuery());
        }
        searchString = MetadataUtil.removeNonSearchCharacters(searchString);
        String imdbId = options.getImdbId();
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            imdbId = "";
        }
        if (MediaIdUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        int tvdbId = options.getIdAsInt("tvdb");
        boolean adult = this.getProviderInfo().getConfig().getValueAsBool("includeAdultShows");
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        LOGGER.info("========= BEGIN TMDB Scraper Search for: {}", (Object)searchString);
        if (tmdbId != 0) {
            LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
            try {
                httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                Iterator<BaseTvShow> show = (TvShow)httpResponse.body();
                this.injectTranslations(Locale.forLanguageTag(language), (TvShow)((Object)show));
                results.add(this.morphTvShowToSearchResult((BaseTvShow)((Object)show), options));
                LOGGER.debug("found {} results with TMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
            try {
                httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                    this.injectTranslations(Locale.forLanguageTag(language), show);
                    results.add(this.morphTvShowToSearchResult(show, options));
                }
                LOGGER.debug("found {} results with IMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && tvdbId > 0) {
            LOGGER.debug("found TVDB ID {} - getting direct", (Object)tvdbId);
            try {
                httpResponse = this.api.findService().find(tvdbId, ExternalSource.TVDB_ID, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                    this.injectTranslations(options.getLanguage().toLocale(), show);
                    results.add(this.morphTvShowToSearchResult(show, options));
                }
                LOGGER.debug("found {} results with TVDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tvdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty()) {
            try {
                Response httpResponse2;
                int page = 1;
                int maxPage = 1;
                do {
                    if (!(httpResponse2 = this.api.searchService().tv(searchString, page, language, null, adult).execute()).isSuccessful() || httpResponse2.body() == null) {
                        throw new HttpException(httpResponse2.code(), httpResponse2.message());
                    }
                    for (BaseTvShow show : ListUtils.nullSafe(((TvShowResultsPage)httpResponse2.body()).results)) {
                        this.injectTranslations(Locale.forLanguageTag(language), show);
                        results.add(this.morphTvShowToSearchResult(show, options));
                    }
                } while (++page <= (maxPage = ((TvShowResultsPage)httpResponse2.body()).total_pages.intValue()));
                LOGGER.debug("found {} results with search string", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && savedException != null) {
            throw new ScrapeException(savedException);
        }
        return results;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList(): {} ", (Object)options);
        this.initAPI();
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, options.getImdbId());
            }
            catch (Exception e) {
                LOGGER.warn("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0 && options.getIdAsIntOrDefault("tvdb", 0) > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, options.getIdAsInteger("tvdb"));
            }
            catch (Exception e) {
                LOGGER.warn("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            throw new MissingIdException(new String[]{"tmdb"});
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(tmdbId + "_" + language);
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        episodes = new ArrayList<MediaMetadata>();
        try {
            Response showResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS, AppendToResponseItem.KEYWORDS)).execute();
            if (!showResponse.isSuccessful() || showResponse.body() == null) {
                throw new HttpException(showResponse.code(), showResponse.message());
            }
            String originalLanguage = ((TvShow)showResponse.body()).original_language;
            for (TvSeason season : ListUtils.nullSafe(((TvShow)showResponse.body()).seasons)) {
                List<MediaMetadata> seasonEpisodes = this.getSeasonEpisodes(tmdbId, season.season_number, options, originalLanguage);
                episodes.addAll(seasonEpisodes);
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(tmdbId + "_" + language, episodes);
        }
        return episodes;
    }

    private List<MediaMetadata> getSeasonEpisodes(int tmdbId, Integer seasonNumber, TvShowSearchAndScrapeOptions options, String originalLanguage) throws IOException {
        Object fallbackLanguage;
        MediaMetadata ep;
        TreeMap<Integer, MediaMetadata> episodesInRequestedLanguage = new TreeMap<Integer, MediaMetadata>();
        TreeMap<Integer, MediaMetadata> episodesInFallbackLanguage = new TreeMap<Integer, MediaMetadata>();
        TreeMap<Integer, MediaMetadata> episodesInOriginalLanguage = new TreeMap<Integer, MediaMetadata>();
        String requestedLanguage = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        Response seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNumber, requestedLanguage, new AppendToResponse(AppendToResponseItem.CREDITS)).execute();
        if (!seasonResponse.isSuccessful()) {
            throw new HttpException(seasonResponse.code(), seasonResponse.message());
        }
        for (TvEpisode tvEpisode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
            ep = this.morphTvEpisodeToMediaMetadata(tvEpisode, (TvSeason)seasonResponse.body(), options);
            episodesInRequestedLanguage.put(ep.getEpisodeNumber(), ep);
        }
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback")) && !requestedLanguage.equals(fallbackLanguage = this.getProviderInfo().getConfig().getValue("titleFallbackLanguage")) && (seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNumber, (String)fallbackLanguage).execute()).isSuccessful()) {
            for (TvEpisode episode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                MediaMetadata ep2 = this.morphTvEpisodeToMediaMetadata(episode, null, options);
                episodesInFallbackLanguage.put(ep2.getEpisodeNumber(), ep2);
            }
        }
        if (requestedLanguage.equals(originalLanguage)) {
            episodesInOriginalLanguage.putAll(episodesInRequestedLanguage);
        } else {
            seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNumber, originalLanguage).execute();
            if (seasonResponse.isSuccessful()) {
                for (TvEpisode tvEpisode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                    ep = this.morphTvEpisodeToMediaMetadata(tvEpisode, null, options);
                    episodesInOriginalLanguage.put(ep.getEpisodeNumber(), ep);
                }
            }
        }
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        for (MediaMetadata md : episodesInRequestedLanguage.values()) {
            MediaMetadata fallback = (MediaMetadata)episodesInFallbackLanguage.get(md.getEpisodeNumber());
            MediaMetadata original = (MediaMetadata)episodesInOriginalLanguage.get(md.getEpisodeNumber());
            if (StringUtils.isBlank((CharSequence)md.getTitle()) && fallback != null && StringUtils.isNotBlank((CharSequence)fallback.getTitle())) {
                md.setTitle(fallback.getTitle());
            }
            if (StringUtils.isBlank((CharSequence)md.getTitle()) && original != null && StringUtils.isNotBlank((CharSequence)original.getTitle())) {
                md.setTitle(original.getTitle());
            }
            if (original != null && StringUtils.isNotBlank((CharSequence)original.getTitle())) {
                md.setOriginalTitle(original.getTitle());
            }
            if (StringUtils.isBlank((CharSequence)md.getPlot()) && fallback != null && StringUtils.isNotBlank((CharSequence)fallback.getPlot())) {
                md.setPlot(fallback.getPlot());
            }
            if (StringUtils.isBlank((CharSequence)md.getPlot()) && original != null && StringUtils.isNotBlank((CharSequence)original.getPlot())) {
                md.setPlot(original.getPlot());
            }
            episodes.add(md);
        }
        return episodes;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        CountryCode countryCode;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, options.getImdbId());
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0 && options.getIdAsIntOrDefault("tvdb", 0) > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, options.getIdAsInteger("tvdb"));
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        TvShow complete = null;
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS, AppendToResponseItem.KEYWORDS)).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            complete = (TvShow)httpResponse.body();
            this.injectTranslations(Locale.forLanguageTag(language), complete);
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (complete == null) {
            throw new NothingFoundException();
        }
        md.setId(this.getId(), tmdbId);
        md.setTitle(complete.name);
        md.setOriginalTitle(complete.original_name);
        try {
            MediaRating rating = new MediaRating("tmdb");
            rating.setRating(complete.vote_average);
            rating.setVotes(complete.vote_count);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        md.setReleaseDate(complete.first_air_date);
        md.setPlot(complete.overview);
        for (String string : ListUtils.nullSafe(complete.origin_country)) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), string));
                continue;
            }
            md.addCountry(string);
        }
        if (complete.episode_run_time != null && !complete.episode_run_time.isEmpty()) {
            md.setRuntime(complete.episode_run_time.get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)complete.poster_path)) {
            Iterator<BaseCompany> ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ((MediaArtwork)((Object)ma)).setPreviewUrl(this.artworkBaseUrl + "w342" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setDefaultUrl(this.artworkBaseUrl + "original" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setOriginalUrl(this.artworkBaseUrl + "original" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setLanguage(options.getLanguage().getLanguage());
            ((MediaArtwork)((Object)ma)).setTmdbId(complete.id);
            md.addMediaArt((MediaArtwork)((Object)ma));
        }
        for (Network network : ListUtils.nullSafe(complete.networks)) {
            md.addProductionCompany(network.name.trim());
        }
        for (BaseCompany baseCompany : ListUtils.nullSafe(complete.production_companies)) {
            md.addProductionCompany(baseCompany.name.trim());
        }
        md.setStatus(complete.status);
        if (complete.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(complete.first_air_date);
            md.setYear(calendar.get(1));
        }
        if (complete.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(complete.credits.cast)) {
                Person cm = new Person(Person.Type.ACTOR);
                cm.setId(this.getProviderInfo().getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
                }
                md.addCastMember(cm);
            }
        }
        if (complete.external_ids != null) {
            if (complete.external_ids.tvdb_id != null && complete.external_ids.tvdb_id > 0) {
                md.setId("tvdb", complete.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)complete.external_ids.imdb_id)) {
                md.setId("imdb", complete.external_ids.imdb_id);
            }
            if (complete.external_ids.tvrage_id != null && complete.external_ids.tvrage_id > 0) {
                md.setId("tvrage", complete.external_ids.tvrage_id);
            }
        }
        if (complete.content_ratings != null && (countryCode = options.getCertificationCountry()) != null) {
            for (ContentRating country : ListUtils.nullSafe(complete.content_ratings.results)) {
                if (!StringUtils.isNotBlank((CharSequence)country.rating) || !country.iso_3166_1.equalsIgnoreCase(countryCode.getAlpha2())) continue;
                md.addCertification(MediaCertification.getCertification(country.iso_3166_1, country.rating));
            }
        }
        for (Genre genre : ListUtils.nullSafe(complete.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        for (TvSeason tvSeason : ListUtils.nullSafe(complete.seasons)) {
            if (tvSeason.season_number == null || !StringUtils.isNotBlank((CharSequence)tvSeason.name)) continue;
            md.addSeasonName(tvSeason.season_number, tvSeason.name);
        }
        if (complete.keywords != null) {
            for (BaseKeyword baseKeyword : ListUtils.nullSafe(complete.keywords.keywords)) {
                md.addTag(baseKeyword.name);
            }
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        Person cm;
        TvEpisode tvEpisode;
        BaseTvEpisode baseTvEpisode;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int tmdbId = 0;
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if ((seasonNr == -1 || episodeNr == -1) && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByImdbId(options.getImdbId());
                if (baseTvEpisode != null) {
                    tmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by imdb id - {}", (Object)e.getMessage());
            }
        }
        if ((seasonNr == -1 || episodeNr == -1) && options.getIds().containsKey("tvdb")) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByTvdbId(options.getIdAsInt("tvdb"));
                if (baseTvEpisode != null) {
                    tmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = options.createTvShowSearchAndScrapeOptions();
            tmdbId = tvShowSearchAndScrapeOptions.getTmdbId();
            if (tmdbId == 0 && MediaIdUtil.isValidImdbId(tvShowSearchAndScrapeOptions.getImdbId())) {
                try {
                    tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, tvShowSearchAndScrapeOptions.getImdbId());
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
                }
            }
            if (tmdbId == 0 && tvShowSearchAndScrapeOptions.getIdAsIntOrDefault("tvdb", 0) > 0) {
                try {
                    tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, tvShowSearchAndScrapeOptions.getIdAsInteger("tvdb"));
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
                }
            }
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        MediaMetadata episodeMediaMetadata = null;
        List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        if (options.getIds().containsKey("tmdb")) {
            for (MediaMetadata mediaMetadata : episodes) {
                if (((Integer)mediaMetadata.getId("tmdb")).intValue() != options.getIdAsInt("tmdb")) continue;
                episodeMediaMetadata = mediaMetadata;
                break;
            }
        }
        if (episodeMediaMetadata == null && seasonNr > -1 && episodeNr > -1) {
            for (MediaMetadata mediaMetadata : episodes) {
                if (mediaMetadata.getSeasonNumber() != seasonNr || mediaMetadata.getEpisodeNumber() != episodeNr) continue;
                episodeMediaMetadata = mediaMetadata;
                break;
            }
        }
        if (episodeMediaMetadata == null && options.getMetadata().getReleaseDate() != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String string = formatter.format((Object)options.getMetadata().getReleaseDate());
                for (MediaMetadata episode3 : episodes) {
                    String airedEp;
                    if (episode3.getReleaseDate() == null || !string.equals(airedEp = formatter.format((Object)episode3.getReleaseDate()))) continue;
                    episodeMediaMetadata = episode3;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not parse aired date - '{}'", (Object)e.getMessage());
            }
        }
        if (episodeMediaMetadata == null) {
            throw new NothingFoundException();
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        Object var9_19 = null;
        try {
            Response episodeResponse = this.api.tvEpisodesService().episode(tmdbId, episodeMediaMetadata.getSeasonNumber(), episodeMediaMetadata.getEpisodeNumber(), language, new AppendToResponse(AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CREDITS, AppendToResponseItem.IMAGES)).execute();
            if (!episodeResponse.isSuccessful()) {
                throw new HttpException(episodeResponse.code(), episodeResponse.message());
            }
            tvEpisode = (TvEpisode)episodeResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (tvEpisode == null) {
            throw new NothingFoundException();
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber(tvEpisode.episode_number));
        md.setSeasonNumber(TvUtils.getSeasonNumber(tvEpisode.season_number));
        md.setId(this.getId(), tvEpisode.id);
        if (tvEpisode.external_ids != null) {
            if (MetadataUtil.unboxInteger(tvEpisode.external_ids.tvdb_id) > 0) {
                md.setId("tvdb", tvEpisode.external_ids.tvdb_id);
            }
            if (MediaIdUtil.isValidImdbId(tvEpisode.external_ids.imdb_id)) {
                md.setId("imdb", tvEpisode.external_ids.imdb_id);
            }
            if (MetadataUtil.unboxInteger(tvEpisode.external_ids.tvrage_id) > 0) {
                md.setId("tvrage", tvEpisode.external_ids.tvrage_id);
            }
        }
        md.setTitle(episodeMediaMetadata.getTitle());
        md.setOriginalTitle(episodeMediaMetadata.getOriginalTitle());
        md.setPlot(episodeMediaMetadata.getPlot());
        if (MetadataUtil.unboxInteger(tvEpisode.vote_count, 0) > 0) {
            try {
                MediaRating rating = new MediaRating("tmdb");
                rating.setRating(MetadataUtil.unboxDouble(tvEpisode.vote_average));
                rating.setVotes(MetadataUtil.unboxInteger(tvEpisode.vote_count));
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        md.setReleaseDate(tvEpisode.air_date);
        for (Person cm2 : episodeMediaMetadata.getCastMembers()) {
            md.addCastMember(cm2);
        }
        for (CastMember castMember : ListUtils.nullSafe(tvEpisode.guest_stars)) {
            cm = new Person(Person.Type.ACTOR);
            cm.setId(this.getProviderInfo().getId(), castMember.id);
            cm.setName(castMember.name);
            cm.setRole(castMember.character);
            if (castMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
            }
            if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
            }
            md.addCastMember(cm);
        }
        for (CrewMember crewMember : ListUtils.nullSafe(tvEpisode.crew)) {
            cm = new Person();
            if ("Director".equals(crewMember.job)) {
                cm.setType(Person.Type.DIRECTOR);
            } else if ("Writing".equals(crewMember.department)) {
                cm.setType(Person.Type.WRITER);
            } else {
                if (!"Production".equals(crewMember.department)) continue;
                cm.setType(Person.Type.PRODUCER);
            }
            cm.setId(this.getProviderInfo().getId(), crewMember.id);
            cm.setName(crewMember.name);
            if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                cm.setThumbUrl(this.artworkBaseUrl + "h632" + crewMember.profile_path);
            }
            if (crewMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
            }
            md.addCastMember(cm);
        }
        if (tvEpisode.images != null && ListUtils.isNotEmpty(tvEpisode.images.stills)) {
            for (Image image : tvEpisode.images.stills) {
                MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
                ma.setPreviewUrl(this.artworkBaseUrl + "w300" + image.file_path);
                ma.setDefaultUrl(this.artworkBaseUrl + "original" + image.file_path);
                ma.setOriginalUrl(this.artworkBaseUrl + "original" + image.file_path);
                ma.addImageSize(image.width, image.height, this.artworkBaseUrl + "original" + image.file_path);
                if (1280 < image.width) {
                    ma.addImageSize(1280, image.height * 1280 / image.width, this.artworkBaseUrl + "w1280" + image.file_path);
                }
                if (300 < image.width) {
                    ma.addImageSize(300, image.height * 300 / image.width, this.artworkBaseUrl + "w300" + image.file_path);
                }
                md.addMediaArt(ma);
            }
        } else if (StringUtils.isNotBlank((CharSequence)tvEpisode.still_path)) {
            MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(this.artworkBaseUrl + "w300" + tvEpisode.still_path);
            ma.setDefaultUrl(this.artworkBaseUrl + "original" + tvEpisode.still_path);
            ma.setOriginalUrl(this.artworkBaseUrl + "original" + tvEpisode.still_path);
            ma.addImageSize(1920, 1080, this.artworkBaseUrl + "original" + tvEpisode.still_path);
            md.addMediaArt(ma);
        }
        return md;
    }

    @Override
    public List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        if (mediaType == MediaType.TV_SHOW) {
            return this.getTvShowRatings(ids);
        }
        if (mediaType == MediaType.TV_EPISODE) {
            return this.getEpisodeRatings(ids);
        }
        return Collections.emptyList();
    }

    private List<MediaRating> getTvShowRatings(Map<String, Object> ids) throws ScrapeException {
        LOGGER.debug("getRatings(): {}", ids);
        this.initAPI();
        int tmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0 && MediaIdUtil.getIdAsInt(ids, "tvdb") > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, MediaIdUtil.getIdAsInt(ids, "tvdb"));
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        TvShow complete = null;
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, "en", null).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            complete = (TvShow)httpResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (complete == null) {
            throw new NothingFoundException();
        }
        if (complete.vote_average != null && complete.vote_count != null) {
            try {
                MediaRating rating = new MediaRating("tmdb");
                rating.setRating(complete.vote_average);
                rating.setVotes(complete.vote_count);
                rating.setMaxValue(10);
                return Collections.singletonList(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private List<MediaRating> getEpisodeRatings(Map<String, Object> ids) throws ScrapeException {
        BaseTvEpisode baseTvEpisode;
        LOGGER.debug("getRatings(): {}", ids);
        HashMap<String, Object> showIds = new HashMap<String, Object>();
        int showTmdbId = 0;
        try {
            showIds.putAll((Map)ids.get("tvShowIds"));
        }
        catch (Exception e) {
            LOGGER.debug("could not get TV show ids - '{}'", (Object)e.getMessage());
        }
        int seasonNr = MediaIdUtil.getIdAsIntOrDefault(ids, "seasonNr", -1);
        int episodeNr = MediaIdUtil.getIdAsIntOrDefault(ids, "episodeNr", -1);
        if ((seasonNr == -1 || episodeNr == -1) && MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(ids, "imdb"))) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByImdbId(MediaIdUtil.getIdAsString(ids, "imdb"));
                if (baseTvEpisode != null) {
                    showTmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by imdb id - {}", (Object)e.getMessage());
            }
        }
        if ((seasonNr == -1 || episodeNr == -1) && MediaIdUtil.getIdAsInt(ids, "tvdb") > 0) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByTvdbId(MediaIdUtil.getIdAsInt(ids, "tvdb"));
                if (baseTvEpisode != null) {
                    showTmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (showTmdbId == 0 && ids.get("tvShowIds") instanceof Map) {
            showTmdbId = MediaIdUtil.getIdAsInt(showIds, "tmdb");
            if (showTmdbId == 0 && MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(showIds, "imdb"))) {
                try {
                    showTmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, MediaIdUtil.getIdAsString(showIds, "imdb"));
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
                }
            }
            if (showTmdbId == 0 && MediaIdUtil.getIdAsInt(showIds, "tvdb") > 0) {
                try {
                    showTmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, MediaIdUtil.getIdAsInt(showIds, "tvdb"));
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
                }
            }
        }
        if (showTmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        if ((seasonNr == -1 || episodeNr == -1) && MediaIdUtil.getIdAsInt(ids, "tmdb") > 0) {
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setIds(showIds);
            int episodeTmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
            List<MediaMetadata> episodes = this.getEpisodeList(options);
            for (MediaMetadata episode : episodes) {
                if (episode.getIdAsInt("tmdb") != episodeTmdbId) continue;
                seasonNr = episode.getSeasonNumber();
                episodeNr = episode.getEpisodeNumber();
                break;
            }
        }
        if (seasonNr == -1 || episodeNr == -1) {
            LOGGER.warn("season number/episode number found");
            throw new MissingIdException("seasonNr", "episodeNr");
        }
        TvEpisode episode = null;
        TvSeason fullSeason = null;
        try {
            Response seasonResponse = this.api.tvSeasonsService().season(showTmdbId, seasonNr, null, null).execute();
            if (!seasonResponse.isSuccessful()) {
                throw new HttpException(seasonResponse.code(), seasonResponse.message());
            }
            fullSeason = (TvSeason)seasonResponse.body();
            for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                if (MetadataUtil.unboxInteger(ep.season_number, -1) != seasonNr || MetadataUtil.unboxInteger(ep.episode_number, -1) != episodeNr) continue;
                episode = ep;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (episode == null) {
            throw new NothingFoundException();
        }
        if (episode.vote_average != null && episode.vote_count != null) {
            try {
                MediaRating rating = new MediaRating("tmdb");
                rating.setRating(MetadataUtil.unboxDouble(episode.vote_average));
                rating.setVotes(MetadataUtil.unboxInteger(episode.vote_count));
                rating.setMaxValue(10);
                return Collections.singletonList(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getMediaIds(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        TvShow tvShow;
        if (mediaType != MediaType.TV_SHOW) {
            return Collections.emptyMap();
        }
        LOGGER.debug("getMediaIds(): {}", ids);
        this.initAPI();
        int tmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (tmdbId == 0 && !MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        HashMap<String, Object> scrapedIds = new HashMap<String, Object>();
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("problem getting tmdbId from imdbId: {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, "en", new AppendToResponse(AppendToResponseItem.EXTERNAL_IDS)).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            tvShow = (TvShow)httpResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (tvShow == null) {
            throw new NothingFoundException();
        }
        scrapedIds.put("tmdb", tvShow.id);
        if (tvShow.external_ids != null) {
            if (tvShow.external_ids.tvdb_id != null && tvShow.external_ids.tvdb_id > 0) {
                scrapedIds.put("tvdb", tvShow.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)tvShow.external_ids.imdb_id)) {
                scrapedIds.put("imdb", tvShow.external_ids.imdb_id);
            }
            if (tvShow.external_ids.tvrage_id != null && tvShow.external_ids.tvrage_id > 0) {
                scrapedIds.put("tvrage", tvShow.external_ids.tvrage_id);
            }
        }
        return scrapedIds;
    }

    private BaseTvEpisode getBaseTvEpisodeByImdbId(String imdbId) throws IOException {
        FindResults findResults = (FindResults)this.api.findService().find(imdbId, ExternalSource.IMDB_ID, null).execute().body();
        if (findResults != null && ListUtils.isNotEmpty(findResults.tv_episode_results)) {
            return findResults.tv_episode_results.get(0);
        }
        return null;
    }

    private BaseTvEpisode getBaseTvEpisodeByTvdbId(int tvdbId) throws IOException {
        FindResults findResults = (FindResults)this.api.findService().find(tvdbId, ExternalSource.TVDB_ID, null).execute().body();
        if (findResults != null && ListUtils.isNotEmpty(findResults.tv_episode_results)) {
            return findResults.tv_episode_results.get(0);
        }
        return null;
    }

    private void injectTranslations(Locale language, TvShow show) {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            String[] val = this.getValuesFromTranslation(show.translations, language);
            if (StringUtils.isBlank((CharSequence)val[0]) && language.getLanguage().equals(show.original_language)) {
                val[0] = show.original_name;
            }
            String[] temp = this.getValuesFromTranslation(show.translations, fallbackLanguage);
            if (StringUtils.isBlank((CharSequence)val[0])) {
                val[0] = temp[0];
            }
            if (StringUtils.isBlank((CharSequence)val[1])) {
                val[1] = temp[1];
            }
            if (StringUtils.isNotBlank((CharSequence)val[0])) {
                show.name = val[0];
            }
            if (StringUtils.isNotBlank((CharSequence)val[1])) {
                show.overview = val[1];
            }
        }
        if (StringUtils.isBlank((CharSequence)show.name)) {
            show.name = show.original_name;
        }
    }

    private void injectTranslations(Locale language, BaseTvShow show) throws IOException {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            if (show.name.equals(show.original_name) && !show.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {}", (Object)fallbackLanguage);
                String lang = this.getProviderInfo().getConfig().getValue("titleFallbackLanguage").replace("_", "-");
                Response httpResponse = this.api.tvService().tv(show.id, lang, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                TvShow s = (TvShow)httpResponse.body();
                String[] val = this.getValuesFromTranslation(s.translations, language);
                String[] temp = this.getValuesFromTranslation(s.translations, fallbackLanguage);
                if (StringUtils.isBlank((CharSequence)val[0])) {
                    val[0] = temp[0];
                }
                if (StringUtils.isBlank((CharSequence)val[1])) {
                    val[1] = temp[1];
                }
                if (StringUtils.isNotBlank((CharSequence)val[0])) {
                    show.name = val[0];
                }
                if (StringUtils.isNotBlank((CharSequence)val[1])) {
                    show.overview = val[1];
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)show.name)) {
            show.name = show.original_name;
        }
    }

    private MediaMetadata morphTvEpisodeToMediaMetadata(BaseTvEpisode episode, TvSeason tvSeason, MediaSearchAndScrapeOptions options) {
        MediaMetadata ep = new MediaMetadata(this.getId());
        ep.setScrapeOptions(options);
        ep.setId(this.getProviderInfo().getId(), episode.id);
        ep.setEpisodeNumber(episode.episode_number);
        ep.setSeasonNumber(episode.season_number);
        ep.setTitle(episode.name);
        ep.setPlot(episode.overview);
        if (episode.vote_average != null && MetadataUtil.unboxInteger(episode.vote_count, 0) > 0) {
            MediaRating rating = new MediaRating(this.getProviderInfo().getId());
            rating.setRating(episode.vote_average);
            rating.setVotes(episode.vote_count);
            rating.setMaxValue(10);
            ep.addRating(rating);
        }
        if (episode.air_date != null) {
            ep.setReleaseDate(episode.air_date);
        }
        if (tvSeason != null && tvSeason.credits != null) {
            Person cm;
            for (CastMember castMember : ListUtils.nullSafe(tvSeason.credits.cast)) {
                cm = new Person(Person.Type.ACTOR);
                cm.setId(this.getProviderInfo().getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
                }
                ep.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(tvSeason.credits.crew)) {
                cm = new Person();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(Person.Type.DIRECTOR);
                } else if ("Writing".equals(crewMember.department)) {
                    cm.setType(Person.Type.WRITER);
                } else {
                    if (!"Production".equals(crewMember.department)) continue;
                    cm.setType(Person.Type.PRODUCER);
                }
                cm.setId(this.getProviderInfo().getId(), crewMember.id);
                cm.setName(crewMember.name);
                if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + crewMember.profile_path);
                }
                if (crewMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
                }
                ep.addCastMember(cm);
            }
        }
        return ep;
    }

    private MediaSearchResult morphTvShowToSearchResult(BaseTvShow tvShow, TvShowSearchAndScrapeOptions query) {
        MediaSearchResult result = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
        result.setId(Integer.toString(tvShow.id));
        result.setTitle(tvShow.name);
        result.setOriginalTitle(tvShow.original_name);
        result.setOverview(tvShow.overview);
        if (tvShow.poster_path != null && !tvShow.poster_path.isEmpty()) {
            result.setPosterUrl(this.artworkBaseUrl + "w342" + tvShow.poster_path);
        }
        if (tvShow.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tvShow.first_air_date);
            result.setYear(calendar.get(1));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getImdbId()) && query.getImdbId().equals(result.getIMDBId()) || String.valueOf(query.getTmdbId()).equals(result.getId())) {
            LOGGER.debug("perfect match by ID - set score to 1");
            result.setScore(1.0f);
        } else {
            result.calculateScore(query);
        }
        return result;
    }
}

