/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvdbv3;

import com.uwetrottmann.thetvdb.entities.Language;
import com.uwetrottmann.thetvdb.entities.SeriesImageQueryResult;
import com.uwetrottmann.thetvdb.entities.SeriesImageQueryResultResponse;
import com.uwetrottmann.thetvdb.entities.SeriesImagesQueryParam;
import com.uwetrottmann.thetvdb.entities.SeriesImagesQueryParamResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.tvdbv3.TvdbV3MetadataProvider;
import org.tinymediamanager.scraper.tvdbv3.TvdbV3TvShowMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

public class TvdbV3TvShowArtworkProvider
extends TvdbV3MetadataProvider
implements ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvdbV3TvShowArtworkProvider.class);

    @Override
    protected String getSubId() {
        return "tvshow_artwork";
    }

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        LOGGER.debug("getting artwork: {}", (Object)options);
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        if (options.getMediaType() == MediaType.TV_EPISODE) {
            try {
                TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
                episodeSearchAndScrapeOptions.setDataFromOtherOptions(options);
                if (options.getIds().get("tvShowIds") instanceof Map) {
                    Map tvShowIds = (Map)options.getIds().get("tvShowIds");
                    episodeSearchAndScrapeOptions.setTvShowIds(tvShowIds);
                }
                MediaMetadata md = new TvdbV3TvShowMetadataProvider().getMetadata(episodeSearchAndScrapeOptions);
                return md.getMediaArt();
            }
            catch (MissingIdException e) {
                return Collections.emptyList();
            }
            catch (Exception e) {
                throw new ScrapeException(e);
            }
        }
        Integer id = options.getIdAsInteger("tvdb");
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"tvdb"});
        }
        ArrayList<SeriesImageQueryResult> images = new ArrayList<SeriesImageQueryResult>();
        try {
            Response response = this.tvdb.series().imagesQueryParams(id.intValue()).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.code(), response.message());
            }
            for (SeriesImagesQueryParam param : ((SeriesImagesQueryParamResponse)response.body()).data) {
                if (!(options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || "fanart".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.BACKGROUND || "poster".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.POSTER || "season".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.SEASON_POSTER || "seasonwide".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.SEASON_BANNER) && (!"series".equals(param.keyType) || options.getArtworkType() != MediaArtwork.MediaArtworkType.BANNER)) continue;
                try {
                    Response httpResponse = this.tvdb.series().imagesQuery(id.intValue(), param.keyType, null, null, null).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    images.addAll(((SeriesImageQueryResultResponse)httpResponse.body()).data);
                }
                catch (Exception e) {
                    LOGGER.error("could not get artwork from tvdb: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get artwork: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (images.isEmpty()) {
            return artwork;
        }
        images.sort(new ImageComparator(options.getLanguage().getLanguage()));
        block32: for (SeriesImageQueryResult image : images) {
            MediaArtwork ma = null;
            switch (image.keyType) {
                case "fanart": {
                    ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    break;
                }
                case "poster": {
                    ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.POSTER);
                    break;
                }
                case "season": {
                    ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                    try {
                        ma.setSeason(Integer.parseInt(image.subKey));
                    }
                    catch (Exception e) {
                        LOGGER.trace("could not parse season: {}", (Object)image.subKey);
                    }
                    break;
                }
                case "seasonwide": {
                    ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                    try {
                        ma.setSeason(Integer.parseInt(image.subKey));
                    }
                    catch (Exception e) {
                        LOGGER.trace("could not parse season: {}", (Object)image.subKey);
                    }
                    break;
                }
                case "series": {
                    ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.BANNER);
                    break;
                }
                default: {
                    continue block32;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)image.resolution)) {
                try {
                    Pattern pattern = Pattern.compile("([0-9]{3,4})x([0-9]{3,4})");
                    Matcher matcher = pattern.matcher(image.resolution);
                    if (matcher.matches() && matcher.groupCount() > 1) {
                        int width = Integer.parseInt(matcher.group(1));
                        int height = Integer.parseInt(matcher.group(2));
                        ma.addImageSize(width, height, "https://artworks.thetvdb.com/banners/" + image.fileName);
                        switch (ma.getType()) {
                            case POSTER: {
                                if (width >= 1000) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.LARGE.getOrder());
                                    break;
                                }
                                if (width >= 500) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.BIG.getOrder());
                                    break;
                                }
                                if (width >= 342) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.MEDIUM.getOrder());
                                    break;
                                }
                                ma.setSizeOrder(MediaArtwork.PosterSizes.SMALL.getOrder());
                                break;
                            }
                            case BACKGROUND: {
                                if (width >= 3840) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.XLARGE.getOrder());
                                }
                                if (width >= 1920) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
                                    break;
                                }
                                if (width >= 1280) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
                                    break;
                                }
                                ma.setSizeOrder(MediaArtwork.FanartSizes.SMALL.getOrder());
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("could not extract size from artwork: {}", (Object)image.resolution);
                }
            }
            if (ma.getType() == MediaArtwork.MediaArtworkType.SEASON_BANNER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_POSTER) {
                ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
            } else if (ma.getType() == MediaArtwork.MediaArtworkType.BANNER) {
                ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
            }
            ma.setDefaultUrl("https://artworks.thetvdb.com/banners/" + image.fileName);
            ma.setOriginalUrl("https://artworks.thetvdb.com/banners/" + image.fileName);
            if (StringUtils.isNotBlank((CharSequence)image.thumbnail)) {
                ma.setPreviewUrl("https://artworks.thetvdb.com/banners/" + image.thumbnail);
            } else {
                ma.setPreviewUrl(ma.getDefaultUrl());
            }
            if (StringUtils.isBlank((CharSequence)image.language)) {
                ma.setLanguage("-");
            } else {
                ma.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(image.language));
            }
            artwork.add(ma);
        }
        return artwork;
    }

    private class ImageComparator
    implements Comparator<SeriesImageQueryResult> {
        private int preferredLangu = 0;
        private int english = 0;

        private ImageComparator(String language) {
            for (Language lang : TvdbV3TvShowArtworkProvider.this.tvdbLanguages) {
                if (language.equals(lang.abbreviation)) {
                    this.preferredLangu = lang.id;
                }
                if (!"en".equals(lang.abbreviation)) continue;
                this.english = lang.id;
            }
        }

        @Override
        public int compare(SeriesImageQueryResult arg0, SeriesImageQueryResult arg1) {
            int languageId0 = MetadataUtil.unboxInteger(arg0.languageId, -1);
            int languageId1 = MetadataUtil.unboxInteger(arg1.languageId, -1);
            if (languageId0 == this.preferredLangu && languageId1 != this.preferredLangu) {
                return -1;
            }
            if (languageId0 != this.preferredLangu && languageId1 == this.preferredLangu) {
                return 1;
            }
            if (languageId0 == this.english && languageId1 != this.english) {
                return -1;
            }
            if (languageId0 != this.english && languageId1 == this.english) {
                return 1;
            }
            int result = 0;
            if (arg0.ratingsInfo != null && arg1.ratingsInfo != null) {
                int ratingCount0 = MetadataUtil.unboxInteger(arg0.ratingsInfo.count);
                int ratingCount1 = MetadataUtil.unboxInteger(arg1.ratingsInfo.count);
                result = Integer.compare(ratingCount1, ratingCount0);
            }
            if (result == 0) {
                result = Integer.compare(arg1.id, arg0.id);
            }
            return result;
        }
    }
}

