/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvmaze;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.tvmaze.TvMazeMetadataProvider;
import org.tinymediamanager.scraper.tvmaze.entities.Cast;
import org.tinymediamanager.scraper.tvmaze.entities.Episode;
import org.tinymediamanager.scraper.tvmaze.entities.Image;
import org.tinymediamanager.scraper.tvmaze.entities.Show;
import org.tinymediamanager.scraper.tvmaze.entities.Shows;

public class TvMazeTvShowMetadataProvider
extends TvMazeMetadataProvider
implements ITvShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvMazeTvShowMetadataProvider.class);
    private final DateFormat premieredFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public MediaMetadata getMetadata(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        Integer tvMazeId = options.getIdAsIntOrDefault("tvmaze", 0);
        if (tvMazeId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"tvmaze"});
        }
        Show show = null;
        LOGGER.debug("========= BEGIN TVMAZE Scraping");
        try {
            show = this.controller.getMainInformation(tvMazeId);
        }
        catch (IOException e) {
            LOGGER.trace("could not get Main TvShow information: {}", (Object)e.getMessage());
        }
        if (show != null) {
            md.setId("tvmaze", show.id);
            md.setId("imdb", show.tvShowIds.imdb);
            md.setId("tvdb", show.tvShowIds.thetvdb);
            md.setId("tvrage", show.tvShowIds.tvrage);
            md.setTitle(show.title);
            try {
                md.setYear(this.parseYear(show.premiered));
            }
            catch (ParseException e) {
                LOGGER.trace("could not parse year: {}", (Object)e.getMessage());
            }
            try {
                md.setReleaseDate(this.premieredFormat.parse(show.premiered));
            }
            catch (ParseException e) {
                LOGGER.trace("could not parse releasedate: {}", (Object)e.getMessage());
            }
            md.setRuntime(show.runtime);
            for (String string : show.genres) {
                MediaGenres genre = MediaGenres.getGenre(string);
                md.addGenre(genre);
            }
            md.setPlot(Jsoup.parse((String)show.summary).text());
            md.setOriginalLanguage(show.language);
            MediaRating rating = new MediaRating("tvmaze");
            rating.setRating(show.rating.average);
            rating.setMaxValue(10);
            md.addRating(rating);
            try {
                List<Cast> castList = this.controller.getCast(tvMazeId);
                if (!castList.isEmpty()) {
                    for (Cast cast : castList) {
                        Person person = new Person(Person.Type.ACTOR);
                        person.setName(cast.person.name);
                        person.setProfileUrl(cast.person.image.original);
                        person.setThumbUrl(cast.person.image.medium);
                        md.addCastMember(person);
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.trace("could not get cast information: {}", (Object)iOException.getMessage());
            }
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata() TvShowEpisode: {}", (Object)options);
        this.initAPI();
        int showId = options.createTvShowSearchAndScrapeOptions().getIdAsIntOrDefault("tvmaze", 0);
        if (showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"tvdb"});
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        Episode episode = null;
        try {
            episode = this.controller.getEpisode(showId, seasonNr, episodeNr);
        }
        catch (Exception e) {
            LOGGER.trace("could not get Episode information: {}", (Object)e.getMessage());
        }
        if (episode == null) {
            throw new NothingFoundException();
        }
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        md.setId("tvmaze", episode.id);
        md.setTitle(episode.name);
        md.setPlot(Jsoup.parse((String)episode.summary).text());
        md.setEpisodeNumber(episode.episode);
        md.setSeasonNumber(episode.season);
        md.setRuntime(episode.runtime);
        try {
            md.setReleaseDate(this.premieredFormat.parse(episode.airdate));
            md.setYear(this.parseYear(episode.airdate));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        ArrayList<Image> imageList = new ArrayList<Image>();
        try {
            imageList.addAll(this.controller.getImages(showId));
        }
        catch (IOException e) {
            LOGGER.trace("could not get Image information: {}", (Object)e.getMessage());
        }
        for (Image image : imageList) {
            if (StringUtils.isBlank((CharSequence)image.type)) continue;
            switch (image.type) {
                case "poster": {
                    MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
                    ma.setDefaultUrl(image.resolutions.original.url);
                    md.addMediaArt(ma);
                    break;
                }
                case "background": {
                    MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    ma.setDefaultUrl(image.resolutions.original.url);
                    md.addMediaArt(ma);
                    break;
                }
                case "banner": {
                    MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.BANNER);
                    ma.setDefaultUrl(image.resolutions.original.url);
                    md.addMediaArt(ma);
                }
            }
        }
        return md;
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        List<Shows> searchResult;
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        TreeSet<MediaSearchResult> searchResults = new TreeSet<MediaSearchResult>();
        try {
            searchResult = this.controller.getTvShowSearchResults(options.getSearchQuery());
        }
        catch (Exception e) {
            LOGGER.error("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResult == null) {
            LOGGER.warn("no result from tvmaze.com");
            return searchResults;
        }
        for (Shows shows : searchResult) {
            MediaSearchResult result = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
            result.setProviderId(this.getId());
            result.setTitle(shows.show.title);
            result.setScore((float)shows.show.rating.average);
            result.setUrl(shows.show.url);
            if (shows.show.image != null) {
                result.setPosterUrl(shows.show.image.original);
            }
            if (StringUtils.isNotBlank((CharSequence)shows.show.summary)) {
                result.setOverview(Jsoup.parse((String)shows.show.summary).text());
            }
            result.setIMDBId(shows.show.tvShowIds.imdb);
            result.setId("tvrage", String.valueOf(shows.show.tvShowIds.tvrage));
            result.setId("tvdb", String.valueOf(shows.show.tvShowIds.thetvdb));
            result.setId("tvmaze", String.valueOf(shows.show.id));
            result.setOriginalLanguage(shows.show.language);
            if (StringUtils.isNotBlank((CharSequence)shows.show.premiered)) {
                try {
                    result.setYear(this.parseYear(shows.show.premiered));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)options.getImdbId()) && options.getImdbId().equals(result.getIMDBId()) || String.valueOf(options.getTmdbId()).equals(result.getId())) {
                LOGGER.debug("perfect match by ID - set score to 1");
                result.setScore(1.0f);
            } else {
                result.calculateScore(options);
            }
            searchResults.add(result);
        }
        return searchResults;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        int showId = options.getIdAsIntOrDefault("tvmaze", 0);
        if (showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"tvdb"});
        }
        ArrayList<Episode> episodeList = new ArrayList<Episode>();
        try {
            episodeList.addAll(this.controller.getEpisodes(showId));
        }
        catch (IOException e) {
            LOGGER.trace("could not get Episode information: {}", (Object)e.getMessage());
        }
        ArrayList<MediaMetadata> list = new ArrayList<MediaMetadata>();
        for (Episode episode : episodeList) {
            MediaMetadata md = new MediaMetadata(this.getId());
            md.setScrapeOptions(options);
            md.setTitle(episode.name);
            md.setPlot(Jsoup.parse((String)episode.summary).text());
            md.setEpisodeNumber(episode.episode);
            md.setSeasonNumber(episode.season);
            md.setRuntime(episode.runtime);
            try {
                md.setReleaseDate(this.premieredFormat.parse(episode.airdate));
                md.setYear(this.parseYear(episode.airdate));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            list.add(md);
        }
        return list;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }
}

