/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.addon.FFmpegAddon;
import org.tinymediamanager.core.Settings;

public class FFmpeg {
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpeg.class);

    private FFmpeg() {
        throw new IllegalAccessError();
    }

    public static void createStill(Path videoFile, Path stillFile, int second) throws IOException, InterruptedException {
        FFmpeg.executeCommand(FFmpeg.createCommandforStill(videoFile, stillFile, second));
    }

    private static List<String> createCommandforStill(Path videoFile, Path stillFile, int second) throws IOException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(FFmpeg.getFfmpegExecutable());
        cmdList.add("-y");
        cmdList.add("-ss");
        cmdList.add(String.valueOf(second));
        cmdList.add("-i");
        cmdList.add(videoFile.toAbsolutePath().toString());
        cmdList.add("-frames:v");
        cmdList.add("1");
        cmdList.add("-q:v");
        cmdList.add("2");
        cmdList.add(stillFile.toAbsolutePath().toString());
        return cmdList;
    }

    public static void muxVideoAndAudio(Path videoFile, Path audioFile, Path muxedFile) throws IOException, InterruptedException {
        FFmpeg.executeCommand(FFmpeg.createCommandforMux(videoFile, audioFile, muxedFile));
    }

    private static List<String> createCommandforMux(Path videoFile, Path audioFile, Path muxedFile) throws IOException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(FFmpeg.getFfmpegExecutable());
        cmdList.add("-y");
        cmdList.add("-i");
        cmdList.add(videoFile.toAbsolutePath().toString());
        cmdList.add("-i");
        cmdList.add(audioFile.toAbsolutePath().toString());
        cmdList.add("-c");
        cmdList.add("copy");
        cmdList.add(muxedFile.toAbsolutePath().toString());
        return cmdList;
    }

    public static String scanDarkLevel(float position, Path videoFile) throws IOException, InterruptedException {
        return FFmpeg.executeCommand(FFmpeg.createCommandForScanDarkLevel(position, videoFile));
    }

    private static List<String> createCommandForScanDarkLevel(float position, Path videoFile) throws IOException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(FFmpeg.getFfmpegExecutable());
        cmdList.add("-hide_banner");
        cmdList.add("-an");
        cmdList.add("-dn");
        cmdList.add("-sn");
        cmdList.add("-ss");
        cmdList.add(Float.toString(position));
        cmdList.add("-i");
        cmdList.add(videoFile.toAbsolutePath().toString());
        cmdList.add("-vf");
        cmdList.add("signalstats,metadata=print");
        cmdList.add("-vframes");
        cmdList.add("1");
        cmdList.add("-f");
        cmdList.add("null");
        cmdList.add("pipe:1");
        return cmdList;
    }

    public static String scanSample(int start, int duration, int darkLevel, Path videoFile) throws IOException, InterruptedException {
        return FFmpeg.executeCommand(FFmpeg.createCommandForScanSample(start, duration, darkLevel, videoFile));
    }

    private static List<String> createCommandForScanSample(int start, int duration, int darkLevel, Path videoFile) throws IOException {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(FFmpeg.getFfmpegExecutable());
        cmdList.add("-hide_banner");
        cmdList.add("-an");
        cmdList.add("-dn");
        cmdList.add("-sn");
        cmdList.add("-noaccurate_seek");
        cmdList.add("-t");
        cmdList.add(Integer.toString(duration));
        cmdList.add("-ss");
        cmdList.add(Integer.toString(start));
        cmdList.add("-i");
        cmdList.add(videoFile.toAbsolutePath().toString());
        cmdList.add("-vf");
        cmdList.add("cropdetect=" + darkLevel + ":2:0");
        cmdList.add("-f");
        cmdList.add("null");
        cmdList.add("pipe:1");
        return cmdList;
    }

    private static String executeCommand(List<String> cmdline) throws IOException, InterruptedException {
        LOGGER.debug("Running command: {}", (Object)String.join((CharSequence)" ", cmdline));
        ProcessBuilder pb = new ProcessBuilder(cmdline.toArray(new String[0])).redirectErrorStream(true);
        Process process = pb.start();
        try {
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                new Thread(() -> {
                    try {
                        IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)outputStream);
                    }
                    catch (IOException e) {
                        LOGGER.debug("could not get output from the process", (Throwable)e);
                    }
                }).start();
                int processValue = process.waitFor();
                String response = outputStream.toString(StandardCharsets.UTF_8);
                if (processValue != 0) {
                    LOGGER.warn("error at FFmpeg: '{}'", (Object)response);
                    throw new IOException("error running FFmpeg - code '" + processValue + "'");
                }
                string = response;
            }
            return string;
        }
        finally {
            if (process != null) {
                process.destroy();
                IOUtils.close((Closeable)process.getErrorStream());
            }
        }
    }

    public static boolean isAvailable() {
        FFmpegAddon fFmpegAddon = new FFmpegAddon();
        return !Settings.getInstance().isUseInternalMediaFramework() && StringUtils.isNotBlank((CharSequence)Settings.getInstance().getMediaFramework()) || fFmpegAddon.isAvailable();
    }

    private static String getFfmpegExecutable() throws IOException {
        FFmpegAddon fFmpegAddon = new FFmpegAddon();
        if (!Settings.getInstance().isUseInternalMediaFramework() && StringUtils.isNotBlank((CharSequence)Settings.getInstance().getMediaFramework())) {
            return Settings.getInstance().getMediaFramework();
        }
        if (fFmpegAddon.isAvailable()) {
            return fFmpegAddon.getExecutablePath();
        }
        throw new IOException("FFmpeg is not available");
    }
}

