/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.call.Application;
import org.tinymediamanager.jsonrpc.api.call.AudioLibrary;
import org.tinymediamanager.jsonrpc.api.call.Files;
import org.tinymediamanager.jsonrpc.api.call.System;
import org.tinymediamanager.jsonrpc.api.call.VideoLibrary;
import org.tinymediamanager.jsonrpc.api.model.ApplicationModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiCallback;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.ConnectionListener;
import org.tinymediamanager.jsonrpc.io.JavaConnectionManager;
import org.tinymediamanager.jsonrpc.io.JsonApiRequest;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;
import org.tinymediamanager.scraper.util.StrgUtils;

public class KodiRPC {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiRPC.class);
    private static KodiRPC instance;
    private static final String SEPARATOR_REGEX = "[\\/\\\\]+";
    private final JavaConnectionManager connectionManager = new JavaConnectionManager();
    private final Map<String, String> videodatasources = new HashMap<String, String>();
    private final List<String> audiodatasources = new ArrayList<String>();
    private final Map<UUID, Integer> moviemappings = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> tvshowmappings = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> episodemappings = new HashMap<UUID, Integer>();
    private String kodiVersion = "";

    private KodiRPC() {
        this.connectionManager.registerConnectionListener(new ConnectionListener(){

            public void notificationReceived(AbstractEvent event) {
                LOGGER.debug("Event received: {}", (Object)event);
            }

            public void disconnected() {
                LOGGER.info("Event: Disconnected");
                MessageManager.instance.pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi disconnected"));
            }

            public void connected() {
                LOGGER.info("Event: Connected to {}", (Object)KodiRPC.this.connectionManager.getHostConfig().getAddress());
                MessageManager.instance.pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi connected"));
            }
        });
    }

    public static synchronized KodiRPC getInstance() {
        if (instance == null) {
            instance = new KodiRPC();
        }
        return instance;
    }

    public boolean isConnected() {
        return this.connectionManager.isConnected();
    }

    public String getVersion() {
        return "Kodi " + this.kodiVersion;
    }

    public void cleanVideoLibrary() {
        VideoLibrary.Clean call = new VideoLibrary.Clean(Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanVideoLibrary() {
        VideoLibrary.Scan call = new VideoLibrary.Scan(null, Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanVideoLibrary(String dir) {
        VideoLibrary.Scan call = new VideoLibrary.Scan(dir, Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public Map<String, String> getVideoDataSources() {
        return this.videodatasources;
    }

    private void getAndSetVideoDataSources() {
        Files.GetSources call = new Files.GetSources("video");
        this.send((AbstractCall<?>)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            this.videodatasources.clear();
            try {
                for (ListModel.SourceItem res : call.getResults()) {
                    LOGGER.debug("Kodi datasource: {}", (Object)res.file);
                    this.videodatasources.put(res.file, res.label);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
        }
    }

    private String detectDatasource(String file) {
        for (String ds : this.videodatasources.keySet()) {
            if (!file.startsWith(ds)) continue;
            return ds;
        }
        return "";
    }

    protected void getAndSetMovieMappings() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies(new String[]{"file"});
        this.send((AbstractCall<?>)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            this.moviemappings.clear();
            HashMap<CallSite, Integer> kodiDsAndFolder = new HashMap<CallSite, Integer>();
            for (VideoModel.MovieDetail movie : call.getResults()) {
                if (movie.file.startsWith("stack")) {
                    String[] files;
                    for (String s : files = movie.file.split(" , ")) {
                        s = s.replaceFirst("^stack://", "");
                        String ds = this.detectDatasource(s);
                        String rel = s.replace(ds, "");
                        rel = rel.replaceAll(SEPARATOR_REGEX, "/");
                        ds = ds.replaceAll("[\\/\\\\]+$", "");
                        ds = ds.replaceAll(".*[\\/\\\\]+", "");
                        kodiDsAndFolder.put((CallSite)((Object)(ds + "|" + rel)), movie.movieid);
                    }
                    continue;
                }
                String ds = this.detectDatasource(movie.file);
                String rel = movie.file.replace(ds, "");
                rel = rel.replaceAll(SEPARATOR_REGEX, "/");
                ds = ds.replaceAll("[\\/\\\\]+$", "");
                ds = ds.replaceAll(".*[\\/\\\\]+", "");
                kodiDsAndFolder.put((CallSite)((Object)(ds + "|" + rel)), movie.movieid);
            }
            LOGGER.debug("KODI {} movies", (Object)call.getResults().size());
            Map<String, UUID> tmmDsAndFolder = this.prepareMovieFileMap(MovieModuleManager.getInstance().getMovieList().getMovies());
            LOGGER.debug("TMM {} movies", (Object)tmmDsAndFolder.size());
            for (Map.Entry<String, UUID> entry : tmmDsAndFolder.entrySet()) {
                String key = entry.getKey();
                UUID value = entry.getValue();
                Integer kodiId = (Integer)kodiDsAndFolder.get(key);
                if (kodiId == null || kodiId <= 0) continue;
                this.moviemappings.put(value, kodiId);
            }
            LOGGER.debug("mapped {} movies", (Object)this.moviemappings.size());
        }
    }

    private Map<String, UUID> prepareMovieFileMap(List<Movie> movies) {
        HashMap<String, UUID> fileMap = new HashMap<String, UUID>();
        for (Movie movie : movies) {
            fileMap.putAll(this.parseEntity(movie, movie.isDisc()));
        }
        return fileMap;
    }

    private Map<String, UUID> prepareEpisodeFileMap(TvShow show) {
        HashMap<String, UUID> fileMap = new HashMap<String, UUID>();
        for (TvShowEpisode ep : show.getEpisodes()) {
            fileMap.putAll(this.parseEntity(ep, ep.isDisc()));
        }
        return fileMap;
    }

    private Map<String, UUID> parseEntity(MediaEntity entity, boolean isDisc) {
        HashMap<String, UUID> fileMap = new HashMap<String, UUID>();
        Path ds = Paths.get(entity.getDataSource(), new String[0]);
        String dsName = ds.getFileName().toString();
        MediaFile main = entity.getMainFile();
        if (isDisc) {
            for (MediaFile mf : entity.getMediaFiles(MediaFileType.VIDEO)) {
                Path file = null;
                if (mf.getFilename().equalsIgnoreCase("VIDEO_TS")) {
                    file = mf.getFileAsPath().resolve("VIDEO_TS.IFO");
                } else if (mf.getFilename().equalsIgnoreCase("HVDVD_TS")) {
                    file = mf.getFileAsPath().resolve("HV000I01.IFO");
                } else if (mf.getFilename().equalsIgnoreCase("BDMV")) {
                    file = mf.getFileAsPath().resolve("index.bdmv");
                } else if (mf.isMainDiscIdentifierFile()) {
                    file = mf.getFileAsPath();
                }
                if (file == null) continue;
                String rel = Utils.relPath(ds, file);
                rel = rel.replaceAll(SEPARATOR_REGEX, "/");
                fileMap.put(dsName + "|" + rel, entity.getDbId());
            }
        } else {
            String rel = Utils.relPath(ds, main.getFileAsPath());
            rel = rel.replaceAll(SEPARATOR_REGEX, "/");
            fileMap.put(dsName + "|" + rel, entity.getDbId());
        }
        return fileMap;
    }

    protected void getAndSetTvShowMappings() {
        VideoLibrary.GetTVShows tvShowCall = new VideoLibrary.GetTVShows(new String[]{"file"});
        this.send((AbstractCall<?>)tvShowCall);
        if (tvShowCall.getResults() != null && !tvShowCall.getResults().isEmpty()) {
            Object ds;
            this.tvshowmappings.clear();
            this.episodemappings.clear();
            HashMap<CallSite, Integer> kodiDsAndFolder = new HashMap<CallSite, Integer>();
            for (VideoModel.TVShowDetail show : tvShowCall.getResults()) {
                ds = this.detectDatasource(show.file);
                String rel = show.file.replace((CharSequence)ds, "");
                rel = rel.replaceAll("[\\/\\\\]+$", "");
                rel = rel.replaceAll(SEPARATOR_REGEX, "/");
                ds = ((String)ds).replaceAll("[\\/\\\\]+$", "");
                ds = ((String)ds).replaceAll(".*[\\/\\\\]+", "");
                kodiDsAndFolder.put((CallSite)((Object)((String)ds + "|" + rel)), show.tvshowid);
            }
            LOGGER.debug("KODI {} shows", (Object)kodiDsAndFolder.size());
            LOGGER.debug("TMM {} shows", (Object)TvShowModuleManager.getInstance().getTvShowList().getTvShows().size());
            for (TvShow tmmShow : TvShowModuleManager.getInstance().getTvShowList().getTvShows()) {
                ds = Paths.get(tmmShow.getDataSource(), new String[0]);
                String dsName = ds.getFileName().toString();
                String rel = Utils.relPath((Path)ds, tmmShow.getPathNIO());
                Integer kodiId = (Integer)kodiDsAndFolder.get(dsName + "|" + (rel = rel.replaceAll(SEPARATOR_REGEX, "/")));
                if (kodiId == null || kodiId <= 0) continue;
                this.tvshowmappings.put(tmmShow.getDbId(), kodiId);
            }
            LOGGER.debug("mapped {} shows", (Object)this.tvshowmappings.size());
        }
    }

    public void refreshFromNfo(Movie movie) {
        Integer kodiID = this.moviemappings.get(movie.getDbId());
        if (kodiID != null) {
            List<MediaFile> nfo = movie.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.info("Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.error("No NFO file found to refresh! {}", (Object)movie.getTitle());
            }
            VideoLibrary.RefreshMovie call = new VideoLibrary.RefreshMovie(kodiID, Boolean.valueOf(false));
            this.sendWoResponse((AbstractCall<?>)call);
        } else {
            LOGGER.error("Unable to refresh - could not map '{}' to Kodi library! {}", (Object)movie.getTitle(), (Object)movie.getDbId());
        }
    }

    public void refreshFromNfo(TvShow tvShow) {
        Integer kodiID = this.tvshowmappings.get(tvShow.getDbId());
        if (kodiID != null) {
            List<MediaFile> nfo = tvShow.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.info("Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.error("No NFO file found to refresh! {}", (Object)tvShow.getTitle());
            }
            VideoLibrary.RefreshTVShow call = new VideoLibrary.RefreshTVShow(kodiID, Boolean.valueOf(false), Boolean.valueOf(true));
            this.sendWoResponse((AbstractCall<?>)call);
        } else {
            LOGGER.error("Unable to refresh - could not map '{}' to Kodi library! {}", (Object)tvShow.getTitle(), (Object)tvShow.getDbId());
        }
    }

    public void refreshFromNfo(TvShowEpisode episode) {
        Integer kodiID = this.getEpisodeId(episode);
        if (kodiID != null) {
            List<MediaFile> nfo = episode.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.info("Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.error("No NFO file found to refresh! {}", (Object)episode.getTitle());
            }
            VideoLibrary.RefreshEpisode call = new VideoLibrary.RefreshEpisode(kodiID, Boolean.valueOf(false));
            this.sendWoResponse((AbstractCall<?>)call);
        } else {
            LOGGER.error("Unable to refresh - could not map '{}' to Kodi library! {}", (Object)episode.getTitle(), (Object)episode.getDbId());
        }
    }

    public void readWatchedState(Movie movie) {
        Integer kodiID = this.moviemappings.get(movie.getDbId());
        if (kodiID != null) {
            VideoLibrary.GetMovieDetails call = new VideoLibrary.GetMovieDetails(kodiID, new String[]{"playcount", "lastplayed"});
            this.send((AbstractCall<?>)call);
            if (call.getResult() != null && ((VideoModel.MovieDetail)call.getResult()).playcount != null) {
                movie.setPlaycount(((VideoModel.MovieDetail)call.getResult()).playcount);
                if (((VideoModel.MovieDetail)call.getResult()).playcount > 0) {
                    movie.setWatched(true);
                    try {
                        movie.setLastWatched(StrgUtils.parseDate(((VideoModel.MovieDetail)call.getResult()).lastplayed));
                    }
                    catch (Exception e) {
                        movie.setLastWatched(new Date());
                    }
                } else {
                    movie.setWatched(false);
                    movie.setLastWatched(null);
                }
                movie.writeNFO();
                movie.setLastWatched(null);
                movie.saveToDb();
            }
        } else {
            LOGGER.error("Unable get playcount - could not map '{}' to Kodi library! {}", (Object)movie.getTitle(), (Object)movie.getDbId());
        }
    }

    public void readWatchedState(TvShowEpisode episode) {
        Integer kodiID = this.getEpisodeId(episode);
        if (kodiID != null) {
            VideoLibrary.GetEpisodeDetails call = new VideoLibrary.GetEpisodeDetails(kodiID, new String[]{"playcount", "lastplayed"});
            this.send((AbstractCall<?>)call);
            if (call.getResult() != null && ((VideoModel.EpisodeDetail)call.getResult()).playcount != null) {
                episode.setPlaycount(((VideoModel.EpisodeDetail)call.getResult()).playcount);
                if (((VideoModel.EpisodeDetail)call.getResult()).playcount > 0) {
                    episode.setWatched(true);
                    try {
                        episode.setLastWatched(StrgUtils.parseDate(((VideoModel.EpisodeDetail)call.getResult()).lastplayed));
                    }
                    catch (Exception e) {
                        episode.setLastWatched(new Date());
                    }
                } else {
                    episode.setWatched(false);
                    episode.setLastWatched(null);
                }
                episode.writeNFO();
                episode.setLastWatched(null);
                episode.saveToDb();
            }
        } else {
            LOGGER.error("Unable get playcount - could not map '{}' to Kodi library! {}", (Object)episode.getTitle(), (Object)episode.getDbId());
        }
    }

    public Integer getEpisodeId(TvShowEpisode episode) {
        Integer kodiShowId = this.tvshowmappings.get(episode.getTvShowDbId());
        if (kodiShowId == null) {
            return null;
        }
        Integer kodiEpId = this.episodemappings.get(episode.getDbId());
        if (kodiEpId == null) {
            this.getAndSetTvShowEpisodeMappings(episode.getTvShow(), kodiShowId);
            kodiEpId = this.episodemappings.get(episode.getDbId());
        }
        return kodiEpId;
    }

    protected synchronized void getAndSetTvShowEpisodeMappings(TvShow tmmShow, Integer kodiShowId) {
        VideoLibrary.GetEpisodes episodeCall = new VideoLibrary.GetEpisodes(kodiShowId, new String[]{"file"});
        this.send((AbstractCall<?>)episodeCall);
        if (episodeCall.getResults() != null && !episodeCall.getResults().isEmpty()) {
            HashMap<CallSite, Integer> kodiDsAndFolder = new HashMap<CallSite, Integer>();
            for (VideoModel.EpisodeDetail ep : episodeCall.getResults()) {
                String ds = this.detectDatasource(ep.file);
                String rel = ep.file.replace(ds, "");
                rel = rel.replaceAll(SEPARATOR_REGEX, "/");
                ds = ds.replaceAll("[\\/\\\\]+$", "");
                ds = ds.replaceAll(".*[\\/\\\\]+", "");
                kodiDsAndFolder.put((CallSite)((Object)(ds + "|" + rel)), ep.episodeid);
            }
            LOGGER.debug("KODI {} episodes", (Object)kodiDsAndFolder.size());
            Map<String, UUID> tmmDsAndFolder = this.prepareEpisodeFileMap(tmmShow);
            LOGGER.debug("TMM {} episodes", (Object)tmmDsAndFolder.size());
            for (Map.Entry<String, UUID> entry : tmmDsAndFolder.entrySet()) {
                String key = entry.getKey();
                UUID value = entry.getValue();
                Integer kodiId = (Integer)kodiDsAndFolder.get(key);
                if (kodiId == null || kodiId <= 0) continue;
                this.episodemappings.put(value, kodiId);
            }
            LOGGER.debug("mapped {} episodes for {}", (Object)this.episodemappings.size(), (Object)tmmShow.getTitle());
        }
    }

    public void cleanAudioLibrary() {
        AudioLibrary.Clean call = new AudioLibrary.Clean(Boolean.valueOf(true));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanAudioLibrary() {
        AudioLibrary.Scan call = new AudioLibrary.Scan(null);
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void scanAudioLibrary(String dir) {
        AudioLibrary.Scan call = new AudioLibrary.Scan(dir);
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public List<String> getAudioDataSources() {
        return this.audiodatasources;
    }

    private void getAndSetAudioDataSources() {
        Files.GetSources call = new Files.GetSources("music");
        this.send((AbstractCall<?>)call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            this.audiodatasources.clear();
            try {
                for (ListModel.SourceItem res : call.getResults()) {
                    this.audiodatasources.add(res.file);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
        }
    }

    public String getKodiVersion() {
        Application.GetProperties call = new Application.GetProperties(new String[]{"version"});
        this.send((AbstractCall<?>)call);
        try {
            ApplicationModel.PropertyValue res = (ApplicationModel.PropertyValue)call.getResult();
            int maj = res.version.major;
            int min = res.version.minor;
            return maj + "." + min;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void quitApplication() {
        Application.Quit call = new Application.Quit();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void muteApplication() {
        Application.GetProperties props = new Application.GetProperties(new String[]{"muted"});
        this.send((AbstractCall<?>)props);
        if (props.getResults() != null && !props.getResults().isEmpty()) {
            Application.SetMute call = new Application.SetMute(new GlobalModel.Toggle(Boolean.valueOf(((ApplicationModel.PropertyValue)props.getResult()).muted == false)));
            this.sendWoResponse((AbstractCall<?>)call);
        }
    }

    public void setVolume(int vol) {
        Application.SetVolume call = new Application.SetVolume(Integer.valueOf(vol));
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemEjectOpticalDrive() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemHibernate() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemShutdown() {
        System.Shutdown call = new System.Shutdown();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemReboot() {
        System.Reboot call = new System.Reboot();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void SystemSuspend() {
        System.Suspend call = new System.Suspend();
        this.sendWoResponse((AbstractCall<?>)call);
    }

    public void send(AbstractCall<?> call) {
        if (!this.isConnected()) {
            LOGGER.warn("Cannot send RPC call - not connected");
            return;
        }
        try {
            call.setResponse((JsonNode)JsonApiRequest.execute((HostConfig)this.connectionManager.getHostConfig(), (ObjectNode)call.getRequest()));
        }
        catch (ApiException e) {
            LOGGER.error("Error calling Kodi: {}", (Object)e.getMessage());
        }
    }

    public void sendWoResponse(AbstractCall<?> call) {
        if (!this.isConnected()) {
            LOGGER.warn("Cannot send RPC call - not connected");
            return;
        }
        try {
            JsonApiRequest.execute((HostConfig)this.connectionManager.getHostConfig(), (ObjectNode)call.getRequest());
        }
        catch (ApiException e) {
            LOGGER.error("Error calling Kodi: {}", (Object)e.getMessage());
        }
    }

    public void connect(HostConfig config) throws Exception {
        if (this.isConnected()) {
            this.connectionManager.disconnect();
        }
        new Thread(() -> {
            try {
                LOGGER.info("Connecting to {}...", (Object)config.getAddress());
                this.connectionManager.connect(config);
                if (this.isConnected()) {
                    this.kodiVersion = this.getKodiVersion();
                    this.getAndSetVideoDataSources();
                    this.getAndSetAudioDataSources();
                    this.getAndSetMovieMappings();
                    this.getAndSetTvShowMappings();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error connecting to Kodi - '{}'", (Object)e.getMessage());
            }
        }).start();
    }

    public void connect() {
        Settings s = Settings.getInstance();
        if (s.getKodiHost().isEmpty()) {
            return;
        }
        try {
            this.connect(new HostConfig(s.getKodiHost(), s.getKodiHttpPort(), s.getKodiTcpPort(), s.getKodiUsername(), s.getKodiPassword()));
        }
        catch (Exception cex) {
            LOGGER.error("Error connecting to Kodi instance! {}", (Object)cex.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "KodiRPC", "Could not connect to Kodi: " + cex.getMessage()));
        }
    }

    public void disconnect() {
        this.connectionManager.disconnect();
    }

    public void updateMovieMappings() {
        if (this.isConnected()) {
            this.getAndSetMovieMappings();
        }
    }

    public void updateTvShowMappings() {
        if (this.isConnected()) {
            this.getAndSetTvShowMappings();
        }
    }

    public List<VideoModel.MovieDetail> getAllMoviesSYNC() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies(new String[]{"file"});
        this.send((AbstractCall<?>)call);
        return call.getResults();
    }

    public void getAllMoviesASYNC() {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies(new String[]{"file"});
        this.connectionManager.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.MovieDetail>(){

            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public void triggerReload(Movie movie) {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies(new String[]{"file"});
        this.connectionManager.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.MovieDetail>(){

            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }

    public void getAllTvShows() {
        VideoLibrary.GetTVShows vl = new VideoLibrary.GetTVShows(new String[0]);
        this.connectionManager.call((AbstractCall)vl, (ApiCallback)new ApiCallback<VideoModel.TVShowDetail>(){

            public void onResponse(AbstractCall<VideoModel.TVShowDetail> call) {
                LOGGER.info("found " + call.getResults().size() + " shows");
                for (VideoModel.TVShowDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            public void onError(int code, String message, String hint) {
                LOGGER.error("Error {}: {}", (Object)code, (Object)message);
            }
        });
    }
}

