/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;

public class VSMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(VSMeta.class);
    private static final byte TAG_TITLE1 = 18;
    private static final byte TAG_TITLE2 = 26;
    private static final byte TAG_TITLE3 = 34;
    private static final byte TAG_YEAR = 40;
    private static final byte TAG_RELEASE_DATE = 50;
    private static final byte TAG_LOCKED = 56;
    private static final byte TAG_SUMMARY = 66;
    private static final byte TAG_META_JSON = 74;
    private static final byte TAG_CLASSIFICATION = 90;
    private static final byte TAG_RATING = 96;
    private static final int TAG_POSTER_DATA = 138;
    private static final int TAG_POSTER_MD5 = 146;
    private static final int TAG_GROUP3 = 170;
    private static final byte TAG_GROUP1 = 82;
    private static final byte TAG1_CAST = 10;
    private static final byte TAG1_DIRECTOR = 18;
    private static final byte TAG1_GENRE = 26;
    private static final byte TAG1_WRITER = 34;
    private static final int TAG_GROUP2 = 154;
    private static final byte TAG2_SEASON = 8;
    private static final byte TAG2_EPISODE = 16;
    private static final byte TAG2_RELEASE_DATE_TV_SHOW = 34;
    private static final byte TAG2_LOCKED = 40;
    private static final byte TAG2_TVSHOW_YEAR = 24;
    private static final byte TAG2_TVSHOW_SUMMARY = 50;
    private static final byte TAG2_TVSHOW_POSTER_DATA = 58;
    private static final byte TAG2_TVSHOW_POSTER_MD5 = 66;
    private static final byte TAG2_TVSHOW_META_JSON = 74;
    private static final byte TAG2_GROUP3 = 82;
    private static final byte TAG3_BACKDROP_DATA = 10;
    private static final byte TAG3_BACKDROP_MD5 = 18;
    private static final byte TAG3_TIMESTAMP = 24;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final Info info = new Info();
    private final HashMap<String, Object> ids = new HashMap(0);
    private Path vsMetaFile = null;
    private String basename = "";
    private MovieSet movieSet = null;
    private float rating = 0.0f;
    private final List<MediaArtwork> artworks = new ArrayList<MediaArtwork>(0);

    static SyncStream openSync(byte[] data) {
        return new MemorySyncStream(data);
    }

    public VSMeta(Path file) {
        this.vsMetaFile = file;
        this.basename = FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)file.getFileName().toString()));
    }

    private void writeImage(Path file, byte[] bytes) {
        try {
            LOGGER.debug("SYNO: write image to filesystem: {}", (Object)file);
            Files.write(file, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Could not write image {}", (Object)file, (Object)e);
        }
    }

    public List<MediaFile> generateMediaFile(MediaEntity entity) {
        MediaFile mf;
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        if (this.info.images.poster != null) {
            mf = null;
            if (entity instanceof Movie) {
                mf = new MediaFile(this.vsMetaFile.getParent().resolve(this.basename + "-poster.jpg"), MediaFileType.POSTER);
            } else if (entity instanceof TvShowEpisode) {
                mf = new MediaFile(this.vsMetaFile.getParent().resolve(this.basename + "-thumb.jpg"), MediaFileType.THUMB);
            }
            if (mf != null && !mf.exists() && !Files.exists(this.vsMetaFile.getParent().resolve("poster.jpg"), new LinkOption[0])) {
                this.writeImage(mf.getFileAsPath(), this.info.images.poster);
                mfs.add(mf);
            }
        }
        if (this.info.images.backdrop != null) {
            mf = null;
            if (entity instanceof Movie) {
                mf = new MediaFile(this.vsMetaFile.getParent().resolve(this.basename + "-fanart.jpg"), MediaFileType.FANART);
            }
            if (entity instanceof TvShow) {
                mf = new MediaFile(entity.getPathNIO().resolve("fanart.jpg"), MediaFileType.FANART);
            }
            if (mf != null && !mf.exists() && !Files.exists(this.vsMetaFile.getParent().resolve("fanart.jpg"), new LinkOption[0])) {
                this.writeImage(mf.getFileAsPath(), this.info.images.backdrop);
                mfs.add(mf);
            }
        }
        if (this.info.images.showImage != null) {
            mf = null;
            if (entity instanceof TvShow) {
                mf = new MediaFile(entity.getPathNIO().resolve("poster.jpg"), MediaFileType.POSTER);
            }
            if (mf != null && !mf.exists()) {
                this.writeImage(mf.getFileAsPath(), this.info.images.showImage);
                mfs.add(mf);
            }
        }
        return mfs;
    }

    public void parseFile() {
        try {
            MemorySyncStream data = new MemorySyncStream(Files.readAllBytes(this.vsMetaFile));
            int magic = data.readU8();
            int version = data.readU8();
            if (magic != 8) {
                throw new Exception("Not a vsmeta archive");
            }
            if (version != 2) {
                // empty if block
            }
            LOGGER.debug("SYNO: found valid .vsmeta ({}, Version " + version + ") - try to parse metadata...", (Object)this.vsMetaFile);
            block21: while (!data.eof()) {
                long pos = data.position();
                int kind = data.readU_VL_Int();
                switch (kind) {
                    case 18: {
                        this.info.title1 = data.readStringVL();
                        continue block21;
                    }
                    case 26: {
                        this.info.title2 = data.readStringVL();
                        continue block21;
                    }
                    case 34: {
                        this.info.title3 = data.readStringVL();
                        continue block21;
                    }
                    case 40: {
                        this.info.year = data.readU_VL_Int();
                        continue block21;
                    }
                    case 50: {
                        try {
                            this.info.releaseDate = this.dateFormat.parse(data.readStringVL());
                        }
                        catch (ParseException e) {
                            LOGGER.warn("Could not parse date...");
                        }
                        continue block21;
                    }
                    case 56: {
                        this.info.locked = data.readU_VL_Int() != 0;
                        continue block21;
                    }
                    case 66: {
                        this.info.summary = data.readStringVL();
                        continue block21;
                    }
                    case 74: {
                        this.info.entityJson = data.readStringVL();
                        this.parseJSON();
                        continue block21;
                    }
                    case 82: {
                        byte[] groupSize = data.readBytesVL();
                        this.parseGroup(VSMeta.openSync(groupSize), this.info);
                        continue block21;
                    }
                    case 90: {
                        this.info.classification = data.readStringVL();
                        continue block21;
                    }
                    case 96: {
                        int it = data.readU_VL_Int();
                        if (it < 0) {
                            this.info.rating = null;
                            continue block21;
                        }
                        this.info.rating = (double)it / 10.0;
                        continue block21;
                    }
                    case 138: {
                        this.info.images.poster = this.fromBase64IgnoreSpaces(data.readStringVL());
                        continue block21;
                    }
                    case 170: {
                        int data3Size = data.readU_VL_Int();
                        long pos3 = (int)data.position();
                        byte[] meta3 = data.readBytes(data3Size);
                        this.parseGroup3(VSMeta.openSync(meta3), this.info, (int)pos3);
                        continue block21;
                    }
                    case 146: {
                        data.readStringVL();
                        continue block21;
                    }
                    case 154: {
                        int dataSize = data.readU_VL_Int();
                        long pos2 = data.position();
                        byte[] meta = data.readBytes(dataSize);
                        this.parseGroup2(VSMeta.openSync(meta), this.info, (int)pos2);
                        continue block21;
                    }
                }
                LOGGER.warn("[MAIN] Unexpected kind={} at {} - try skipping", (Object)Integer.toHexString(kind), (Object)pos);
                data.readStringVL();
            }
        }
        catch (Exception e) {
            LOGGER.warn("SYNO: Error parsing file ({})", (Object)this.vsMetaFile, (Object)e);
        }
    }

    private void parseGroup(SyncStream s, Info info) {
        block6: while (!s.eof()) {
            long pos = s.position();
            int kind = s.readU_VL_Int();
            switch (kind) {
                case 10: {
                    info.list.cast.add(s.readStringVL());
                    continue block6;
                }
                case 18: {
                    info.list.director.add(s.readStringVL());
                    continue block6;
                }
                case 26: {
                    info.list.genre.add(s.readStringVL());
                    continue block6;
                }
                case 34: {
                    info.list.writer.add(s.readStringVL());
                    continue block6;
                }
            }
            LOGGER.warn("[GROUP1] Unexpected kind={} at {}", (Object)kind, (Object)pos);
        }
    }

    private void parseGroup2(SyncStream s, Info info, int start) {
        block14: while (!s.eof()) {
            long pos = s.position();
            int kind = s.readU_VL_Int();
            switch (kind) {
                case 8: {
                    info.season = s.readU_VL_Int();
                    continue block14;
                }
                case 16: {
                    info.episode = s.readU_VL_Int();
                    continue block14;
                }
                case 24: {
                    info.tvshowYear = s.readU_VL_Int();
                    continue block14;
                }
                case 34: {
                    try {
                        info.tvshowReleaseDate = this.dateFormat.parse(s.readStringVL());
                    }
                    catch (ParseException e) {
                        LOGGER.warn("Could not parse date...");
                    }
                    continue block14;
                }
                case 40: {
                    info.tvshowLocked = s.readU_VL_Int() != 0;
                    continue block14;
                }
                case 50: {
                    info.tvshowSummary = s.readStringVL();
                    continue block14;
                }
                case 58: {
                    info.images.showImage = this.fromBase64IgnoreSpaces(s.readStringVL());
                    continue block14;
                }
                case 66: {
                    String md5 = s.readStringVL();
                    continue block14;
                }
                case 74: {
                    info.tvShowJson = s.readStringVL();
                    continue block14;
                }
                case 82: {
                    int dataSize = s.readU_VL_Int();
                    int start2 = (int)s.position();
                    byte[] data = s.readBytes(dataSize);
                    this.parseGroup3(VSMeta.openSync(data), info, start2 + start);
                    continue block14;
                }
            }
            LOGGER.warn("[GROUP2] Unexpected kind={} at {}", (Object)kind, (Object)pos);
        }
    }

    private void parseGroup3(SyncStream s, Info info, int start) {
        block5: while (!s.eof()) {
            long pos = s.position();
            int kind = s.readU_VL_Int();
            switch (kind) {
                case 10: {
                    info.images.backdrop = this.fromBase64IgnoreSpaces(s.readStringVL());
                    continue block5;
                }
                case 18: {
                    String md5 = s.readStringVL();
                    continue block5;
                }
                case 24: {
                    info.timestamp = new Date(s.readU_VL_Long() * 1000L);
                    continue block5;
                }
            }
            LOGGER.warn("[GROUP3] Unexpected kind={} at {}", (Object)kind, (Object)pos);
        }
    }

    private byte[] fromBase64IgnoreSpaces(String str) {
        byte[] ret = null;
        try {
            ret = Base64.getDecoder().decode(str.replaceAll("\\s+", ""));
        }
        catch (Exception e) {
            LOGGER.warn("Could not decode image: {}", (Object)e.getMessage());
        }
        return ret;
    }

    private void parseJSON() {
        if (StringUtils.isBlank((CharSequence)this.info.entityJson) || "null".equals(this.info.entityJson)) {
            return;
        }
        try {
            LOGGER.trace("SYNO: try to parse additional JSON info...");
            JsonReader reader = new JsonReader((Reader)new StringReader(this.info.entityJson));
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.startsWith("com.synology")) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        String value;
                        String key;
                        MediaArtwork ma;
                        String value2;
                        name = reader.nextName();
                        if (name.equals("backdrop")) {
                            reader.beginArray();
                            while (reader.hasNext()) {
                                value2 = reader.nextString();
                                LOGGER.trace("SYNO: found backdrop: " + value2);
                                ma = new MediaArtwork("com.synology", MediaArtwork.MediaArtworkType.BACKGROUND);
                                ma.setDefaultUrl(value2);
                                this.artworks.add(ma);
                            }
                            reader.endArray();
                            continue;
                        }
                        if (name.equals("poster")) {
                            reader.beginArray();
                            while (reader.hasNext()) {
                                value2 = reader.nextString();
                                LOGGER.trace("SYNO: found poster: " + value2);
                                ma = new MediaArtwork("com.synology", MediaArtwork.MediaArtworkType.POSTER);
                                ma.setDefaultUrl(value2);
                                this.artworks.add(ma);
                            }
                            reader.endArray();
                            continue;
                        }
                        if (name.equals("rating")) {
                            reader.beginObject();
                            while (reader.hasNext()) {
                                key = reader.nextName();
                                value = reader.nextString();
                                LOGGER.trace("SYNO: found rating: " + key + " - " + value);
                                try {
                                    float f;
                                    this.rating = f = Float.parseFloat(value);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                            reader.endObject();
                            continue;
                        }
                        if (name.equals("reference")) {
                            reader.beginObject();
                            block31: while (reader.hasNext()) {
                                key = reader.nextName();
                                value = reader.nextString();
                                LOGGER.trace("SYNO: found ID: " + key + " = " + value);
                                switch (key) {
                                    case "synovideodb": {
                                        this.ids.put(key, value);
                                        continue block31;
                                    }
                                    case "imdb": {
                                        this.ids.put("imdb", value);
                                        continue block31;
                                    }
                                    case "thetvdb": {
                                        this.ids.put("tvdb", value);
                                        continue block31;
                                    }
                                    case "themoviedb": {
                                        try {
                                            int t = Integer.parseInt(value);
                                            this.ids.put("tmdb", t);
                                        }
                                        catch (NumberFormatException t) {}
                                        continue block31;
                                    }
                                }
                                LOGGER.trace("SYNO: yet unknown key '{}' - please add!", (Object)key);
                            }
                            reader.endObject();
                            continue;
                        }
                        if (name.equals("collection_id")) {
                            reader.beginObject();
                            while (reader.hasNext()) {
                                key = reader.nextName();
                                value = reader.nextString();
                                LOGGER.trace("SYNO: found SetID: " + key + " = " + value);
                                switch (key) {
                                    case "themoviedb": {
                                        try {
                                            int t = Integer.parseInt(value);
                                            this.movieSet = MovieModuleManager.getInstance().getMovieList().getMovieSet(this.info.title1 + "_col", t);
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                        break;
                                    }
                                }
                            }
                            reader.endObject();
                            continue;
                        }
                        reader.skipValue();
                    }
                } else {
                    reader.skipValue();
                }
                reader.endObject();
            }
            reader.endObject();
            reader.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not parse Synology VSMETA JSON part!", (Throwable)e);
        }
    }

    public byte[] getPosterBytes() {
        if (this.info == null || this.info.images == null || this.info.images.poster == null) {
            return new byte[0];
        }
        return this.info.images.poster;
    }

    public byte[] getBackdropBytes() {
        if (this.info == null || this.info.images == null || this.info.images.backdrop == null) {
            return new byte[0];
        }
        return this.info.images.backdrop;
    }

    public byte[] getShowImageBytes() {
        if (this.info == null || this.info.images == null || this.info.images.showImage == null) {
            return new byte[0];
        }
        return this.info.images.showImage;
    }

    public Movie getMovie() {
        Movie m = new Movie();
        m.setIds(this.ids);
        m.setTitle(this.info.title1);
        m.setTagline(this.info.title3);
        m.setPlot(this.info.summary);
        m.setReleaseDate(this.info.releaseDate);
        try {
            m.setYear(this.info.year);
        }
        catch (Exception e) {
            m.setYear(0);
        }
        if (this.rating > 0.0f) {
            MediaRating r = new MediaRating("NFO", this.rating);
            m.setRating(r);
        }
        m.setCertification(MediaCertification.findCertification(this.info.classification));
        if (this.movieSet != null) {
            m.setMovieSet(this.movieSet);
        }
        for (MediaArtwork mediaArtwork : this.artworks) {
            m.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.getMediaFileType(mediaArtwork.getType()));
        }
        LinkedHashSet<MediaGenres> genres = new LinkedHashSet<MediaGenres>();
        for (String string : this.info.list.genre) {
            genres.add(MediaGenres.getGenre(string));
        }
        m.addToGenres(genres);
        ArrayList<Person> arrayList = new ArrayList<Person>();
        for (String string : this.info.list.cast) {
            Person mcm = new Person(Person.Type.ACTOR);
            mcm.setName(string);
            arrayList.add(new Person(mcm));
        }
        m.addToActors(arrayList);
        ArrayList<Person> arrayList2 = new ArrayList<Person>();
        for (String dir : this.info.list.director) {
            Person mcm = new Person(Person.Type.DIRECTOR);
            mcm.setName(dir);
            arrayList2.add(new Person(mcm));
        }
        m.addToDirectors(arrayList2);
        ArrayList<Person> arrayList3 = new ArrayList<Person>();
        for (String writ : this.info.list.writer) {
            Person mcm = new Person(Person.Type.WRITER);
            mcm.setName(writ);
            arrayList3.add(new Person(mcm));
        }
        m.addToWriters(arrayList3);
        return m;
    }

    public TvShowEpisode getTvShowEpisode() {
        TvShowEpisode ep = new TvShowEpisode();
        ep.setIds(this.ids);
        ep.setTitle(this.info.title3);
        ep.setSeason(this.info.season);
        ep.setEpisode(this.info.episode);
        ep.setPlot(this.info.summary);
        ep.setFirstAired(this.info.releaseDate);
        try {
            ep.setYear(this.info.year);
        }
        catch (Exception e) {
            ep.setYear(0);
        }
        if (this.rating > 0.0f) {
            MediaRating r = new MediaRating("NFO", this.rating);
            ep.setRating(r);
        }
        for (MediaArtwork mediaArtwork : this.artworks) {
            ep.setArtworkUrl(mediaArtwork.getDefaultUrl(), MediaFileType.getMediaFileType(mediaArtwork.getType()));
        }
        ArrayList<Person> actors = new ArrayList<Person>();
        for (String string : this.info.list.cast) {
            Person mcm = new Person(Person.Type.ACTOR);
            mcm.setName(string);
            actors.add(new Person(mcm));
        }
        ep.addToActors(actors);
        ArrayList<Person> arrayList = new ArrayList<Person>();
        for (String dir : this.info.list.director) {
            Person mcm = new Person(Person.Type.DIRECTOR);
            mcm.setName(dir);
            arrayList.add(new Person(mcm));
        }
        ep.addToDirectors(arrayList);
        ArrayList<Person> arrayList2 = new ArrayList<Person>();
        for (String writ : this.info.list.writer) {
            Person mcm = new Person(Person.Type.WRITER);
            mcm.setName(writ);
            arrayList2.add(new Person(mcm));
        }
        ep.addToWriters(arrayList2);
        return ep;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static abstract class SyncStream {
        abstract long position();

        abstract long length();

        boolean eof() {
            return this.position() >= this.length();
        }

        boolean hasMore() {
            return !this.eof();
        }

        long available() {
            return this.length() - this.position();
        }

        public abstract int readU8();

        public abstract void write8(int var1);

        public void writeBytes(byte[] data) {
            for (int n = 0; n < data.length; ++n) {
                this.write8(data[n]);
            }
        }

        public void readExact(byte[] data, int offset, int length) {
            for (int n = 0; n < length; ++n) {
                int v = this.readU8();
                data[offset + n] = (byte)v;
            }
        }

        public byte[] readBytes(int count) {
            byte[] out = new byte[Math.min(count, (int)this.available())];
            this.readExact(out, 0, out.length);
            return out;
        }

        public void writeU_VL_Int(int value) {
            this.writeU_VL_Long(value);
        }

        public void writeU_VL_Long(long value) {
            long v = value;
            do {
                int data = (int)(v & 0x7FL);
                boolean hasMore = (v >>>= 7) != 0L;
                int data2 = hasMore ? 128 : 0;
                this.write8(data | data2);
            } while (this.hasMore());
        }

        public int readU_VL_Int() {
            return (int)this.readU_VL_Long();
        }

        public long readU_VL_Long() {
            int v;
            long out = 0L;
            int offset = 0;
            do {
                v = this.readU8();
                out |= (long)(v & 0x7F) << offset;
                offset += 7;
            } while ((v & 0x80) != 0 && this.hasMore());
            LOGGER.trace("SYNO long  dec: {}  hex: {}", (Object)out, (Object)String.format("%02X", out));
            return out;
        }

        public void writeBytesVL(byte[] data) {
            this.writeU_VL_Int(data.length);
            this.writeBytes(data);
        }

        public void writeStringVL(String str, Charset charset) {
            this.writeBytesVL(str.getBytes(charset));
        }

        public byte[] readBytesVL() {
            byte[] bytes = new byte[this.readU_VL_Int()];
            this.readExact(bytes, 0, bytes.length);
            return bytes;
        }

        public String readStringVL() {
            return this.readStringVL(StandardCharsets.UTF_8);
        }

        public String readStringVL(Charset charset) {
            String str = new String(this.readBytesVL(), charset);
            if (str.length() > 1000) {
                LOGGER.trace("SYNO str: {}... (truncated)", (Object)StringUtils.left((String)str, (int)1000));
            } else {
                LOGGER.trace("SYNO str: {}", (Object)str);
            }
            return str;
        }
    }

    public static class MemorySyncStream
    extends SyncStream {
        int position;
        int length;
        byte[] data;

        public MemorySyncStream(byte[] data) {
            this(data, 0);
        }

        public MemorySyncStream(byte[] data, int position) {
            this.data = data;
            this.position = position;
            this.length = data.length;
        }

        @Override
        long position() {
            return this.position;
        }

        @Override
        long length() {
            return this.length;
        }

        @Override
        public int readU8() {
            if (this.eof()) {
                return -1;
            }
            return this.data[this.position++];
        }

        @Override
        public void write8(int value) {
            if (this.position >= this.length) {
                ++this.length;
                if (this.length > this.data.length) {
                    this.data = Arrays.copyOf(this.data, 7 + this.data.length * 3);
                }
            }
            this.data[this.position++] = (byte)value;
        }

        public byte[] toByteArray() {
            return Arrays.copyOf(this.data, this.length);
        }
    }

    static class ImageInfo {
        public byte[] poster = null;
        public byte[] showImage = null;
        public byte[] backdrop = null;

        ImageInfo() {
        }
    }

    static class ListInfo {
        public Set<String> cast = new HashSet<String>();
        public Set<String> genre = new HashSet<String>();
        public Set<String> director = new HashSet<String>();
        public Set<String> writer = new HashSet<String>();

        ListInfo() {
        }
    }

    static class Info {
        public String title1 = "";
        public String title2 = "";
        public String title3 = "";
        public int year = 0;
        public Date releaseDate = null;
        public String summary = "";
        public String classification = "";
        public int season = 1;
        public int episode = 1;
        public Double rating = null;
        public ListInfo list = new ListInfo();
        public ImageInfo images = new ImageInfo();
        public String entityJson = "";
        public Date timestamp = new Date();
        public boolean locked = true;
        public String tvShowJson = "";
        public Date tvshowReleaseDate = null;
        public int tvshowYear = 0;
        public String tvshowSummary = "";
        public boolean tvshowLocked = true;

        Info() {
        }
    }
}

