/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.toolbar.ToolbarMenu;
import org.tinymediamanager.ui.images.TmmAwesomeIcon;
import org.tinymediamanager.ui.images.TmmSvgIcon;
import org.tinymediamanager.ui.images.TmmTextIcon;

public class IconManager {
    public static final ImageIcon EMPTY_IMAGE = new ImageIcon(IconManager.class.getResource("plaf/empty.png"));
    private static final Set<TmmSvgIconCache> SVG_CACHE = new HashSet<TmmSvgIconCache>();
    private static final Set<TmmTextIconCache> TEXT_ICON_CACHE = new HashSet<TmmTextIconCache>();
    private static final Map<URI, ImageIcon> ICON_CACHE = new HashMap<URI, ImageIcon>();
    public static final ImageIcon TOOLBAR_ABOUT = IconManager.createSVGIcon("icn_about.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_ABOUT_HOVER = IconManager.createSVGIcon("icn_about_hover.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_ADD_MOVIE_SET = IconManager.createSVGIcon("icn_add_collection.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_ADD_MOVIE_SET_HOVER = IconManager.createSVGIcon("icn_add_collection_hover.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_EDIT = IconManager.createSVGIcon("icn_edit.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_EDIT_HOVER = IconManager.createSVGIcon("icn_edit_hover.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_LOGO = IconManager.createSVGIcon("tmm_logo.svg", new Dimension(100, 45));
    public static final ImageIcon TOOLBAR_REFRESH = IconManager.createSVGIcon("icn_refresh.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_REFRESH_HOVER = IconManager.createSVGIcon("icn_refresh_hover.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_RENAME = IconManager.createSVGIcon("icn_rename.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_RENAME_HOVER = IconManager.createSVGIcon("icn_rename_hover.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_SEARCH = IconManager.createSVGIcon("icn_search.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_SEARCH_HOVER = IconManager.createSVGIcon("icn_search_hover.svg", new Dimension(36, 36));
    public static final ImageIcon TOOLBAR_SETTINGS = IconManager.createSVGIcon("icn_settings.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_SETTINGS_HOVER = IconManager.createSVGIcon("icn_settings_hover.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_TOOLS = IconManager.createSVGIcon("icn_tools.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_TOOLS_HOVER = IconManager.createSVGIcon("icn_tools_hover.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_UPGRADE = IconManager.createSVGIcon("icn_upgrade.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_RENEW = IconManager.createSVGIcon("icn_renew.svg", new Dimension(24, 24));
    public static final ImageIcon TOOLBAR_MENU_INDICATOR = IconManager.createSVGIcon("caret-down-solid.svg", ToolbarMenu.COLOR);
    public static final ImageIcon TOOLBAR_MENU_INDICATOR_HOVER = IconManager.createSVGIcon("caret-down-solid.svg", ToolbarMenu.COLOR_HOVER);
    public static final ImageIcon STAR_FILLED = IconManager.createSVGIcon("star-filled.svg", new Dimension(24, 24), true);
    public static final ImageIcon STAR_EMPTY = IconManager.createSVGIcon("star-empty.svg", new Dimension(24, 24), true);
    public static final ImageIcon RATING_NEUTRAL = IconManager.createSVGIcon("rating.svg", new Dimension(36, 36), true);
    public static final ImageIcon RATING_EMTPY = IconManager.createSVGIcon("rating-empty.svg", new Dimension(36, 36), true);
    public static final ImageIcon RATING_USER = IconManager.createSVGIcon("rating-user.svg", new Dimension(36, 36), true);
    public static final ImageIcon RATING_IMDB = IconManager.createSVGIcon("rating-imdb.svg", new Dimension(36, 36), true);
    public static final ImageIcon RATING_TMDB = IconManager.createSVGIcon("rating-tmdb.svg", new Dimension(36, 36), true);
    public static final ImageIcon RATING_TOMATOMETER = IconManager.createSVGIcon("rating-tomatometer.svg", new Dimension(36, 36), true);
    public static final ImageIcon RATING_METACRITIC = IconManager.createSVGIcon("rating-metacritic.svg", new Dimension(36, 36), true);
    public static final ImageIcon RATING_THETVDB = IconManager.createSVGIcon("rating-thetvdb.svg", new Dimension(53, 36), true);
    public static final ImageIcon RATING_TRAKTTV = IconManager.createSVGIcon("rating-trakttv.svg", new Dimension(36, 36), true);
    public static final ImageIcon ADD = IconManager.createMenuIcon("plus.svg");
    public static final ImageIcon APPLY = IconManager.createMenuIcon("circle-check.svg");
    public static final ImageIcon ASPECT_RATIO_BLUE = IconManager.createMenuIcon("ruler-combined-solid.svg");
    public static final ImageIcon BARCODE = IconManager.createMenuIcon("barcode.svg");
    public static final ImageIcon BUG = IconManager.createMenuIcon("bug.svg");
    public static final ImageIcon CLEAN = IconManager.createMenuIcon("broom.svg");
    public static final ImageIcon CONNECT = IconManager.createMenuIcon("link.svg");
    public static final ImageIcon COPY = IconManager.createMenuIcon("clone.svg");
    public static final ImageIcon DELETE = IconManager.createMenuIcon("xmark.svg");
    public static final ImageIcon DELETE_FOREVER = IconManager.createMenuIcon("trash-alt.svg");
    public static final ImageIcon DISCONNECT = IconManager.createMenuIcon("unlink.svg");
    public static final ImageIcon DOWNLOAD = IconManager.createMenuIcon("download.svg");
    public static final ImageIcon FEEDBACK = IconManager.createMenuIcon("envelope.svg");
    public static final ImageIcon EDIT = IconManager.createMenuIcon("edit.svg");
    public static final ImageIcon EXPORT = IconManager.createMenuIcon("share-square.svg");
    public static final ImageIcon FILTER = IconManager.createMenuIcon("filter.svg");
    public static final ImageIcon FOLDER_OPEN = IconManager.createMenuIcon("folder-open.svg");
    public static final ImageIcon HELP = IconManager.createMenuIcon("circle-question.svg");
    public static final ImageIcon HINT = IconManager.createMenuIcon("circle-info.svg");
    public static final ImageIcon IMAGE = IconManager.createMenuIcon("image.svg");
    public static final ImageIcon KODI = IconManager.createMenuIcon("kodi.svg");
    public static final ImageIcon LIST = IconManager.createMenuIcon("list.svg");
    public static final ImageIcon LOCK_BLUE = IconManager.createMenuIcon("lock-alt.svg");
    public static final ImageIcon MEDIAINFO = IconManager.createMenuIcon("info.svg");
    public static final ImageIcon MENU = IconManager.createMenuIcon("bars.svg");
    public static final ImageIcon MOVIE = IconManager.createMenuIcon("film.svg");
    public static final ImageIcon MUSIC = IconManager.createMenuIcon("music.svg");
    public static final ImageIcon NFO_BLUE = IconManager.createMenuIcon("file-lines.svg");
    public static final ImageIcon PLAY = IconManager.createMenuIcon("play.svg");
    public static final ImageIcon REFRESH = IconManager.createMenuIcon("redo.svg");
    public static final ImageIcon REMOVE = IconManager.createMenuIcon("minus.svg");
    public static final ImageIcon SEARCH = IconManager.createMenuIcon("search.svg");
    public static final ImageIcon RATING_BLUE = IconManager.createMenuIcon("star.svg");
    public static final ImageIcon SUBTITLE = IconManager.createMenuIcon("comments.svg");
    public static final ImageIcon SYNC = IconManager.createMenuIcon("sync.svg");
    public static final ImageIcon THUMB = IconManager.createMenuIcon("photo-film.svg");
    public static final ImageIcon UNLOCK_BLUE = IconManager.createMenuIcon("lock-open-alt.svg");
    public static final ImageIcon VOLUME = IconManager.createMenuIcon("volume.svg");
    public static final ImageIcon WATCHED_MENU = IconManager.createMenuIcon("play.svg");
    public static final ImageIcon TABLE_OK = IconManager.createSVGIcon("check.svg", new Color(31, 187, 0));
    public static final ImageIcon TABLE_PROBLEM = IconManager.createSVGIcon("triangle-exclamation.svg", new Color(204, 120, 50));
    public static final ImageIcon TABLE_NOT_OK = IconManager.createSVGIcon("xmark.svg", new Color(204, 2, 2));
    public static final ImageIcon CANCEL = IconManager.createSVGIcon("circle-xmark.svg");
    public static final ImageIcon CARET_UP = IconManager.createSVGIcon("chevron-up.svg");
    public static final ImageIcon CARET_DOWN = IconManager.createSVGIcon("chevron-down.svg");
    public static final ImageIcon CLEAR_GREY = IconManager.createSVGIcon("circle-xmark.svg");
    public static final ImageIcon COLLAPSED = IconManager.createSVGIcon("square-chevron-down.svg");
    public static final ImageIcon CONFIGURE = IconManager.createSVGIcon("wrench.svg");
    public static final ImageIcon DATE_PICKER = IconManager.createSVGIcon("calendar-lines.svg");
    public static final ImageIcon DELETE_GRAY = IconManager.createSVGIcon("trash-alt.svg");
    public static final ImageIcon ERROR = IconManager.createSVGIcon("circle-xmark.svg");
    public static final ImageIcon EXPANDED = IconManager.createSVGIcon("square-chevron-right.svg");
    public static final ImageIcon WARN = IconManager.createSVGIcon("triangle-exclamation.svg");
    public static final ImageIcon WARN_INTENSIFIED = IconManager.createSVGIcon("triangle-exclamation.svg", Color.RED);
    public static final ImageIcon INFO = IconManager.createSVGIcon("circle-info.svg");
    public static final ImageIcon FILTER_ACTIVE = IconManager.createSVGIcon("lightbulb-on.svg", new Color(255, 119, 0));
    public static final ImageIcon NEW_GREEN = IconManager.createSVGIcon("circle-plus.svg", new Color(31, 187, 0));
    public static final ImageIcon PLAY_LARGE = IconManager.createSVGIcon("play-circle.svg", 2.33333);
    public static final ImageIcon SAVE = IconManager.createSVGIcon("save.svg");
    public static final ImageIcon SEARCH_GREY = IconManager.createSVGIcon("search.svg");
    public static final ImageIcon STOP = IconManager.createSVGIcon("circle-stop.svg");
    public static final ImageIcon UNDO_GREY = IconManager.createSVGIcon("undo.svg");
    public static final ImageIcon ADD_INV = IconManager.createButtonIcon("plus.svg");
    public static final ImageIcon ARROW_UP_INV = IconManager.createButtonIcon("chevron-up.svg");
    public static final ImageIcon ARROW_DOWN_INV = IconManager.createButtonIcon("chevron-down.svg");
    public static final ImageIcon APPLY_INV = IconManager.createButtonIcon("circle-check.svg");
    public static final ImageIcon BACK_INV = IconManager.createButtonIcon("circle-chevron-left.svg");
    public static final ImageIcon CANCEL_INV = IconManager.createButtonIcon("circle-xmark.svg");
    public static final ImageIcon CHECK_ALL = IconManager.createButtonIcon("square-check.svg");
    public static final ImageIcon CLEAR_ALL = IconManager.createButtonIcon("square.svg");
    public static final ImageIcon COPY_INV = IconManager.createButtonIcon("clone.svg");
    public static final ImageIcon DELETE_INV = IconManager.createButtonIcon("trash-alt.svg");
    public static final ImageIcon EXCHANGE = IconManager.createButtonIcon("exchange.svg");
    public static final ImageIcon FILE_OPEN_INV = IconManager.createButtonIcon("folder-open.svg");
    public static final ImageIcon FILE_ADD_INV = IconManager.createButtonIcon("file-plus.svg");
    public static final ImageIcon IMAGE_INV = IconManager.createButtonIcon("image.svg");
    public static final ImageIcon PLAY_INV = IconManager.createButtonIcon("play.svg");
    public static final ImageIcon REMOVE_INV = IconManager.createButtonIcon("minus.svg");
    public static final ImageIcon SEARCH_INV = IconManager.createButtonIcon("search.svg");
    public static final ImageIcon STOP_INV = IconManager.createButtonIcon("circle-stop.svg");
    public static final ImageIcon AUDIO = IconManager.createTableHeaderIcon("volume.svg");
    public static final ImageIcon ASPECT_RATIO = IconManager.createTableHeaderIcon("ruler-combined-solid.svg");
    public static final ImageIcon ASPECT_RATIO_2 = IconManager.createTableHeaderIcon("ruler-combined-2-solid.svg");
    public static final ImageIcon CERTIFICATION = IconManager.createTableHeaderIcon("universal-access.svg");
    public static final ImageIcon COUNT = IconManager.createTableHeaderIcon("hashtag.svg");
    public static final ImageIcon DATE_ADDED = IconManager.createTableHeaderIcon("calendar-plus.svg");
    public static final ImageIcon DATE_AIRED = IconManager.createTableHeaderIcon("calendar-lines.svg");
    public static final ImageIcon DATE_CREATED = IconManager.createTableHeaderIcon("calendar-star.svg");
    public static final ImageIcon EDITION = IconManager.createTableHeaderIcon("compact-disc.svg");
    public static final ImageIcon EDIT_HEADER = IconManager.createTableHeaderIcon("edit.svg");
    public static final ImageIcon EPISODES = IconManager.createTextIcon("E", 1.5);
    public static final ImageIcon FILE_SIZE = IconManager.createTableHeaderIcon("save.svg");
    public static final ImageIcon HDR = IconManager.createTableHeaderIcon("delicious-brands.svg");
    public static final ImageIcon IMAGES = IconManager.createTableHeaderIcon("images.svg");
    public static final ImageIcon IMDB = IconManager.createTextIcon("IMDb", 0.9);
    public static final ImageIcon IDCARD = IconManager.createTableHeaderIcon("id-card.svg");
    public static final ImageIcon LOCK = IconManager.createTableHeaderIcon("lock-alt.svg");
    public static final ImageIcon METASCORE = IconManager.createTextIcon("MS", 0.9);
    public static final ImageIcon MUSIC_HEADER = IconManager.createTableHeaderIcon("music.svg");
    public static final ImageIcon NEW = IconManager.createTableHeaderIcon("circle-plus.svg");
    public static final ImageIcon NFO = IconManager.createTableHeaderIcon("file-lines.svg");
    public static final ImageIcon RATING = IconManager.createTableHeaderIcon("star.svg");
    public static final ImageIcon RUNTIME = IconManager.createTableHeaderIcon("clock.svg");
    public static final ImageIcon SEASONS = IconManager.createTextIcon("S", 1.5);
    public static final ImageIcon SOURCE = IconManager.createTableHeaderIcon("location.svg");
    public static final ImageIcon SUBTITLES = IconManager.createTableHeaderIcon("comments.svg");
    public static final ImageIcon TMDB = IconManager.createTextIcon("TMDB", 0.9);
    public static final ImageIcon TOP250 = IconManager.createTextIcon("Top", 0.9);
    public static final ImageIcon ROTTEN_TOMATOES = IconManager.createTextIcon("RT", 0.9);
    public static final ImageIcon TRAILER = IconManager.createTableHeaderIcon("film.svg");
    public static final ImageIcon USER_RATING = IconManager.createTableHeaderIcon("star-solid.svg");
    public static final ImageIcon VIDEO_3D = IconManager.createTableHeaderIcon("cube.svg");
    public static final ImageIcon VIDEO_FORMAT = IconManager.createTableHeaderIcon("expand-wide.svg");
    public static final ImageIcon VIDEO_BITRATE = IconManager.createTableHeaderIcon("tachometer-fast.svg");
    public static final ImageIcon VIDEO_CODEC = IconManager.createTableHeaderIcon("file-video.svg");
    public static final ImageIcon VOTES = IconManager.createTableHeaderIcon("thumbs-up.svg");
    public static final ImageIcon WATCHED = IconManager.createTableHeaderIcon("play.svg");
    public static final ImageIcon SORT_UP_PRIMARY = IconManager.createSVGIcon("chevron-up.svg", 0.833);
    public static final ImageIcon SORT_UP_SECONDARY = IconManager.createSVGIcon("chevrons-up.svg", 0.833);
    public static final ImageIcon SORT_DOWN_PRIMARY = IconManager.createSVGIcon("chevron-down.svg", 0.833);
    public static final ImageIcon SORT_DOWN_SECONDARY = IconManager.createSVGIcon("chevrons-down.svg", 0.833);

    private IconManager() {
        throw new IllegalAccessError();
    }

    private static ImageIcon loadImage(String name) {
        URL file = IconManager.class.getResource("images/interface/" + name);
        if (file != null) {
            return new ImageIcon(file);
        }
        return EMPTY_IMAGE;
    }

    private static ImageIcon loadMultiResolutionImage(String name) {
        List<String> resolutions = Arrays.asList("", "@125", "@150", "@200");
        try {
            ArrayList<Image> images = new ArrayList<Image>();
            String extension = FilenameUtils.getExtension((String)name);
            String basename = FilenameUtils.getBaseName((String)name);
            for (String resolution : resolutions) {
                URL file = IconManager.class.getResource("images/interface/" + basename + resolution + "." + extension);
                if (file == null) continue;
                images.add(new ImageIcon(file).getImage());
            }
            return new ImageIcon(new BaseMultiResolutionImage(images.toArray(new Image[0])));
        }
        catch (Exception exception) {
            return EMPTY_IMAGE;
        }
    }

    public static ImageIcon loadImageFromURL(URL url) {
        URI uri = null;
        if (url == null) {
            return EMPTY_IMAGE;
        }
        try {
            uri = url.toURI();
        }
        catch (Exception e) {
            return EMPTY_IMAGE;
        }
        ImageIcon icon = ICON_CACHE.get(uri);
        if (icon == null) {
            try {
                icon = new ImageIcon(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (icon == null) {
                icon = EMPTY_IMAGE;
            }
            ICON_CACHE.put(uri, icon);
        }
        return icon;
    }

    private static ImageIcon createMenuIcon(String name) {
        return IconManager.createSVGIcon(name, "Component.focusColor", TmmFontHelper.H3);
    }

    private static ImageIcon createButtonIcon(String name) {
        return IconManager.createSVGIcon(name, "Button.foreground", TmmFontHelper.H3);
    }

    private static ImageIcon createTableHeaderIcon(String name) {
        return IconManager.createSVGIcon(name, "TableHeader.foreground", TmmFontHelper.H2);
    }

    private static ImageIcon createSVGIcon(String name) {
        return IconManager.createSVGIcon(name, "Label.foreground", TmmFontHelper.H3);
    }

    private static ImageIcon createSVGIcon(String name, String colorReference) {
        return IconManager.createSVGIcon(name, colorReference, TmmFontHelper.H3);
    }

    private static ImageIcon createSVGIcon(String name, double scaleFactor) {
        return IconManager.createSVGIcon(name, "Label.foreground", scaleFactor);
    }

    private static ImageIcon createSVGIcon(String name, Color color) {
        return IconManager.createSVGIcon(name, color, TmmFontHelper.H2);
    }

    private static ImageIcon createSVGIcon(String name, String colorReference, double scaleFactor) {
        ImageIcon icon = IconManager.createSVGIcon(name, UIManager.getColor(colorReference), scaleFactor);
        if (icon != EMPTY_IMAGE) {
            SVG_CACHE.add(new TmmSvgIconCache((TmmSvgIcon)((Object)icon), scaleFactor, colorReference));
        }
        return icon;
    }

    private static ImageIcon createSVGIcon(String name, Dimension size) {
        return IconManager.createSVGIcon(name, size, false);
    }

    private static ImageIcon createSVGIcon(String name, Dimension size, boolean autoSize) {
        try {
            URI uri = IconManager.class.getResource("images/svg/" + name).toURI();
            TmmSvgIcon icon = new TmmSvgIcon(uri);
            icon.setPreferredSize(size);
            if (!autoSize) {
                icon.setAutosize(0);
            }
            return icon;
        }
        catch (Exception e) {
            return EMPTY_IMAGE;
        }
    }

    private static ImageIcon createSVGIcon(String name, Color color, double scaleFactor) {
        try {
            URI uri = IconManager.class.getResource("images/svg/" + name).toURI();
            TmmAwesomeIcon icon = new TmmAwesomeIcon(uri, color);
            icon.setPreferredHeight(IconManager.calculateFontIconSize(scaleFactor));
            SVG_CACHE.add(new TmmSvgIconCache(icon, scaleFactor, null));
            return icon;
        }
        catch (Exception e) {
            return EMPTY_IMAGE;
        }
    }

    private static int calculateFontIconSize(double scaleFactor) {
        try {
            return (int)Math.floor((double)UIManager.getFont("defaultFont").getSize() * scaleFactor);
        }
        catch (Exception e) {
            return (int)Math.floor(12.0 * scaleFactor);
        }
    }

    private static ImageIcon createTextIcon(String text) {
        return IconManager.createTextIcon(text, 1.0, UIManager.getColor("Label.foreground"));
    }

    private static ImageIcon createTextIcon(String text, Color color) {
        return IconManager.createTextIcon(text, 1.0, color);
    }

    private static ImageIcon createTextIcon(String text, double scaleFactor) {
        ImageIcon icon = IconManager.createTextIcon(text, scaleFactor, UIManager.getColor("Label.foreground"));
        TEXT_ICON_CACHE.add(new TmmTextIconCache((TmmTextIcon)icon, scaleFactor, null));
        return icon;
    }

    private static ImageIcon createTextIcon(String text, double scaleFactor, Color color) {
        int size = IconManager.calculateFontIconSize(scaleFactor);
        TmmTextIcon icon = new TmmTextIcon(text, size, color);
        TEXT_ICON_CACHE.add(new TmmTextIconCache(icon, scaleFactor, null));
        return icon;
    }

    static void updateIcons() {
        int size;
        for (TmmSvgIconCache tmmSvgIconCache : SVG_CACHE) {
            if (StringUtils.isNotBlank((CharSequence)tmmSvgIconCache.colorReference)) {
                tmmSvgIconCache.icon.setColor(UIManager.getColor(tmmSvgIconCache.colorReference));
            }
            size = IconManager.calculateFontIconSize(tmmSvgIconCache.scaleFactor);
            tmmSvgIconCache.icon.setPreferredSize(new Dimension(size, size));
        }
        for (TmmTextIconCache tmmTextIconCache : TEXT_ICON_CACHE) {
            if (StringUtils.isNotBlank((CharSequence)tmmTextIconCache.colorReference)) {
                tmmTextIconCache.icon.setColor(UIManager.getColor(tmmTextIconCache.colorReference));
            }
            size = IconManager.calculateFontIconSize(tmmTextIconCache.scaleFactor);
            tmmTextIconCache.icon.setFontSize(size);
            tmmTextIconCache.icon.update();
        }
    }

    private static class TmmTextIconCache {
        private TmmTextIcon icon;
        private final double scaleFactor;
        private final String colorReference;

        public TmmTextIconCache(TmmTextIcon icon, double scaleFactor, String colorReference) {
            this.icon = icon;
            this.scaleFactor = scaleFactor;
            this.colorReference = colorReference;
        }
    }

    private static class TmmSvgIconCache {
        private TmmSvgIcon icon;
        private final double scaleFactor;
        private final String colorReference;

        public TmmSvgIconCache(TmmSvgIcon icon, double scaleFactor, String colorReference) {
            this.icon = icon;
            this.scaleFactor = scaleFactor;
            this.colorReference = colorReference;
        }
    }
}

