/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.sun.jna.Platform;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BaseMultiResolutionImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.tinymediamanager.ui.ITmmTabItem;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.LightBox;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TextFieldPopupMenu;
import org.tinymediamanager.ui.components.toolbar.ToolbarPanel;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.images.LogoCircle;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.panels.StatusBarPanel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class MainWindow
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainWindow.class);
    private static final long serialVersionUID = 1L;
    public static final Image LOGOS = MainWindow.createLogos();
    private static MainWindow instance;
    private JTabbedPane tabbedPane;
    private JPanel detailPanel;

    public static synchronized MainWindow getInstance() {
        if (instance == null) {
            new MainWindow("tinyMediaManager");
        }
        return instance;
    }

    private MainWindow(String name) {
        super(name);
        this.setName("mainWindow");
        this.setMinimumSize(new Dimension(1050, 700));
        instance = this;
        this.initialize();
    }

    private static Image createLogos() {
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(new LogoCircle(48).getImage());
        images.add(new LogoCircle(64).getImage());
        images.add(new LogoCircle(96).getImage());
        images.add(new LogoCircle(128).getImage());
        images.add(new LogoCircle(256).getImage());
        images.add(new LogoCircle(512).getImage());
        images.add(new LogoCircle(1024).getImage());
        return new BaseMultiResolutionImage(5, images.toArray(new Image[0]));
    }

    private void initialize() {
        this.setIconImage(LOGOS);
        this.setBounds(5, 5, 1100, 720);
        this.setDefaultCloseOperation(0);
        ToolbarPanel toolbarPanel = new ToolbarPanel();
        this.getContentPane().add((Component)toolbarPanel, "North");
        JPanel rootPanel = new JPanel();
        Color color = UIManager.getColor("Panel.tmmAlternateBackground");
        if (color != null) {
            rootPanel.setBackground(color);
        }
        rootPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[900lp:n,grow]", "[300lp:400lp,grow,shrink 0]0[shrink 0]"));
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(rootPanel, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(true);
        splitPane.setName("mainWindow.splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        rootPanel.add((Component)splitPane, "cell 0 0, grow");
        this.tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 9041548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        splitPane.setLeftComponent(this.tabbedPane);
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout(new CardLayout(0, 0));
        splitPane.setRightComponent(this.detailPanel);
        StatusBarPanel panelStatusBar = new StatusBarPanel();
        rootPanel.add((Component)panelStatusBar, "cell 0 1,grow");
        this.addModule(MovieUIModule.getInstance());
        toolbarPanel.setUIModule(MovieUIModule.getInstance());
        this.addModule(MovieSetUIModule.getInstance());
        this.addModule(TvShowUIModule.getInstance());
        ChangeListener changeListener = changeEvent -> {
            JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (sourceTabbedPane.getSelectedComponent() instanceof ITmmTabItem) {
                ITmmTabItem activeTab = (ITmmTabItem)((Object)sourceTabbedPane.getSelectedComponent());
                toolbarPanel.setUIModule(activeTab.getUIModule());
                CardLayout cl = (CardLayout)this.detailPanel.getLayout();
                cl.show(this.detailPanel, activeTab.getUIModule().getModuleId());
            }
        };
        this.tabbedPane.addChangeListener(changeListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeTmm();
            }
        });
        MessageManager.instance.addListener(TmmUIMessageCollector.instance);
        Toolkit.getDefaultToolkit().addAWTEventListener(arg0 -> {
            if (arg0 instanceof MouseEvent && ((MouseEvent)arg0).isPopupTrigger() && arg0.getSource() instanceof JTextComponent) {
                MouseEvent me = (MouseEvent)arg0;
                JTextComponent tc = (JTextComponent)arg0.getSource();
                if (me.isPopupTrigger() && tc.getComponentPopupMenu() == null) {
                    TextFieldPopupMenu.buildCutCopyPaste().show(tc, me.getX(), me.getY());
                }
            }
        }, 16L);
        if (Platform.isLinux() && StringUtils.isBlank((CharSequence)MediaInfo.version())) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("mediainfo.failed.linux")));
        }
        for (ITmmModule module : TmmModuleManager.getInstance().getModules()) {
            if (module.getStartupMessages().isEmpty()) continue;
            for (String message : module.getStartupMessages()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, message));
            }
        }
        SwingUtilities.invokeLater(SettingsDialog::getInstance);
    }

    private void addModule(ITmmUIModule module) {
        this.tabbedPane.addTab(module.getTabTitle(), module.getTabPanel());
        this.detailPanel.add((Component)module.getDetailPanel(), module.getModuleId());
    }

    public void closeTmm() {
        this.closeTmmAndStart(null);
    }

    public void closeTmmAndStart(ProcessBuilder pb) {
        int confirm = 0;
        if (TmmTaskManager.getInstance().poolRunning()) {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            confirm = JOptionPane.showOptionDialog(null, TmmResourceBundle.getString("tmm.exit.runningtasks"), TmmResourceBundle.getString("tmm.exit.confirmation"), 0, 3, null, options, null);
        }
        if (confirm == 0) {
            LOGGER.info("bye bye");
            this.saveWindowLayout();
            TinyMediaManager.shutdown();
            this.dispose();
            if (pb != null) {
                try {
                    LOGGER.info("Going to execute: {}", pb.command());
                    pb.start();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot spawn process:", (Throwable)e);
                }
            }
            TinyMediaManager.shutdownLogger();
            System.exit(0);
        }
    }

    public static JFrame getFrame() {
        return instance;
    }

    public void createLightbox(String pathToFile, String urlToFile) {
        LightBox.showLightBox(instance, pathToFile, urlToFile);
    }

    public void saveWindowLayout() {
        for (Window window : Window.getWindows()) {
            JFrame frame;
            if (window instanceof JDialog) {
                JDialog dialog = (JDialog)window;
                if (!dialog.isVisible()) continue;
                TmmUILayoutStore.getInstance().saveSettings(dialog);
                continue;
            }
            if (!(window instanceof JFrame) || !(frame = (JFrame)window).isVisible()) continue;
            TmmUILayoutStore.getInstance().saveSettings(frame);
        }
    }
}

