/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TableSpinnerEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -4249251950819118622L;
    private JSpinner spinner = new JSpinner();
    private JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
    private JTextField textField = this.editor.getTextField();
    private boolean valueSet;

    public TableSpinnerEditor() {
        super(new JTextField());
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                SwingUtilities.invokeLater(() -> {
                    if (TableSpinnerEditor.this.valueSet) {
                        TableSpinnerEditor.this.textField.setCaretPosition(1);
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent fe) {
                TableSpinnerEditor.this.stopCellEditing();
            }
        });
        this.textField.addActionListener(ae -> this.stopCellEditing());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!this.valueSet) {
            this.spinner.setValue(value);
        }
        SwingUtilities.invokeLater(() -> this.textField.requestFocus());
        return this.spinner;
    }

    @Override
    public boolean isCellEditable(EventObject eo) {
        if (eo instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)eo;
            this.textField.setText(String.valueOf(ke.getKeyChar()));
            this.valueSet = true;
        } else {
            this.valueSet = false;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.editor.commitEdit();
            this.spinner.commitEdit();
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(null, "Invalid value, discarding.");
        }
        return super.stopCellEditing();
    }
}

