/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.license.ZipArchiveHelper;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class ExportAnalysisDataAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportAnalysisDataAction.class);

    public ExportAnalysisDataAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.exportanalysisdata"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tmm.exportanalysisdata.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        Path file = null;
        try {
            String path = TmmProperties.getInstance().getProperty("exportlogs.path", "");
            file = TmmUIHelper.saveFile(TmmResourceBundle.getString("BugReport.savelogs"), path, "tmm_data.zip", new FileNameExtensionFilter("Zip files", ".zip"));
            if (file != null) {
                MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                this.writeLogsFile(file.toFile());
                TmmProperties.getInstance().putProperty("exportlogs.path", file.toAbsolutePath().toString());
                MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not write logs.zip: {}", (Object)ex.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)(file != null ? file.toString() : ""), "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
        }
    }

    private void writeLogsFile(File file) throws Exception {
        ArrayList<Path> extraFiles = new ArrayList<Path>();
        extraFiles.add(this.exportMovieDatasources());
        extraFiles.add(this.exportTvShowDatasources());
        ZipParameters zipParameters = this.createZipParameters();
        try (FileOutputStream os = new FileOutputStream(file);
             ZipOutputStream zos = ZipArchiveHelper.getInstance().createEncryptedZipOutputStream(os);){
            List<Path> logs = Utils.listFiles(Paths.get(Globals.LOG_FOLDER, new String[0]));
            for (Path logFile : logs) {
                try (FileInputStream in = new FileInputStream(logFile.toFile());){
                    zipParameters.setFileNameInZip("logs/" + logFile.getFileName());
                    zos.putNextEntry(zipParameters);
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    zos.closeEntry();
                }
                catch (Exception e) {
                    LOGGER.warn("unable to attach {} - {}", (Object)logFile, (Object)e.getMessage());
                }
            }
            File[] data = new File(Globals.DATA_FOLDER).listFiles((directory, filename) -> !filename.matches(".*\\.db$") && !filename.matches(".*\\.lic$"));
            if (data != null) {
                for (File dataFile : data) {
                    try (FileInputStream in = new FileInputStream(dataFile);){
                        zipParameters.setFileNameInZip("data/" + dataFile.getName());
                        zos.putNextEntry(zipParameters);
                        IOUtils.copy((InputStream)in, (OutputStream)zos);
                        zos.closeEntry();
                    }
                    catch (Exception e) {
                        LOGGER.warn("unable to attach {} - {}", (Object)dataFile.getName(), (Object)e.getMessage());
                    }
                }
            }
            for (Path extraFile : extraFiles) {
                try (FileInputStream in = new FileInputStream(extraFile.toFile());){
                    zipParameters.setFileNameInZip(extraFile.getFileName().toString());
                    zos.putNextEntry(zipParameters);
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    zos.closeEntry();
                }
                catch (Exception e) {
                    LOGGER.warn("unable to attach {} - {}", (Object)extraFile.getFileName(), (Object)e.getMessage());
                }
                Utils.deleteFileSafely(extraFile);
            }
        }
    }

    private ZipParameters createZipParameters() {
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setCompressionMethod(CompressionMethod.DEFLATE);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        zipParameters.setEncryptFiles(true);
        return zipParameters;
    }

    private Path exportMovieDatasources() {
        Path exportFile = Paths.get(Utils.getTempFolder(), "tmm_moviefiles.7z");
        Utils.deleteFileSafely(exportFile);
        try (SevenZOutputFile archive = new SevenZOutputFile(exportFile.toFile());){
            for (Movie movie : MovieModuleManager.getInstance().getMovieList().getMovies()) {
                Path datasource = Paths.get(movie.getDataSource(), new String[0]);
                for (MediaFile mf : movie.getMediaFiles()) {
                    String rel = Utils.relPath(datasource, mf.getFileAsPath());
                    SevenZArchiveEntry entry = new SevenZArchiveEntry();
                    entry.setName(datasource.getFileName().toString() + "/" + rel);
                    archive.putArchiveEntry((ArchiveEntry)entry);
                    archive.closeArchiveEntry();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file: {}", (Object)e.getMessage());
        }
        return exportFile;
    }

    private Path exportTvShowDatasources() {
        Path exportFile = Paths.get(Utils.getTempFolder(), "tmm_tvshowfiles.7z");
        Utils.deleteFileSafely(exportFile);
        try (SevenZOutputFile archive = new SevenZOutputFile(exportFile.toFile());){
            for (TvShow show : TvShowModuleManager.getInstance().getTvShowList().getTvShows()) {
                Path datasource = Paths.get(show.getDataSource(), new String[0]);
                List<MediaFile> mfs = show.getMediaFiles();
                mfs.addAll(show.getEpisodesMediaFiles());
                for (MediaFile mf : mfs) {
                    String rel = Utils.relPath(datasource, mf.getFileAsPath());
                    SevenZArchiveEntry entry = new SevenZArchiveEntry();
                    entry.setName(datasource.getFileName().toString() + "/" + rel);
                    archive.putArchiveEntry((ArchiveEntry)entry);
                    archive.closeArchiveEntry();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create zip file: {}", (Object)e.getMessage());
        }
        return exportFile;
    }
}

