/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class HomepageAction
extends TmmAction {
    private static final long serialVersionUID = 2368251224786765161L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HomepageAction.class);

    public HomepageAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.homepage.long"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org");
        try {
            TmmUIHelper.browseUrl(url);
        }
        catch (Exception e1) {
            LOGGER.error("homepage", (Throwable)e1);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
        }
    }
}

