/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.madgag.gif.fmsware.GifDecoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.images.TmmSvgIcon;
import org.tinymediamanager.ui.thirdparty.ShadowRenderer;

public class ImageLabel
extends JComponent {
    private static final long serialVersionUID = -2524445544386464158L;
    private static final Color EMPTY_BACKGROUND_COLOR = new Color(141, 165, 179);
    private static final TmmSvgIcon NO_IMAGE = ImageLabel.createNoImageIcon();
    private static final Dimension EMPTY_SIZE = new Dimension(0, 0);
    private static final int SHADOW_SIZE = 8;
    protected byte[] originalImageBytes;
    protected Dimension originalImageSize = EMPTY_SIZE;
    protected Image scaledImage;
    protected ImageIcon animatedGif;
    protected String imageUrl;
    protected String imagePath;
    protected Position position = Position.TOP_LEFT;
    protected boolean drawBorder;
    protected boolean drawFullWidth;
    protected boolean drawShadow;
    protected boolean enabledLightbox = false;
    protected boolean preferCache = true;
    protected boolean isLightBox = false;
    protected float desiredAspectRatio = 0.0f;
    protected boolean cacheUrl = false;
    protected boolean scaleUpIfTooSmall = true;
    protected ShadowRenderer shadowRenderer;
    protected SwingWorker<Void, Void> worker = null;
    protected MouseListener lightboxListener = null;

    private static TmmSvgIcon createNoImageIcon() {
        try {
            URI uri = IconManager.class.getResource("images/svg/image.svg").toURI();
            return new TmmSvgIcon(uri);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ImageLabel() {
        this(true, false);
    }

    public ImageLabel(boolean drawBorder) {
        this(drawBorder, false);
    }

    public ImageLabel(boolean drawBorder, boolean drawFullWidth) {
        this(drawBorder, drawFullWidth, false);
    }

    public ImageLabel(boolean drawBorder, boolean drawFullWidth, boolean drawShadow) {
        this.drawBorder = drawBorder;
        this.drawFullWidth = drawFullWidth;
        this.drawShadow = drawShadow;
        if (drawShadow) {
            this.shadowRenderer = new ShadowRenderer(8, 0.3f, Color.BLACK);
        }
    }

    public void setOriginalImage(byte[] originalImageBytes) {
        this.setImageBytes(originalImageBytes);
        this.recreateScaledImageIfNeeded(0, 0, this.getSize().width, this.getSize().height);
        this.repaint();
    }

    protected void setImageBytes(byte[] bytes) {
        this.originalImageBytes = bytes;
    }

    protected void createScaledImage(byte[] originalImageBytes, int width, int height) throws Exception {
        GifDecoder decoder = new GifDecoder();
        int status = decoder.read((InputStream)new ByteArrayInputStream(originalImageBytes));
        if (status == 0 && decoder.getFrameCount() > 1) {
            this.animatedGif = new ImageIcon(originalImageBytes);
            this.originalImageSize = new Dimension(decoder.getFrameSize().width, decoder.getFrameSize().height);
            this.scaledImage = this.animatedGif.getImage();
        } else {
            BufferedImage originalImage = ImageUtils.createImage(originalImageBytes);
            this.originalImageSize = new Dimension(originalImage.getWidth(), originalImage.getHeight());
            this.scaledImage = width < 1000 || height < 1000 ? Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS}) : Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            originalImage.flush();
            this.animatedGif = null;
        }
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String newValue) {
        String oldValue = this.imagePath;
        if (StringUtils.isNotEmpty((CharSequence)oldValue) && oldValue.equals(newValue)) {
            return;
        }
        this.imagePath = newValue;
        this.firePropertyChange("imagePath", oldValue, newValue);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.clearImageData();
        if (StringUtils.isBlank((CharSequence)newValue)) {
            this.repaint();
            return;
        }
        this.worker = new ImageLoader(this.imagePath, this.getSize());
        this.worker.execute();
        this.repaint();
    }

    public void clearImage() {
        this.imagePath = "";
        this.imageUrl = "";
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.clearImageData();
        this.repaint();
    }

    protected void clearImageData() {
        this.animatedGif = null;
        this.scaledImage = null;
        this.originalImageBytes = null;
        this.originalImageSize = EMPTY_SIZE;
        this.firePropertyChange("originalImageSize", null, (Object)0);
        this.firePropertyChange("originalImageBytes", null, new byte[0]);
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String newValue) {
        String oldValue = this.imageUrl;
        this.imageUrl = newValue;
        this.firePropertyChange("imageUrl", oldValue, newValue);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.clearImageData();
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            this.repaint();
            return;
        }
        this.worker = new ImageFetcher(this.imageUrl, this.getSize());
        this.worker.execute();
        this.repaint();
    }

    public void setDesiredAspectRatio(float desiredAspectRatio) {
        this.desiredAspectRatio = desiredAspectRatio;
    }

    public float getDesiredAspectRatio() {
        return this.desiredAspectRatio;
    }

    public void setScaleUpIfTooSmall(boolean scaleUpIfTooSmall) {
        this.scaleUpIfTooSmall = scaleUpIfTooSmall;
    }

    public byte[] getOriginalImageBytes() {
        return this.originalImageBytes;
    }

    public Dimension getOriginalImageSize() {
        return this.originalImageSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.originalImageSize != EMPTY_SIZE) {
            int parentWidth = this.getParent().getWidth();
            int parentHeight = this.getParent().getHeight();
            if (this.scaleUpIfTooSmall || parentWidth < this.originalImageSize.width || parentHeight < this.originalImageSize.height) {
                return new Dimension(this.getParent().getWidth(), (int)((float)(this.getParent().getWidth() - this.getShadowSize()) / (float)this.originalImageSize.width * (float)this.originalImageSize.height) + this.getShadowSize());
            }
            return new Dimension(this.originalImageSize.width, this.originalImageSize.height + this.getShadowSize());
        }
        if (this.desiredAspectRatio == 0.0f) {
            return super.getPreferredSize();
        }
        return new Dimension(this.getParent().getWidth(), (int)((float)(this.getParent().getWidth() - this.getShadowSize()) / this.desiredAspectRatio) + 1 + this.getShadowSize());
    }

    private int getShadowSize() {
        if (this.drawShadow) {
            return 8;
        }
        return 0;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if (!this.isShowing() || this.scaledImage != img) {
            return false;
        }
        return super.imageUpdate(img, infoflags, x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        block24: {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.scaledImage != null) {
                    int scaledImageWidth = this.scaledImage.getWidth(null);
                    int scaledImageHeight = this.scaledImage.getHeight(null);
                    Rectangle rectangle = new Rectangle();
                    if (this.drawBorder && !this.drawFullWidth && !this.drawShadow) {
                        Point size = ImageUtils.calculateSize(this.getMaxWidth() - 8, this.getMaxHeight() - 8, this.originalImageSize.width, this.originalImageSize.height, true);
                        if (this.position == Position.TOP_RIGHT || this.position == Position.BOTTOM_RIGHT) {
                            rectangle.x = this.getWidth() - size.x - 8;
                        }
                        if (this.position == Position.BOTTOM_LEFT || this.position == Position.BOTTOM_RIGHT) {
                            rectangle.y = this.getHeight() - size.y - 8;
                        }
                        if (this.position == Position.CENTER) {
                            rectangle.x = (this.getWidth() - size.x - 8) / 2;
                            rectangle.y = (this.getHeight() - size.y - 8) / 2;
                        }
                        rectangle.width = size.x;
                        rectangle.height = size.y;
                        g2d.setColor(Color.BLACK);
                        g2d.drawRect(rectangle.x, rectangle.y, size.x + 7, size.y + 7);
                        g2d.setColor(Color.WHITE);
                        g2d.fillRect(rectangle.x + 1, rectangle.y + 1, size.x + 6, size.y + 6);
                        Rectangle hiDpi = this.scaleHiDpi(g2d.getTransform(), rectangle);
                        this.recreateScaledImageIfNeeded(scaledImageWidth, scaledImageHeight, hiDpi.width, hiDpi.height);
                        Rectangle drawRectangle = new Rectangle(rectangle);
                        drawRectangle.x += 4;
                        drawRectangle.y += 4;
                        this.drawImageAtScale1x(this.scaledImage, g2d, this.scaleHiDpi(g2d.getTransform(), drawRectangle));
                    } else if (this.drawShadow && !this.drawFullWidth) {
                        Point size = ImageUtils.calculateSize(this.getMaxWidth() - 8, this.getMaxHeight() - 8, this.originalImageSize.width, this.originalImageSize.height, true);
                        rectangle.width = size.x;
                        rectangle.height = size.y;
                        Rectangle hiDpi = this.scaleHiDpi(g2d.getTransform(), rectangle);
                        this.recreateScaledImageIfNeeded(scaledImageWidth, scaledImageHeight, hiDpi.width, hiDpi.height);
                        if (this.scaledImage instanceof BufferedImage) {
                            BufferedImage shadowImage = this.shadowRenderer.createShadow((BufferedImage)this.scaledImage);
                            Rectangle shadowRectangle = new Rectangle(rectangle);
                            shadowRectangle.x = 8;
                            shadowRectangle.y = 8;
                            this.drawImageAtScale1x(shadowImage, g2d, this.scaleHiDpi(g2d.getTransform(), shadowRectangle));
                            shadowImage.flush();
                        }
                        this.drawImageAtScale1x(this.scaledImage, g2d, hiDpi);
                    } else {
                        Point size = this.drawFullWidth ? new Point(this.getMaxWidth(), this.getMaxWidth() * this.originalImageSize.height / this.originalImageSize.width) : ImageUtils.calculateSize(this.getMaxWidth(), this.getMaxHeight(), this.originalImageSize.width, this.originalImageSize.height, true);
                        if (this.position == Position.TOP_RIGHT || this.position == Position.BOTTOM_RIGHT) {
                            rectangle.x = this.getWidth() - size.x;
                        }
                        if (this.position == Position.BOTTOM_LEFT || this.position == Position.BOTTOM_RIGHT) {
                            rectangle.y = this.getHeight() - size.y;
                        }
                        if (this.position == Position.CENTER) {
                            rectangle.x = (this.getWidth() - size.x) / 2;
                            rectangle.y = (this.getHeight() - size.y) / 2;
                        }
                        rectangle.width = size.x;
                        rectangle.height = size.y;
                        Rectangle hiDpi = this.scaleHiDpi(g2d.getTransform(), rectangle);
                        this.recreateScaledImageIfNeeded(scaledImageWidth, scaledImageHeight, hiDpi.width, hiDpi.height);
                        this.drawImageAtScale1x(this.scaledImage, g2d, hiDpi);
                    }
                    break block24;
                }
                if (this.isLoading() || this.isLightBox) break block24;
                Rectangle rectangle = new Rectangle();
                if (this.drawShadow) {
                    rectangle.width = this.getMaxWidth() - 8;
                    rectangle.height = this.getMaxHeight() - 8;
                } else {
                    rectangle.width = this.getMaxWidth();
                    rectangle.height = this.getMaxHeight();
                }
                Rectangle hiDpi = this.scaleHiDpi(g2d.getTransform(), rectangle);
                int imageSize = (int)((double)Math.min(hiDpi.width, hiDpi.height) * 0.5 / 0.75);
                if (NO_IMAGE == null) break block24;
                Graphics g2 = null;
                try {
                    BufferedImage tmp = new BufferedImage(hiDpi.width, hiDpi.height, 2);
                    g2 = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(tmp);
                    FlatUIUtils.setRenderingHints((Graphics)g2);
                    g2.setColor(EMPTY_BACKGROUND_COLOR);
                    g2.fillRect(0, 0, hiDpi.width, hiDpi.height);
                    NO_IMAGE.setPreferredSize(new Dimension(imageSize, imageSize));
                    NO_IMAGE.setColor(UIManager.getColor("Panel.background"));
                    if (this.drawShadow) {
                        BufferedImage shadowImage = this.shadowRenderer.createShadow(tmp);
                        Rectangle shadowRectangle = new Rectangle(rectangle);
                        shadowRectangle.x = 8;
                        shadowRectangle.y = 8;
                        this.drawImageAtScale1x(shadowImage, g2d, this.scaleHiDpi(g2d.getTransform(), shadowRectangle));
                        shadowImage.flush();
                    }
                    g2.drawImage(NO_IMAGE.getImage(), (hiDpi.width - NO_IMAGE.getIconWidth()) / 2, (hiDpi.height - NO_IMAGE.getIconHeight()) / 2, null);
                    this.drawImageAtScale1x(tmp, g2d, hiDpi);
                    tmp.flush();
                }
                finally {
                    if (g2 != null) {
                        g2.dispose();
                    }
                }
            }
            catch (Exception e) {
                Rectangle rectangle = new Rectangle();
                rectangle.width = this.getMaxWidth();
                rectangle.height = this.getMaxHeight();
                Rectangle hiDpi = this.scaleHiDpi(g2d.getTransform(), rectangle);
                g2d.setColor(EMPTY_BACKGROUND_COLOR);
                g2d.fillRect(0, 0, hiDpi.width, hiDpi.height);
            }
            finally {
                g2d.dispose();
            }
        }
    }

    private int getMaxWidth() {
        if (!this.scaleUpIfTooSmall && this.originalImageSize != null) {
            return Math.min(this.getWidth(), this.originalImageSize.width);
        }
        return this.getWidth();
    }

    private int getMaxHeight() {
        if (!this.scaleUpIfTooSmall && this.originalImageSize != null) {
            return Math.min(this.originalImageSize.height, this.getHeight());
        }
        return this.getHeight();
    }

    private Rectangle scaleHiDpi(AffineTransform transform, Rectangle rectangle) {
        if (transform.getScaleX() == 1.0 && transform.getScaleY() == 1.0) {
            return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        double dx1 = transform.getScaleX();
        double dy2 = transform.getScaleY();
        double px = (double)rectangle.x * dx1 + transform.getTranslateX();
        double py = (double)rectangle.y * dy2 + transform.getTranslateY();
        dx1 *= (double)rectangle.width;
        dy2 *= (double)rectangle.height;
        int newx = (int)Math.floor(ImageLabel.normalize(px));
        int newy = (int)Math.floor(ImageLabel.normalize(py));
        dx1 = ImageLabel.normalize(px + dx1) - (double)newx;
        dy2 = ImageLabel.normalize(py + dy2) - (double)newy;
        return new Rectangle(newx, newy, (int)dx1, (int)dy2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImageAtScale1x(Image image, Graphics2D g2D, Rectangle rectangle) {
        AffineTransform transform = g2D.getTransform();
        try {
            if (transform.getScaleX() != 1.0 || transform.getScaleY() != 1.0) {
                g2D.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
            }
            g2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        }
        finally {
            g2D.setTransform(transform);
        }
    }

    private static double normalize(double value) {
        return Math.floor(value + 0.25) + 0.25;
    }

    protected boolean isLoading() {
        return this.worker != null && !this.worker.isDone();
    }

    private void recreateScaledImageIfNeeded(int originalWidth, int originalHeight, int newWidth, int newHeight) {
        if (this.animatedGif != null) {
            this.scaledImage = this.animatedGif.getImage();
        } else if (originalWidth < 20 || originalHeight < 20 || (float)newWidth * 0.8f > (float)originalWidth || (float)originalWidth > (float)newWidth * 1.2f || (float)newHeight * 0.8f > (float)originalHeight || (float)originalHeight > (float)newHeight * 1.2f) {
            try {
                this.createScaledImage(this.originalImageBytes, newWidth, newHeight);
            }
            catch (Exception e) {
                this.scaledImage = null;
            }
        }
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void enableLightbox() {
        this.enabledLightbox = true;
        if (this.lightboxListener == null) {
            this.lightboxListener = new ImageLabelClickListener();
            this.addMouseListener(this.lightboxListener);
        }
    }

    public void disableLightbox() {
        this.enabledLightbox = false;
        if (this.lightboxListener != null) {
            this.removeMouseListener(this.lightboxListener);
            this.lightboxListener = null;
        }
    }

    public void setPreferCache(boolean preferCache) {
        this.preferCache = preferCache;
    }

    public void setIsLightbox(boolean value) {
        this.isLightBox = value;
    }

    public void setCacheUrl(boolean cacheUrl) {
        this.cacheUrl = cacheUrl;
    }

    private class ImageLabelClickListener
    extends MouseAdapter {
        private ImageLabelClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getClickCount() == 1 && ImageLabel.this.scaledImage != null) {
                MainWindow.getInstance().createLightbox(ImageLabel.this.getImagePath(), ImageLabel.this.getImageUrl());
            }
        }
    }

    protected class ImageLoader
    extends SwingWorker<Void, Void> {
        private final String imagePath;
        private final Dimension newSize;

        public ImageLoader(String imagePath, Dimension newSize) {
            this.imagePath = imagePath;
            this.newSize = newSize;
        }

        @Override
        protected Void doInBackground() {
            Path file = null;
            if (ImageLabel.this.preferCache) {
                file = ImageCache.getCachedFile(Paths.get(this.imagePath, new String[0]));
            }
            if (file == null) {
                file = Paths.get(this.imagePath, new String[0]);
            }
            if (!Files.exists(file, new LinkOption[0]) && !ImageLabel.this.preferCache) {
                file = ImageCache.getCachedFile(Paths.get(this.imagePath, new String[0]));
            }
            if (file != null && Files.exists(file, new LinkOption[0])) {
                try {
                    byte[] bytes = Files.readAllBytes(file);
                    ImageLabel.this.clearImageData();
                    ImageLabel.this.setImageBytes(bytes);
                    ImageLabel.this.recreateScaledImageIfNeeded(0, 0, this.newSize.width, this.newSize.height);
                }
                catch (Exception e) {
                    ImageLabel.this.imagePath = "";
                    ImageLabel.this.clearImageData();
                }
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled() || !ImageLabel.this.imagePath.equals(this.imagePath)) {
                ImageLabel.this.imagePath = "";
                ImageLabel.this.clearImageData();
            } else {
                ImageLabel.this.firePropertyChange("originalImageBytes", null, ImageLabel.this.originalImageBytes);
                ImageLabel.this.firePropertyChange("originalImageSize", null, ImageLabel.this.originalImageSize);
            }
            ImageLabel.this.revalidate();
            ImageLabel.this.repaint();
        }
    }

    protected class ImageFetcher
    extends SwingWorker<Void, Void> {
        private final String imageUrl;
        private final Dimension newSize;

        public ImageFetcher(String imageUrl, Dimension newSize) {
            this.imageUrl = imageUrl;
            this.newSize = newSize;
        }

        @Override
        protected Void doInBackground() {
            try {
                Path cachedFile;
                if (ImageLabel.this.preferCache && (cachedFile = ImageCache.getCachedFile(this.imageUrl)) != null && Files.exists(cachedFile, new LinkOption[0])) {
                    try {
                        byte[] bytes = Files.readAllBytes(cachedFile);
                        ImageLabel.this.clearImageData();
                        ImageLabel.this.setImageBytes(bytes);
                        ImageLabel.this.recreateScaledImageIfNeeded(0, 0, this.newSize.width, this.newSize.height);
                        return null;
                    }
                    catch (Exception e) {
                        ImageLabel.this.imagePath = "";
                        ImageLabel.this.clearImageData();
                    }
                }
                Url url = ImageLabel.this.cacheUrl ? new InMemoryCachedUrl(this.imageUrl) : new Url(this.imageUrl);
                byte[] bytes = url.getBytesWithRetry(2);
                ImageLabel.this.clearImageData();
                ImageLabel.this.setImageBytes(bytes);
                ImageLabel.this.recreateScaledImageIfNeeded(0, 0, this.newSize.width, this.newSize.height);
            }
            catch (Exception e) {
                ImageLabel.this.imageUrl = "";
                ImageLabel.this.clearImageData();
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled() || !ImageLabel.this.imageUrl.equals(this.imageUrl)) {
                ImageLabel.this.imageUrl = "";
                ImageLabel.this.clearImageData();
            } else {
                ImageLabel.this.firePropertyChange("originalImageBytes", null, ImageLabel.this.originalImageBytes);
                ImageLabel.this.firePropertyChange("originalImageSize", null, ImageLabel.this.originalImageSize);
            }
            ImageLabel.this.revalidate();
            ImageLabel.this.repaint();
        }
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER;

    }
}

