/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JHintCheckBox
extends JCheckBox {
    private static final long serialVersionUID = -3513765234706901506L;
    private final Insets dummyInsets;
    private final MouseAdapter tooltipAdapter = this.createMouseAdapter();
    private Icon hintIcon = null;

    private MouseAdapter createMouseAdapter() {
        return new MouseAdapter(){
            final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
            final int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(10L);

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
            }
        };
    }

    public JHintCheckBox() {
        Border border = UIManager.getBorder("CheckBox.border");
        JTextField dummy = new JTextField();
        this.dummyInsets = border.getBorderInsets(dummy);
    }

    public JHintCheckBox(String text) {
        super(text);
        Border border = UIManager.getBorder("CheckBox.border");
        JTextField dummy = new JTextField();
        this.dummyInsets = border.getBorderInsets(dummy);
    }

    public void setHintIcon(Icon icon) {
        this.hintIcon = icon;
    }

    public Icon getHintIcon() {
        return this.hintIcon;
    }

    @Override
    public void setToolTipText(String text) {
        this.removeMouseListener(this.tooltipAdapter);
        this.addMouseListener(this.tooltipAdapter);
        super.setToolTipText(text);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int textX = 2;
        if (this.hintIcon != null) {
            int iconWidth = this.hintIcon.getIconWidth();
            int x = this.getWidth() - this.dummyInsets.right - iconWidth - 2;
            textX = this.dummyInsets.right + iconWidth + 4;
            int y = 4;
            this.hintIcon.paintIcon(this, g, x, y);
        }
        this.setMargin(new Insets(2, 2, 2, textX));
    }
}

