/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.WritableTableFormat;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;

public class MediaIdTable
extends TmmTable {
    private static final long serialVersionUID = 8010722883277208728L;
    private final Map<String, Object> idMap;
    private final EventList<MediaId> idList;

    public MediaIdTable(Map<String, Object> ids) {
        this.idMap = ids;
        this.idList = MediaIdTable.convertIdMapToEventList(this.idMap);
        this.setModel((TableModel)((Object)new TmmTableModel<MediaId>(this.idList, new MediaIdTableFormat(false))));
        this.setTableHeader(null);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public MediaIdTable(EventList<MediaId> ids) {
        this.idMap = null;
        this.idList = ids;
        this.setModel((TableModel)((Object)new TmmTableModel<MediaId>(this.idList, new MediaIdTableFormat(true))));
        this.setTableHeader(null);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public static EventList<MediaId> convertIdMapToEventList(Map<String, Object> idMap) {
        BasicEventList idList = new BasicEventList();
        for (Map.Entry<String, Object> entry : idMap.entrySet()) {
            MediaId id = new MediaId();
            id.key = entry.getKey();
            try {
                id.value = entry.getValue().toString();
            }
            catch (Exception e) {
                id.value = "";
            }
            idList.add((Object)id);
        }
        return idList;
    }

    private static class MediaIdTableFormat
    extends TmmTableFormat<MediaId>
    implements WritableTableFormat<MediaId> {
        private final boolean editable;

        public MediaIdTableFormat(boolean editable) {
            this.editable = editable;
            TmmTableFormat.Column col = new TmmTableFormat.Column("", "key", mediaId -> mediaId.key, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column("", "value", mediaId -> mediaId.value, String.class);
            this.addColumn(col);
        }

        public boolean isEditable(MediaId arg0, int arg1) {
            return this.editable && arg1 == 1;
        }

        public MediaId setColumnValue(MediaId arg0, Object arg1, int arg2) {
            if (arg0 == null || arg1 == null) {
                return null;
            }
            switch (arg2) {
                case 0: {
                    arg0.key = arg1.toString();
                    break;
                }
                case 1: {
                    arg0.value = arg1.toString();
                }
            }
            return arg0;
        }
    }

    public static class MediaId {
        public String key;
        public String value;

        public MediaId() {
        }

        public MediaId(String key) {
            this.key = key;
        }

        public int hashCode() {
            return new HashCodeBuilder(19, 31).append((Object)this.key).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MediaId) || obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            MediaId other = (MediaId)obj;
            return StringUtils.equals((CharSequence)this.key, (CharSequence)other.key);
        }
    }
}

