/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.PersonEditorDialog;

public class PersonTable
extends TmmTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonTable.class);

    public PersonTable(EventList<Person> personEventList) {
        this.setModel((TableModel)((Object)new TmmTableModel<Person>((EventList<Person>)GlazedListsSwing.swingThreadProxyList(personEventList), new PersonTableFormat())));
        this.adjustColumnPreferredWidths(3);
        PersonTableButtonListener listener = new PersonTableButtonListener(this, personEventList, TmmResourceBundle.getString("cast.edit"));
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void onPersonChanged(Person person) {
    }

    private class PersonTableButtonListener
    implements MouseListener,
    MouseMotionListener {
        private final JTable personTable;
        private final EventList<Person> personEventList;
        private final String windowTitle;

        private PersonTableButtonListener(JTable personTable2, EventList<Person> personEventList, String windowTitle) {
            this.personTable = personTable2;
            this.personEventList = personEventList;
            this.windowTitle = windowTitle;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            Person person;
            int col;
            int row = this.personTable.rowAtPoint(arg0.getPoint());
            if (this.isLinkColumn(row, col = this.personTable.columnAtPoint(arg0.getPoint())) && (person = (Person)this.personEventList.get(row = this.personTable.convertRowIndexToModel(row))) != null) {
                if (this.isEditorColumn(col)) {
                    PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(this.personTable), this.windowTitle, person);
                    dialog.setVisible(true);
                    if (dialog.isSavePressed()) {
                        PersonTable.this.onPersonChanged(person);
                    }
                } else if (this.isProfileColumn(row, col)) {
                    try {
                        TmmUIHelper.browseUrl(person.getProfileUrl());
                    }
                    catch (Exception e1) {
                        LOGGER.error("Opening actor profile", (Throwable)e1);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)person.getProfileUrl(), "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            int col;
            Point point;
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(point = new Point(e.getX(), e.getY()));
            if (this.isLinkColumn(row, col = table.columnAtPoint(point))) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int col;
            Point point;
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(point = new Point(e.getX(), e.getY()));
            if (!this.isLinkColumn(row, col = table.columnAtPoint(point))) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int col;
            Point point;
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(point = new Point(e.getX(), e.getY()));
            if (!this.isLinkColumn(row, col = table.columnAtPoint(point)) && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if (this.isLinkColumn(row, col) && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }

        private boolean isLinkColumn(int row, int column) {
            return this.isEditorColumn(column) || this.isProfileColumn(row, column);
        }

        private boolean isProfileColumn(int row, int column) {
            if (column < 0 || row < 0) {
                return false;
            }
            if (!"profileUrl".equals(this.personTable.getColumnModel().getColumn(column).getIdentifier())) {
                return false;
            }
            row = this.personTable.convertRowIndexToModel(row);
            Person person = (Person)this.personEventList.get(row);
            return StringUtils.isNotBlank((CharSequence)person.getProfileUrl());
        }

        private boolean isEditorColumn(int column) {
            if (column < 0) {
                return false;
            }
            return "edit".equals(this.personTable.getColumnModel().getColumn(column).getIdentifier());
        }
    }

    private static class PersonTableFormat
    extends TmmTableFormat<Person> {
        private PersonTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.name"), "name", Person::getName, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.role"), "role", Person::getRole, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("image.url"), "imageUrl", person -> {
                if (StringUtils.isNotBlank((CharSequence)person.getThumbUrl())) {
                    return IconManager.TABLE_OK;
                }
                return IconManager.TABLE_NOT_OK;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.IMAGES);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("profile.url"), "profileUrl", person -> {
                if (StringUtils.isNotBlank((CharSequence)person.getProfileUrl())) {
                    return IconManager.TABLE_OK;
                }
                return IconManager.TABLE_NOT_OK;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.IDCARD);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }
}

