/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ReadOnlyTextArea
extends JTextArea {
    public ReadOnlyTextArea() {
        this("");
    }

    public ReadOnlyTextArea(String text) {
        super(text);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOpaque(false);
        this.setBorder(null);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setEditable(false);
        this.setFocusable(false);
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setCaret(new NullCaret());
    }

    @Override
    public void setText(String t) {
        try {
            Document doc = this.getDocument();
            doc.remove(0, doc.getLength());
            doc.insertString(0, t, null);
        }
        catch (BadLocationException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    private static final class NullCaret
    implements Caret {
        private NullCaret() {
        }

        @Override
        public void setVisible(boolean v) {
        }

        @Override
        public void setSelectionVisible(boolean v) {
        }

        @Override
        public void setMagicCaretPosition(Point p) {
        }

        @Override
        public void setDot(int dot) {
        }

        @Override
        public void setBlinkRate(int rate) {
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void moveDot(int dot) {
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public boolean isSelectionVisible() {
            return false;
        }

        @Override
        public void install(JTextComponent c) {
        }

        @Override
        public int getMark() {
            return 0;
        }

        @Override
        public Point getMagicCaretPosition() {
            return new Point(0, 0);
        }

        @Override
        public int getDot() {
            return 0;
        }

        @Override
        public int getBlinkRate() {
            return 0;
        }

        @Override
        public void deinstall(JTextComponent c) {
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }
}

