/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import javax.swing.event.HyperlinkEvent;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;

public class ReadOnlyTextPaneHTML
extends ReadOnlyTextPane {
    private static final long serialVersionUID = 1L;
    private static final Document.OutputSettings NO_PRETTYPRINT = new Document.OutputSettings().prettyPrint(false);

    public ReadOnlyTextPaneHTML() {
        this.setContentType("text/html");
        this.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                try {
                    TmmUIHelper.browseUrl(e.getURL().toURI().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void setText(String t) {
        if (t == null || t.isEmpty()) {
            super.setText("<html></html>");
        } else if (t.startsWith("<html>")) {
            super.setText(t);
        } else if (t.contains("http") || t.contains("www")) {
            t = Jsoup.clean((String)t, (String)"", (Whitelist)Whitelist.simpleText(), (Document.OutputSettings)NO_PRETTYPRINT);
            t = t.replaceAll("\\n", " <br/> ");
            t = t.replaceAll("(?:https|http)://([^\\s]+)", "<a href=\"$0\">$1</a>");
            t = t.replaceAll("(?:^|\\s)(www\\.[^\\s]+)", " <a href=\"https://$1\">$1</a>");
            super.setText("<html>" + t + "</html>");
        } else {
            t = t.replaceAll("\\n", " <br/> ");
            super.setText(t);
        }
    }
}

