/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxItem;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxSelectionListener;

public class ScraperMetadataConfigCheckComboBox<E extends ScraperMetadataConfig>
extends TmmCheckComboBox<E> {
    private static final long serialVersionUID = 8153649858409237947L;

    public ScraperMetadataConfigCheckComboBox(List<E> scrapers) {
        super(scrapers);
    }

    public ScraperMetadataConfigCheckComboBox(E[] scrapers) {
        super(scrapers);
    }

    @Override
    protected void setRenderer() {
        this.setRenderer(new ScraperMetadataConfigRenderer());
    }

    @Override
    protected void init() {
        super.init();
        this.setEditor(new ScraperMetadataConfigEditor());
    }

    @Override
    public void setItems(Collection<E> items) {
        this.model.removeAllElements();
        this.checkComboBoxItems.clear();
        this.comboBoxItemMap.clear();
        TmmCheckComboBoxItem<Object> checkComboBoxItem = new TmmCheckComboBoxItem(TmmResourceBundle.getString("Button.selectall"));
        checkComboBoxItem.setSelected(false);
        this.checkComboBoxItems.add(checkComboBoxItem);
        checkComboBoxItem = new TmmCheckComboBoxItem(TmmResourceBundle.getString("Button.selectnone"));
        checkComboBoxItem.setSelected(true);
        this.checkComboBoxItems.add(checkComboBoxItem);
        this.checkComboBoxItems.add(this.nullItem);
        for (ScraperMetadataConfig item : items) {
            checkComboBoxItem = new TmmCheckComboBoxItem<ScraperMetadataConfig>(item);
            checkComboBoxItem.setText(item.getDescription());
            checkComboBoxItem.setToolTipText(item.getToolTip());
            this.checkComboBoxItems.add(checkComboBoxItem);
            this.comboBoxItemMap.put(item, checkComboBoxItem);
        }
        this.model.addAll(this.checkComboBoxItems);
    }

    private static class ScraperMetadataConfigEditorItem
    extends JPanel {
        final /* synthetic */ ScraperMetadataConfigCheckComboBox this$0;

        public ScraperMetadataConfigEditorItem(E userObject) {
            this.this$0 = var1_1;
            this.putClientProperty("class", "roundedPanel");
            this.putClientProperty("borderRadius", 6);
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(null);
            JLabel label = new JLabel(userObject.getDescription());
            label.setToolTipText(userObject.getToolTip());
            label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
            this.add(label);
            FlatButton button = new FlatButton(IconManager.DELETE);
            button.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            button.addActionListener(e -> {
                TmmCheckComboBoxItem item = (TmmCheckComboBoxItem)this.this$0.comboBoxItemMap.get(userObject);
                if (item != null) {
                    int index = this.this$0.model.getIndexOf(item);
                    if (index > -1) {
                        this.this$0.checkBoxSelectionChanged(index);
                        for (TmmCheckComboBoxSelectionListener listener : this.this$0.changedListeners) {
                            listener.selectionChanged(index);
                        }
                    }
                    this.this$0.update();
                }
            });
            this.add(button);
        }
    }

    private class ScraperMetadataConfigEditor
    extends TmmCheckComboBox.CheckBoxEditor {
        private ScraperMetadataConfigEditor() {
        }

        @Override
        protected JComponent getEditorItem(E userObject) {
            return new ScraperMetadataConfigEditorItem(ScraperMetadataConfigCheckComboBox.this, userObject);
        }
    }

    private class ScraperMetadataConfigRenderer
    extends TmmCheckComboBox.CheckBoxRenderer {
        private ScraperMetadataConfigRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TmmCheckComboBoxItem<E>> list, TmmCheckComboBoxItem<E> value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index >= 0 && index <= ScraperMetadataConfigCheckComboBox.this.model.getSize()) {
                TmmCheckComboBoxItem cb = (TmmCheckComboBoxItem)ScraperMetadataConfigCheckComboBox.this.model.getElementAt(index);
                if (cb == ScraperMetadataConfigCheckComboBox.this.nullItem) {
                    list.setToolTipText(null);
                    return this.separator;
                }
                if (isSelected) {
                    cb.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    cb.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                    list.setToolTipText(cb.getText());
                } else {
                    cb.setBackground(UIManager.getColor("ComboBox.background"));
                    cb.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
                return cb;
            }
            list.setToolTipText(null);
            return this.defaultRenderer.getListCellRendererComponent(list, TmmResourceBundle.getString("ComboBox.select"), index, isSelected, cellHasFocus);
        }
    }
}

