/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.BiPredicate;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxFilterDecorator;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxItem;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxSelectionListener;

public class TmmCheckComboBox<E>
extends JComboBox<TmmCheckComboBoxItem<E>> {
    private static final long serialVersionUID = -7796247854176782396L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    protected final DefaultComboBoxModel<TmmCheckComboBoxItem<E>> model;
    protected final List<TmmCheckComboBoxItem<E>> checkComboBoxItems;
    protected final Map<E, TmmCheckComboBoxItem<E>> comboBoxItemMap;
    protected final List<TmmCheckComboBoxSelectionListener> changedListeners = new ArrayList<TmmCheckComboBoxSelectionListener>();
    protected final TmmCheckComboBoxItem<E> nullItem = new TmmCheckComboBoxItem(null);
    protected JComponent editor = null;
    protected TmmCheckComboBoxFilterDecorator<E> decorator;

    public TmmCheckComboBox() {
        this(Collections.emptyList());
    }

    public TmmCheckComboBox(E[] items) {
        this(Arrays.asList(items));
    }

    public TmmCheckComboBox(Collection<E> items) {
        this.model = new DefaultComboBoxModel();
        this.setModel(this.model);
        this.checkComboBoxItems = new ArrayList<TmmCheckComboBoxItem<E>>();
        this.comboBoxItemMap = new HashMap<E, TmmCheckComboBoxItem<E>>();
        this.init();
        this.setItems(items);
    }

    protected void init() {
        this.setEditable(true);
        this.setEditor(new CheckBoxEditor());
        this.setRenderer();
        this.addActionListener(this);
    }

    public void enableFilter(BiPredicate<E, String> userFilter) {
        this.decorator = TmmCheckComboBoxFilterDecorator.decorate(this, userFilter);
    }

    @Override
    public void doLayout() {
        super.doLayout();
    }

    public void setItems(Collection<E> items) {
        this.model.removeAllElements();
        this.checkComboBoxItems.clear();
        this.comboBoxItemMap.clear();
        TmmCheckComboBoxItem checkComboBoxItem = new TmmCheckComboBoxItem(TmmResourceBundle.getString("Button.selectall"));
        checkComboBoxItem.setSelected(false);
        this.checkComboBoxItems.add(checkComboBoxItem);
        checkComboBoxItem = new TmmCheckComboBoxItem(TmmResourceBundle.getString("Button.selectnone"));
        checkComboBoxItem.setSelected(true);
        this.checkComboBoxItems.add(checkComboBoxItem);
        this.checkComboBoxItems.add(this.nullItem);
        for (E item : items) {
            checkComboBoxItem = new TmmCheckComboBoxItem<E>(item);
            this.checkComboBoxItems.add(checkComboBoxItem);
            this.comboBoxItemMap.put(item, checkComboBoxItem);
        }
        this.model.addAll(this.checkComboBoxItems);
    }

    @Override
    public void setEditor(ComboBoxEditor anEditor) {
        super.setEditor(anEditor);
        if (anEditor instanceof JComponent) {
            this.editor = (JComponent)((Object)anEditor);
        }
    }

    public void addSelectionChangedListener(TmmCheckComboBoxSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.changedListeners.add(listener);
    }

    public void removeSelectionChangedListener(TmmCheckComboBoxSelectionListener listener) {
        this.changedListeners.remove(listener);
    }

    public List<E> getSelectedItems() {
        ArrayList<E> selected = new ArrayList<E>();
        for (TmmCheckComboBoxItem<E> item : this.checkComboBoxItems) {
            if (!item.isSelected() || item.getUserObject() == null) continue;
            selected.add(item.getUserObject());
        }
        return selected;
    }

    public List<E> getItems() {
        ArrayList<E> items = new ArrayList<E>();
        for (TmmCheckComboBoxItem<E> item : this.checkComboBoxItems) {
            if (item.getUserObject() == null) continue;
            items.add(item.getUserObject());
        }
        return items;
    }

    public void setSelectedItems(Collection<E> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        int n = this.model.getSize();
        boolean dirty = false;
        for (int i = 0; i < n; ++i) {
            TmmCheckComboBoxItem<E> cb = this.model.getElementAt(i);
            if (cb == this.nullItem) continue;
            boolean oldState = cb.isSelected();
            if (items.contains(cb.getUserObject())) {
                cb.setSelected(true);
                if (oldState) continue;
                dirty = true;
                continue;
            }
            cb.setSelected(false);
            if (!oldState) continue;
            dirty = true;
        }
        if (dirty) {
            this.model.getElementAt(0).setSelected(items.size() == n - 3);
            this.model.getElementAt(1).setSelected(items.isEmpty());
            this.update();
        }
    }

    public void clearSelection() {
        int n = this.model.getSize();
        boolean dirty = false;
        for (int i = 0; i < n; ++i) {
            TmmCheckComboBoxItem<E> cb = this.model.getElementAt(i);
            if (cb == this.nullItem) continue;
            boolean oldState = cb.isSelected();
            cb.setSelected(false);
            if (!oldState) continue;
            dirty = true;
        }
        if (dirty) {
            this.model.getElementAt(0).setSelected(false);
            this.model.getElementAt(1).setSelected(true);
            this.update();
        }
    }

    public void setSelectedItems(E[] items) {
        this.setSelectedItems(Arrays.asList(items));
    }

    protected void update() {
        this.revalidate();
        this.repaint();
        if (this.isEditable()) {
            this.getEditor().setItem(null);
        }
    }

    protected void setRenderer() {
        this.setRenderer(new CheckBoxRenderer());
    }

    protected void checkBoxSelectionChanged(int index) {
        int n = this.model.getSize();
        if (index < 0 || index >= n) {
            return;
        }
        if (index > 1) {
            TmmCheckComboBoxItem<E> cb = this.model.getElementAt(index);
            if (cb == this.nullItem) {
                return;
            }
            if (cb.isSelected()) {
                cb.setSelected(false);
                this.model.getElementAt(0).setSelected(false);
                this.model.getElementAt(1).setSelected(this.getSelectedItems() == null);
            } else {
                cb.setSelected(true);
                List<E> sobjs = this.getSelectedItems();
                this.model.getElementAt(0).setSelected(sobjs != null && sobjs.size() == n - 3);
                this.model.getElementAt(1).setSelected(false);
            }
        } else if (index == 0) {
            for (int i = 0; i < n; ++i) {
                if (this.model.getElementAt(i) == this.nullItem) continue;
                this.model.getElementAt(i).setSelected(true);
            }
            this.model.getElementAt(1).setSelected(false);
        } else if (index == 1) {
            for (int i = 0; i < n; ++i) {
                if (this.model.getElementAt(i) == this.nullItem) continue;
                this.model.getElementAt(i).setSelected(false);
            }
            this.model.getElementAt(1).setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int sel = this.getSelectedIndex();
        if (sel < 0) {
            this.getUI().setPopupVisible(this, false);
        } else {
            this.checkBoxSelectionChanged(sel);
            for (TmmCheckComboBoxSelectionListener listener : this.changedListeners) {
                listener.selectionChanged(sel);
            }
        }
        this.setSelectedIndex(-1);
    }

    @Override
    public void setPopupVisible(boolean flag) {
    }

    protected class CheckBoxEditorItem
    extends JPanel {
        public CheckBoxEditorItem(E userObject) {
            this.putClientProperty("class", "roundedPanel");
            this.putClientProperty("borderRadius", 6);
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(null);
            JLabel label = new JLabel(userObject.toString());
            label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
            this.add(label);
            FlatButton button = new FlatButton(IconManager.DELETE);
            button.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            button.addActionListener(e -> {
                int index;
                TmmCheckComboBoxItem item = TmmCheckComboBox.this.comboBoxItemMap.get(userObject);
                if (item != null && (index = TmmCheckComboBox.this.model.getIndexOf(item)) > -1) {
                    TmmCheckComboBox.this.checkBoxSelectionChanged(index);
                    for (TmmCheckComboBoxSelectionListener listener : TmmCheckComboBox.this.changedListeners) {
                        listener.selectionChanged(index);
                    }
                    TmmCheckComboBox.this.update();
                    TmmCheckComboBox.this.setSelectedIndex(-1);
                }
            });
            this.add(button);
        }
    }

    protected class CheckBoxEditor
    extends JPanel
    implements ComboBoxEditor {
        private Dimension cachedLayoutSize;

        public CheckBoxEditor() {
            this.setLayout(new WrapLayout(0, 5, 2));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(-2, -5, 2, 0));
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void doLayout() {
            super.doLayout();
            if (this.cachedLayoutSize == null || this.cachedLayoutSize.height != this.getMinimumSize().height) {
                this.firePropertyChange("border", false, true);
                this.cachedLayoutSize = this.getMinimumSize();
            }
        }

        @Override
        public void setItem(Object anObject) {
            this.removeAll();
            List objs = TmmCheckComboBox.this.getSelectedItems();
            if (objs.isEmpty()) {
                this.add(new JLabel(TmmResourceBundle.getString("ComboBox.select")));
            } else {
                for (Object obj : objs) {
                    this.add(this.getEditorItem(obj));
                }
            }
            this.firePropertyChange("border", true, false);
            this.revalidate();
        }

        protected JComponent getEditorItem(E userObject) {
            return new CheckBoxEditorItem(userObject);
        }

        @Override
        public Object getItem() {
            return TmmCheckComboBox.this.getSelectedItems();
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }
    }

    protected class CheckBoxRenderer
    implements ListCellRenderer<TmmCheckComboBoxItem<E>> {
        protected final ListCellRenderer defaultRenderer;
        protected final JSeparator separator = new JSeparator(0);

        public CheckBoxRenderer() {
            this.defaultRenderer = new JComboBox().getRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TmmCheckComboBoxItem<E>> list, TmmCheckComboBoxItem<E> value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index >= 0 && index <= TmmCheckComboBox.this.model.getSize()) {
                TmmCheckComboBoxItem cb = TmmCheckComboBox.this.model.getElementAt(index);
                if (cb == TmmCheckComboBox.this.nullItem) {
                    list.setToolTipText(null);
                    return this.separator;
                }
                if (isSelected) {
                    cb.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    cb.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                    list.setToolTipText(cb.getText());
                } else {
                    cb.setBackground(UIManager.getColor("ComboBox.background"));
                    cb.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
                return cb;
            }
            list.setToolTipText(null);
            return this.defaultRenderer.getListCellRendererComponent(list, TmmResourceBundle.getString("ComboBox.select"), index, isSelected, cellHasFocus);
        }
    }
}

