/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.datepicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.components.datepicker.DayPanel;
import org.tinymediamanager.ui.components.datepicker.MonthComboBox;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;

class CalendarPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 2214699062624370112L;
    private Calendar calendar;
    protected Locale locale;
    MonthComboBox monthComboBox;
    YearSpinner yearSpinner;
    DayPanel dayPanel;

    public CalendarPanel(Date date) {
        this.setLayout(new BorderLayout());
        this.locale = Locale.getDefault();
        this.calendar = Calendar.getInstance(this.locale);
        JPanel monthYearPanel = new JPanel();
        monthYearPanel.setLayout(new BorderLayout());
        this.monthComboBox = new MonthComboBox();
        this.yearSpinner = new YearSpinner();
        monthYearPanel.add((Component)this.monthComboBox, "West");
        monthYearPanel.add((Component)this.yearSpinner, "Center");
        monthYearPanel.setBorder(BorderFactory.createEmptyBorder());
        this.dayPanel = new DayPanel();
        this.dayPanel.setMonth(this.monthComboBox.getSelectedIndex());
        this.dayPanel.setYear((Integer)this.yearSpinner.getValue());
        this.dayPanel.addPropertyChangeListener(this);
        this.dayPanel.setLocale(this.locale);
        this.monthComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                int index = this.monthComboBox.getSelectedIndex();
                Calendar c = (Calendar)this.calendar.clone();
                c.set(2, index);
                this.setCalendar(c, false);
                this.dayPanel.setMonth(index);
            }
        });
        this.yearSpinner.addChangeListener(e -> {
            SpinnerNumberModel model = (SpinnerNumberModel)this.yearSpinner.getModel();
            int value = model.getNumber().intValue();
            Calendar c = (Calendar)this.calendar.clone();
            c.set(1, value);
            this.setCalendar(c, false);
            this.dayPanel.setYear(value);
        });
        this.add((Component)monthYearPanel, "North");
        this.add((Component)this.dayPanel, "Center");
        JPanel specialButtonPanel = new JPanel();
        JButton todayButton = new JButton();
        todayButton.addActionListener(e -> this.setDate(new Date()));
        JButton noDateButton = new JButton();
        noDateButton.addActionListener(e -> this.firePropertyChange("day", 0, -1));
        specialButtonPanel.setLayout(new GridLayout(1, 3));
        todayButton.setText(TmmResourceBundle.getString("Button.today"));
        specialButtonPanel.add(todayButton);
        specialButtonPanel.add(new JLabel(""));
        noDateButton.setText(TmmResourceBundle.getString("Button.nodate"));
        specialButtonPanel.add(noDateButton);
        this.add((Component)specialButtonPanel, "South");
        if (date != null) {
            this.calendar.setTime(date);
        }
        this.setCalendar(this.calendar);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            if (evt.getPropertyName().equals("day")) {
                c.set(5, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
                this.firePropertyChange("day", evt.getOldValue(), evt.getNewValue());
            } else if (evt.getPropertyName().equals("date")) {
                c.setTime((Date)evt.getNewValue());
                this.setCalendar(c, true);
            }
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, true);
    }

    private void setCalendar(Calendar newCalendar, boolean update) {
        if (newCalendar == null) {
            return;
        }
        Calendar oldCalendar = this.calendar;
        this.calendar = newCalendar;
        if (update) {
            this.yearSpinner.setValue(newCalendar.get(1));
            this.monthComboBox.setSelectedIndex(newCalendar.get(2));
            this.dayPanel.setDay(newCalendar.get(5));
        }
        this.firePropertyChange("calendar", oldCalendar, this.calendar);
    }

    public Date getDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public void setDate(Date date) {
        Date oldDate = this.calendar.getTime();
        this.calendar.setTime(date);
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int day = this.calendar.get(5);
        this.yearSpinner.setValue(year);
        this.monthComboBox.setSelectedIndex(month);
        this.dayPanel.setCalendar(this.calendar);
        this.dayPanel.setDay(day);
        this.firePropertyChange("date", oldDate, date);
    }
}

