/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tinymediamanager.ui.components.table.TmmTableFormat;

public class TmmTableModel<E>
extends DefaultEventTableModel<E> {
    private final TmmTableFormat<? super E> tmmTableFormat;

    public TmmTableModel(EventList<E> source, TmmTableFormat<? super E> tableFormat) {
        super(source, tableFormat);
        this.tmmTableFormat = tableFormat;
    }

    public void setUpColumn(TableColumn column) {
        ImageIcon headerIcon;
        int columnIndex = column.getModelIndex();
        column.setIdentifier(this.tmmTableFormat.getColumnIdentifier(columnIndex));
        TableCellRenderer tableCellRenderer = this.tmmTableFormat.getCellRenderer(columnIndex);
        if (tableCellRenderer != null) {
            column.setCellRenderer(tableCellRenderer);
        }
        if ((headerIcon = this.tmmTableFormat.getHeaderIcon(columnIndex)) != null) {
            column.setHeaderValue(headerIcon);
        }
        if (column.getHeaderRenderer() instanceof JComponent) {
            ((JComponent)((Object)column.getHeaderRenderer())).setToolTipText(this.getHeaderTooltip(columnIndex));
        }
        column.setResizable(this.tmmTableFormat.getColumnResizeable(columnIndex));
        column.setMinWidth(this.tmmTableFormat.getMinWidth(columnIndex));
        if (this.tmmTableFormat.getMaxWidth(columnIndex) > 0) {
            column.setMaxWidth(this.tmmTableFormat.getMaxWidth(columnIndex));
        }
    }

    public String getHeaderTooltip(int column) {
        return this.tmmTableFormat.getColumnName(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTooltipAt(int row, int column) {
        String tooltip;
        this.source.getReadWriteLock().readLock().lock();
        try {
            tooltip = this.tmmTableFormat.getColumnTooltip(this.source.get(row), column);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
        return tooltip;
    }
}

