/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class ToolbarLabel
extends JLabel {
    public static Color COLOR = Color.GRAY;
    public static Color COLOR_HOVER = Color.WHITE;
    protected final String defaultText;
    private ActionListener action = null;

    public ToolbarLabel(String text) {
        super(text, 0);
        this.defaultText = text;
        this.setHorizontalTextPosition(2);
        this.setVerticalTextPosition(3);
        this.setOpaque(false);
        this.setForeground(COLOR);
        this.setMouseListener();
    }

    public ToolbarLabel(String text, ActionListener action) {
        this(text);
        this.action = action;
    }

    protected void setMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarLabel.this.setForeground(COLOR);
                ToolbarLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                ToolbarLabel.this.setForeground(COLOR_HOVER);
                ToolbarLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (ToolbarLabel.this.action != null) {
                    ToolbarLabel.this.action.actionPerformed(new ActionEvent(ToolbarLabel.this, 1001, ""));
                }
            }
        });
    }
}

