/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.toolbar.ToolbarLabel;

public class ToolbarMenu
extends ToolbarLabel {
    public static Color COLOR = Color.GRAY;
    public static Color COLOR_HOVER = Color.WHITE;
    protected JPopupMenu popupMenu = null;

    public ToolbarMenu(String text) {
        super(text);
    }

    public ToolbarMenu(String text, JPopupMenu popupMenu) {
        this(text);
        if (popupMenu != null) {
            this.setPopupMenu(popupMenu);
        }
    }

    @Override
    protected void setMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent arg0) {
                ToolbarMenu.this.setForeground(COLOR);
                if (ToolbarMenu.this.popupMenu != null) {
                    ToolbarMenu.this.setIcon(IconManager.TOOLBAR_MENU_INDICATOR);
                    ToolbarMenu.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                ToolbarMenu.this.setForeground(COLOR_HOVER);
                if (ToolbarMenu.this.popupMenu != null) {
                    ToolbarMenu.this.setIcon(IconManager.TOOLBAR_MENU_INDICATOR_HOVER);
                    ToolbarMenu.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ToolbarMenu.this.popupMenu != null) {
                    int x = ToolbarMenu.this.getWidth() - (int)ToolbarMenu.this.popupMenu.getPreferredSize().getWidth();
                    if (x < 0) {
                        x = 0;
                    }
                    int y = ToolbarMenu.this.getHeight();
                    ToolbarMenu.this.popupMenu.show(ToolbarMenu.this, x, y);
                }
            }
        });
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        if (popupMenu == null || StringUtils.isBlank((CharSequence)popupMenu.getLabel())) {
            this.setText(this.defaultText);
        } else {
            this.setText(popupMenu.getLabel());
        }
        if (popupMenu != null) {
            this.setIcon(IconManager.TOOLBAR_MENU_INDICATOR);
        } else {
            this.setIcon(null);
        }
    }
}

