/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toolbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.license.License;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.AboutAction;
import org.tinymediamanager.ui.actions.BugReportAction;
import org.tinymediamanager.ui.actions.CheckForUpdateAction;
import org.tinymediamanager.ui.actions.ClearHttpCacheAction;
import org.tinymediamanager.ui.actions.ClearImageCacheAction;
import org.tinymediamanager.ui.actions.CreateDesktopFileAction;
import org.tinymediamanager.ui.actions.DeleteTrashAction;
import org.tinymediamanager.ui.actions.DocsAction;
import org.tinymediamanager.ui.actions.ExportAnalysisDataAction;
import org.tinymediamanager.ui.actions.ExportLogAction;
import org.tinymediamanager.ui.actions.FaqAction;
import org.tinymediamanager.ui.actions.FeedbackAction;
import org.tinymediamanager.ui.actions.ForumAction;
import org.tinymediamanager.ui.actions.HomepageAction;
import org.tinymediamanager.ui.actions.RebuildImageCacheAction;
import org.tinymediamanager.ui.actions.SettingsAction;
import org.tinymediamanager.ui.actions.ShowChangelogAction;
import org.tinymediamanager.ui.actions.UnlockAction;
import org.tinymediamanager.ui.components.toolbar.ToolbarButton;
import org.tinymediamanager.ui.components.toolbar.ToolbarLabel;
import org.tinymediamanager.ui.components.toolbar.ToolbarMenu;
import org.tinymediamanager.ui.dialogs.FullLogDialog;
import org.tinymediamanager.ui.dialogs.LogDialog;
import org.tinymediamanager.ui.dialogs.MessageHistoryDialog;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;

public class ToolbarPanel
extends JPanel {
    private static final long serialVersionUID = 7969400170662870244L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolbarPanel.class);
    private final ToolbarButton btnSearch;
    private final ToolbarButton btnEdit;
    private final ToolbarButton btnUpdate;
    private final ToolbarButton btnRename;
    private final ToolbarButton btnUnlock;
    private final ToolbarButton btnRenewLicense;
    private final ToolbarMenu menuUpdate;
    private final ToolbarMenu menuSearch;
    private final ToolbarMenu menuEdit;
    private final ToolbarMenu menuRename;
    private final ToolbarLabel lblUnlock;
    private final ToolbarLabel lblRenewLicense;

    public ToolbarPanel() {
        this.setLayout(new BorderLayout());
        JPanel panelCenter = new JPanel();
        this.add((Component)panelCenter, "Center");
        panelCenter.setOpaque(false);
        panelCenter.setLayout((LayoutManager)new MigLayout("insets 0, hidemode 3", "[15lp:n][]20lp[]20lp[]20lp[]20lp[][grow][]15lp[]15lp[]15lp[][][][15lp:n]", "[50lp]1lp[]5lp"));
        panelCenter.add((Component)new JLabel(IconManager.TOOLBAR_LOGO), "cell 1 0, alignx center, aligny bottom");
        ToolbarLabel lblVersion = new ToolbarLabel(ReleaseInfo.getRealVersion());
        TmmFontHelper.changeFont(lblVersion, TmmFontHelper.L2, 1);
        panelCenter.add((Component)lblVersion, "cell 1 1, alignx center");
        this.btnUpdate = new ToolbarButton((Icon)IconManager.TOOLBAR_REFRESH, (Icon)IconManager.TOOLBAR_REFRESH_HOVER);
        panelCenter.add((Component)this.btnUpdate, "cell 2 0,grow, center");
        this.btnSearch = new ToolbarButton((Icon)IconManager.TOOLBAR_SEARCH, (Icon)IconManager.TOOLBAR_SEARCH_HOVER);
        panelCenter.add((Component)this.btnSearch, "cell 3 0,grow, center");
        this.btnEdit = new ToolbarButton((Icon)IconManager.TOOLBAR_EDIT, (Icon)IconManager.TOOLBAR_EDIT_HOVER);
        panelCenter.add((Component)this.btnEdit, "cell 4 0,grow, center");
        this.btnRename = new ToolbarButton((Icon)IconManager.TOOLBAR_RENAME, (Icon)IconManager.TOOLBAR_RENAME_HOVER);
        panelCenter.add((Component)this.btnRename, "cell 5 0,grow, center");
        ToolbarButton btnSettings = new ToolbarButton((Icon)IconManager.TOOLBAR_SETTINGS, (Icon)IconManager.TOOLBAR_SETTINGS_HOVER);
        SettingsAction settingsAction = new SettingsAction();
        ((AbstractButton)btnSettings).setAction(settingsAction);
        panelCenter.add((Component)btnSettings, "cell 8 0,growx, alignx center,aligny bottom");
        JPopupMenu toolsPopupMenu = this.buildToolsMenu();
        ToolbarButton btnTools = new ToolbarButton(IconManager.TOOLBAR_TOOLS, (Icon)IconManager.TOOLBAR_TOOLS_HOVER, toolsPopupMenu);
        panelCenter.add((Component)btnTools, "cell 9 0,alignx center,aligny bottom");
        JPopupMenu infoPopupMenu = this.buildInfoMenu();
        ToolbarButton btnInfo = new ToolbarButton(IconManager.TOOLBAR_ABOUT, (Icon)IconManager.TOOLBAR_ABOUT_HOVER, infoPopupMenu);
        panelCenter.add((Component)btnInfo, "cell 10 0,alignx center,aligny bottom");
        this.btnUnlock = new ToolbarButton((Icon)IconManager.TOOLBAR_UPGRADE, (Icon)IconManager.TOOLBAR_UPGRADE);
        UnlockAction unlockAction = new UnlockAction();
        this.btnUnlock.setAction(unlockAction);
        panelCenter.add((Component)this.btnUnlock, "cell 11 0, alignx center,aligny bottom");
        this.btnRenewLicense = new ToolbarButton((Icon)IconManager.TOOLBAR_RENEW, (Icon)IconManager.TOOLBAR_RENEW);
        this.btnRenewLicense.setAction(unlockAction);
        this.btnRenewLicense.setToolTipText(TmmResourceBundle.getString("Toolbar.renewlicense.desc"));
        panelCenter.add((Component)this.btnRenewLicense, "cell 12 0, alignx center,aligny bottom, gap 10lp");
        this.menuUpdate = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.update"));
        panelCenter.add((Component)this.menuUpdate, "cell 2 1,alignx center, wmin 0");
        this.menuSearch = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.search"));
        panelCenter.add((Component)this.menuSearch, "cell 3 1,alignx center, wmin 0");
        this.menuEdit = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.edit"));
        panelCenter.add((Component)this.menuEdit, "cell 4 1,alignx center, wmin 0");
        this.menuRename = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.rename"));
        panelCenter.add((Component)this.menuRename, "cell 5 1,alignx center, wmin 0");
        ToolbarLabel lblSettings = new ToolbarLabel(TmmResourceBundle.getString("Toolbar.settings"), settingsAction);
        panelCenter.add((Component)lblSettings, "cell 8 1,alignx center, wmin 0");
        ToolbarMenu lblTools = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.tools"), toolsPopupMenu);
        panelCenter.add((Component)lblTools, "cell 9 1,alignx center, wmin 0");
        ToolbarMenu menuHelp = new ToolbarMenu(TmmResourceBundle.getString("Toolbar.help"), infoPopupMenu);
        panelCenter.add((Component)menuHelp, "cell 10 1,alignx center, wmin 0");
        this.lblUnlock = new ToolbarLabel(TmmResourceBundle.getString("Toolbar.upgrade"), unlockAction);
        this.lblUnlock.setToolTipText(TmmResourceBundle.getString("Toolbar.upgrade.desc"));
        panelCenter.add((Component)this.lblUnlock, "cell 11 1,alignx center, gap 10lp, wmin 0");
        this.lblRenewLicense = new ToolbarLabel(TmmResourceBundle.getString("Toolbar.renewlicense"), unlockAction);
        this.lblRenewLicense.setToolTipText(TmmResourceBundle.getString("Toolbar.renewlicense.desc"));
        panelCenter.add((Component)this.lblRenewLicense, "cell 12 1,alignx center, gap 10lp, wmin 0");
        License.getInstance().addEventListener(this::showHideUnlock);
        this.showHideUnlock();
    }

    private void showHideUnlock() {
        if (License.getInstance().isValidLicense()) {
            this.btnUnlock.setVisible(false);
            this.lblUnlock.setVisible(false);
            LocalDate validUntil = License.getInstance().validUntil();
            if (validUntil != null && validUntil.minus(14L, ChronoUnit.DAYS).isBefore(LocalDate.now())) {
                this.btnRenewLicense.setVisible(true);
                this.lblRenewLicense.setVisible(true);
            } else {
                this.btnRenewLicense.setVisible(false);
                this.lblRenewLicense.setVisible(false);
            }
        } else {
            this.btnUnlock.setVisible(true);
            this.lblUnlock.setVisible(true);
            this.btnRenewLicense.setVisible(false);
            this.lblRenewLicense.setVisible(false);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Tmm.toolbar.background"));
    }

    public void setUIModule(ITmmUIModule module) {
        this.btnUpdate.setAction(module.getUpdateAction());
        this.btnUpdate.setIcons(module.getSearchButtonIcon(), module.getSearchButtonHoverIcon());
        this.menuUpdate.setPopupMenu(module.getUpdateMenu());
        this.btnSearch.setAction(module.getSearchAction());
        this.menuSearch.setPopupMenu(module.getSearchMenu());
        this.btnEdit.setAction(module.getEditAction());
        this.menuEdit.setPopupMenu(module.getEditMenu());
        this.btnRename.setAction(module.getRenameAction());
        this.menuRename.setPopupMenu(module.getRenameMenu());
    }

    private JPopupMenu buildToolsMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new ClearImageCacheAction());
        menu.add(new RebuildImageCacheAction());
        menu.add(new ClearHttpCacheAction());
        menu.addSeparator();
        JMenuItem tmmLogs = new JMenuItem(TmmResourceBundle.getString("tmm.errorlogs"));
        menu.add(tmmLogs);
        tmmLogs.addActionListener(arg0 -> {
            LogDialog logDialog = new LogDialog();
            logDialog.setLocationRelativeTo(MainWindow.getInstance());
            ((Dialog)logDialog).setVisible(true);
        });
        JMenuItem tmmMessages = new JMenuItem(TmmResourceBundle.getString("tmm.messages"));
        tmmMessages.setMnemonic(76);
        menu.add(tmmMessages);
        tmmMessages.addActionListener(arg0 -> {
            MessageHistoryDialog messageDialog = MessageHistoryDialog.getInstance();
            ((Dialog)messageDialog).setVisible(true);
        });
        JMenuItem tmmFolder = new JMenuItem(TmmResourceBundle.getString("tmm.gotoinstalldir"));
        menu.add(tmmFolder);
        tmmFolder.addActionListener(arg0 -> {
            Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    TmmUIHelper.openFile(path);
                }
            }
            catch (Exception ex) {
                LOGGER.error("open filemanager", (Throwable)ex);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        JMenuItem tmpFolder = new JMenuItem(TmmResourceBundle.getString("tmm.gototmpdir"));
        menu.add(tmpFolder);
        tmpFolder.addActionListener(arg0 -> {
            Path path = Paths.get(Utils.getTempFolder(), new String[0]);
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    TmmUIHelper.openFile(path);
                }
            }
            catch (Exception ex) {
                LOGGER.error("open filemanager", (Throwable)ex);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        menu.add(new DeleteTrashAction());
        menu.addSeparator();
        final JMenu menuWakeOnLan = new JMenu(TmmResourceBundle.getString("tmm.wakeonlan"));
        menuWakeOnLan.setMnemonic(87);
        menuWakeOnLan.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent arg0) {
            }

            @Override
            public void menuDeselected(MenuEvent arg0) {
            }

            @Override
            public void menuSelected(MenuEvent arg0) {
                menuWakeOnLan.removeAll();
                for (WolDevice device : Settings.getInstance().getWolDevices()) {
                    JMenuItem item = new JMenuItem(device.getName());
                    item.addActionListener(arg01 -> Utils.sendWakeOnLanPacket(device.getMacAddress()));
                    menuWakeOnLan.add(item);
                }
            }
        });
        menu.add(menuWakeOnLan);
        final JMenu kodiRPCMenu = KodiRPCMenu.createKodiMenuTop();
        menu.add(kodiRPCMenu);
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (!Settings.getInstance().getWolDevices().isEmpty()) {
                    menuWakeOnLan.setEnabled(true);
                } else {
                    menuWakeOnLan.setEnabled(false);
                }
                if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getKodiHost())) {
                    kodiRPCMenu.setText(KodiRPC.getInstance().getVersion());
                    kodiRPCMenu.setEnabled(true);
                } else {
                    kodiRPCMenu.setText("Kodi");
                    kodiRPCMenu.setEnabled(false);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        if (!Boolean.parseBoolean(System.getProperty("tmm.noupdate")) || Globals.isDebug()) {
            menu.addSeparator();
        }
        if (!Boolean.parseBoolean(System.getProperty("tmm.noupdate"))) {
            menu.add(new CheckForUpdateAction());
        }
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            JMenuItem trace = new JMenuItem("set Console Logger to TRACE");
            trace.addActionListener(arg0 -> {
                System.setProperty("tmm.consoleloglevel", "TRACE");
                TinyMediaManager.setConsoleLogLevel();
                MessageManager.instance.pushMessage(new Message("Trace levels set!", "Test"));
                LOGGER.trace("if you see that, we're now on TRACE logging level ;)");
            });
            debugMenu.add(trace);
            JMenuItem traceLogs = new JMenuItem("Show all logs from this session");
            debugMenu.add(traceLogs);
            traceLogs.addActionListener(arg0 -> {
                FullLogDialog logDialog = new FullLogDialog();
                logDialog.setLocationRelativeTo(MainWindow.getInstance());
                ((Dialog)logDialog).setVisible(true);
            });
            menu.addSeparator();
            menu.add(debugMenu);
        }
        menu.addSeparator();
        menu.add(new BugReportAction());
        menu.add(new ExportLogAction());
        menu.add(new ExportAnalysisDataAction());
        if (SystemUtils.IS_OS_LINUX) {
            menu.addSeparator();
            menu.add(new CreateDesktopFileAction());
        }
        return menu;
    }

    private JPopupMenu buildInfoMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new FaqAction());
        menu.add(new DocsAction());
        menu.add(new ForumAction());
        menu.add(new ShowChangelogAction());
        menu.addSeparator();
        menu.add(new BugReportAction());
        menu.add(new FeedbackAction());
        menu.addSeparator();
        if (!License.getInstance().isValidLicense()) {
            menu.add(new UnlockAction());
        }
        menu.add(new HomepageAction());
        menu.add(new AboutAction());
        return menu;
    }
}

