/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.tree;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeModel;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeState;

public class TmmTree<E extends TmmTreeNode>
extends JTree {
    private static final long serialVersionUID = 4918691644082882866L;
    protected final TmmTreeDataProvider<E> dataProvider;
    protected Set<ITmmTreeFilter<E>> treeFilters;
    protected PropertyChangeListener filterChangeListener;

    public TmmTree(TmmTreeDataProvider<E> dataProvider) {
        this.dataProvider = dataProvider;
        this.setModel(new TmmTreeModel<E>(this, dataProvider));
        this.treeFilters = new CopyOnWriteArraySet<ITmmTreeFilter<E>>();
        this.filterChangeListener = evt -> this.updateFiltering();
    }

    public TmmTreeDataProvider<E> getDataProvider() {
        TreeModel model = this.getModel();
        return model instanceof TmmTreeModel ? ((TmmTreeModel)model).getDataProvider() : null;
    }

    public List<ITmmTreeFilter<E>> getFilters() {
        return new ArrayList<ITmmTreeFilter<E>>(this.treeFilters);
    }

    public void clearFilter() {
        for (ITmmTreeFilter<E> filter : this.treeFilters) {
            filter.removePropertyChangeListener(this.filterChangeListener);
        }
        this.treeFilters.clear();
        this.updateFiltering();
    }

    public void addFilter(ITmmTreeFilter<E> newFilter) {
        newFilter.addPropertyChangeListener("treeFilterChanged", this.filterChangeListener);
        this.treeFilters.add(newFilter);
        this.updateFiltering();
    }

    public void removeFilter(ITmmTreeFilter<E> filter) {
        filter.removePropertyChangeListener(this.filterChangeListener);
        this.treeFilters.remove(filter);
        this.updateFiltering();
    }

    public void updateFiltering() {
        HashSet<ITmmTreeFilter<ITmmTreeFilter<E>>> activeTreeFilters = new HashSet<ITmmTreeFilter<ITmmTreeFilter<E>>>();
        for (ITmmTreeFilter<E> filter : this.treeFilters) {
            if (!filter.isActive()) continue;
            activeTreeFilters.add(filter);
        }
        this.dataProvider.setTreeFilters(activeTreeFilters);
        TreeModel model = this.getModel();
        if (model instanceof TmmTreeModel) {
            ((TmmTreeModel)this.getModel()).invalidateFilterCache();
            ((TmmTreeModel)this.getModel()).updateSortingAndFiltering();
        }
    }

    public TmmTreeState getTreeState() {
        Object root = this.getModel().getRoot();
        TmmTreeState treeState = new TmmTreeState();
        ArrayList<TmmTreeNode> elements = new ArrayList<TmmTreeNode>();
        elements.add((TmmTreeNode)root);
        while (!elements.isEmpty()) {
            TmmTreeNode element = (TmmTreeNode)elements.get(0);
            TreePath path = new TreePath(element.getPath());
            treeState.addState(element.getId(), this.isExpanded(path), this.isPathSelected(path));
            for (int i = 0; i < element.getChildCount(); ++i) {
                elements.add((TmmTreeNode)element.getChildAt(i));
            }
            elements.remove(element);
        }
        return treeState;
    }

    public void setTreeState(TmmTreeState treeState) {
        Object root = this.getModel().getRoot();
        if (treeState == null) {
            return;
        }
        this.clearSelection();
        ArrayList<TmmTreeNode> elements = new ArrayList<TmmTreeNode>();
        elements.add((TmmTreeNode)root);
        while (!elements.isEmpty()) {
            TmmTreeNode element = (TmmTreeNode)elements.get(0);
            TreePath path = new TreePath(element.getPath());
            if (treeState.isExpanded(element.getId())) {
                this.expandPath(path);
                for (int i = 0; i < element.getChildCount(); ++i) {
                    elements.add((TmmTreeNode)this.getModel().getChild(element, i));
                }
            } else {
                this.collapsePath(path);
            }
            if (treeState.isSelected(element.getId())) {
                this.addSelectionPath(path);
            } else {
                this.removeSelectionPath(path);
            }
            elements.remove(element);
        }
    }
}

