/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class FilterSaveDialog
extends TmmDialog {
    private final JTextField tfPresetName;
    private final JRadioButton rdbtnNewPreset;
    private final JRadioButton rdbtnOverwritePreset;
    private final JComboBox<String> cbPresets;
    private String savedPreset = "";

    public FilterSaveDialog(JDialog owner, Set<AbstractSettings.UIFilters> filter, Map<String, List<AbstractSettings.UIFilters>> existingFilters) {
        super(owner, TmmResourceBundle.getString("filter.savepreset"), "filter.save");
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][100lp:n,grow]", "[][]"));
        this.getContentPane().add((Component)panelContent, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rdbtnNewPreset = new JRadioButton(TmmResourceBundle.getString("filter.savenew"));
        buttonGroup.add(this.rdbtnNewPreset);
        this.rdbtnNewPreset.setSelected(true);
        panelContent.add((Component)this.rdbtnNewPreset, "cell 0 0");
        this.tfPresetName = new JTextField();
        panelContent.add((Component)this.tfPresetName, "cell 1 0,growx");
        this.tfPresetName.setColumns(10);
        this.rdbtnOverwritePreset = new JRadioButton(TmmResourceBundle.getString("filter.overwrite"));
        buttonGroup.add(this.rdbtnOverwritePreset);
        panelContent.add((Component)this.rdbtnOverwritePreset, "cell 0 1");
        this.cbPresets = new JComboBox<String>(existingFilters.keySet().toArray(new String[0]));
        if (!existingFilters.isEmpty()) {
            this.cbPresets.setSelectedIndex(0);
        } else {
            this.rdbtnOverwritePreset.setEnabled(false);
            this.cbPresets.setEnabled(false);
        }
        panelContent.add(this.cbPresets, "cell 1 1,growx");
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.addActionListener(e -> this.setVisible(false));
        this.addButton(btnCancel);
        JButton btnSave = new JButton(TmmResourceBundle.getString("Button.save"));
        btnSave.addActionListener(e -> {
            String name = this.rdbtnOverwritePreset.isSelected() ? (String)this.cbPresets.getSelectedItem() : this.tfPresetName.getText();
            if (StringUtils.isBlank((CharSequence)name)) {
                JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("filter.emptyname"));
                return;
            }
            existingFilters.put(name, new ArrayList(filter));
            this.savedPreset = name;
            this.setVisible(false);
        });
        this.addDefaultButton(btnSave);
        SwingUtilities.invokeLater(this.tfPresetName::requestFocus);
    }

    public String getSavedPreset() {
        return this.savedPreset;
    }
}

