/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.interfaces.IMediaArtworkProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ImageChooserDialog
extends TmmDialog {
    private static final long serialVersionUID = 8193355920006275933L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageChooserDialog.class);
    private static final String DIALOG_ID = "imageChooser";
    private final Map<String, Object> ids;
    private final MediaArtwork.MediaArtworkType type;
    private final MediaType mediaType;
    private final ImageLabel imageLabel;
    private final List<MediaScraper> artworkScrapers;
    private final ButtonGroup buttonGroup = new NoneSelectedButtonGroup();
    private final List<JToggleButton> buttons = new ArrayList<JToggleButton>();
    private final List<JPanel> imagePanels = new ArrayList<JPanel>();
    private final ActionListener filterListener;
    private JProgressBar progressBar;
    private JLabel lblProgressAction;
    private JScrollPane scrollPane;
    private JPanel panelImages;
    private LockableViewPort viewport;
    private JTextField tfImageUrl;
    private String openFolderPath = null;
    private List<String> extraThumbs = null;
    private List<String> extraFanarts = null;
    private DownloadTask task;
    private MediaScraperCheckComboBox cbScraper;
    private TmmCheckComboBox<MediaArtwork.ImageSizeAndUrl> cbSize;
    private TmmCheckComboBox<MediaLanguages> cbLanguage;
    private JLabel labelThumbs;
    private JButton btnMarkExtrathumbs;
    private JButton btnUnMarkExtrathumbs;
    private JLabel labelFanart;
    private JButton btnMarkExtrafanart;
    private JButton btnUnMarkExtrafanart;

    public ImageChooserDialog(JDialog parent, Map<String, Object> ids, MediaArtwork.MediaArtworkType type, List<MediaScraper> artworkScrapers, ImageLabel imageLabel, MediaType mediaType) {
        super(parent, "", DIALOG_ID);
        this.imageLabel = imageLabel;
        this.type = type;
        this.mediaType = mediaType;
        this.ids = ids;
        this.artworkScrapers = artworkScrapers;
        this.filterListener = e -> SwingUtilities.invokeLater(this::filterChanged);
        this.init();
        this.cbScraper.addActionListener(this.filterListener);
        this.cbSize.addActionListener(this.filterListener);
        this.cbLanguage.addActionListener(this.filterListener);
    }

    private void init() {
        switch (this.type) {
            case BACKGROUND: {
                this.setTitle(TmmResourceBundle.getString("image.choose.fanart"));
                break;
            }
            case POSTER: {
                this.setTitle(TmmResourceBundle.getString("image.choose.poster"));
                break;
            }
            case BANNER: {
                this.setTitle(TmmResourceBundle.getString("image.choose.banner"));
                break;
            }
            case SEASON_POSTER: {
                Object season = this.ids.get("tvShowSeason");
                if (season != null) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season"));
                break;
            }
            case SEASON_FANART: {
                Object season = this.ids.get("tvShowSeason");
                if (season != null) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.fanart") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season.fanart"));
                break;
            }
            case SEASON_BANNER: {
                Object season = this.ids.get("tvShowSeason");
                if (season != null) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.banner") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season.banner"));
                break;
            }
            case SEASON_THUMB: {
                Object season = this.ids.get("tvShowSeason");
                if (season != null) {
                    this.setTitle(TmmResourceBundle.getString("image.choose.season.thumb") + " - " + TmmResourceBundle.getString("metatag.season") + " " + season);
                    break;
                }
                this.setTitle(TmmResourceBundle.getString("image.choose.season.thumb"));
                break;
            }
            case CLEARART: {
                this.setTitle(TmmResourceBundle.getString("image.choose.clearart"));
                break;
            }
            case DISC: {
                this.setTitle(TmmResourceBundle.getString("image.choose.disc"));
                break;
            }
            case LOGO: {
                this.setTitle(TmmResourceBundle.getString("image.choose.logo"));
                break;
            }
            case CLEARLOGO: {
                this.setTitle(TmmResourceBundle.getString("image.choose.clearlogo"));
                break;
            }
            case CHARACTERART: {
                this.setTitle(TmmResourceBundle.getString("image.choose.characterart"));
                break;
            }
            case THUMB: {
                this.setTitle(TmmResourceBundle.getString("image.choose.thumb"));
                break;
            }
            case KEYART: {
                this.setTitle(TmmResourceBundle.getString("image.choose.keyart"));
            }
        }
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("hidemode 3, insets n n 0 n", "[850lp,grow][]", "[][10lp!][500lp,grow][shrink 0][][]"));
        JPanel panelFilter = new JPanel();
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelFilter, new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), true);
        contentPanel.add((Component)collapsiblePanel, "cell 0 0 2 1,grow, wmin 0");
        panelFilter.setLayout((LayoutManager)new MigLayout("insets 0", "[200lp:n][20lp!][200lp:n][20lp!][200lp:n]", "[][]"));
        TmmLabel lblScraperT = new TmmLabel(TmmResourceBundle.getString("scraper.artwork"));
        panelFilter.add((Component)lblScraperT, "cell 0 0");
        TmmLabel lblDimensionT = new TmmLabel(TmmResourceBundle.getString("metatag.size"));
        panelFilter.add((Component)lblDimensionT, "cell 2 0");
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelFilter.add((Component)lblLanguageT, "cell 4 0");
        this.cbScraper = new MediaScraperCheckComboBox(this.artworkScrapers);
        panelFilter.add((Component)this.cbScraper, "cell 0 1,growx,wmin 0");
        this.cbSize = new TmmCheckComboBox();
        panelFilter.add(this.cbSize, "cell 2 1,wmin 0");
        this.cbLanguage = new TmmCheckComboBox();
        panelFilter.add(this.cbLanguage, "cell 4 1,wmin 0");
        this.scrollPane = new NoBorderScrollPane();
        this.viewport = new LockableViewPort();
        this.scrollPane.setViewport(this.viewport);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        contentPanel.add((Component)this.scrollPane, "cell 0 2 2 1,grow");
        this.panelImages = new JPanel();
        this.viewport.setView(this.panelImages);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.panelImages.setLayout(new WrapLayout(0));
        JSeparator separator = new JSeparator();
        contentPanel.add((Component)separator, "cell 0 3 2 1,growx");
        this.tfImageUrl = new EnhancedTextField(TmmResourceBundle.getString("image.inserturl"));
        contentPanel.add((Component)this.tfImageUrl, "cell 0 4,growx");
        this.tfImageUrl.setColumns(10);
        JButton btnAddImage = new JButton(TmmResourceBundle.getString("image.downloadimage"));
        btnAddImage.addActionListener(e -> {
            if (StringUtils.isNotBlank((CharSequence)this.tfImageUrl.getText())) {
                this.downloadAndPreviewImage(this.tfImageUrl.getText());
            }
        });
        contentPanel.add((Component)btnAddImage, "cell 1 4");
        if (this.type == MediaArtwork.MediaArtworkType.BACKGROUND || this.type == MediaArtwork.MediaArtworkType.THUMB) {
            this.labelThumbs = new JLabel(TmmResourceBundle.getString("mediafiletype.extrathumb") + ":");
            contentPanel.add((Component)this.labelThumbs, "flowx,cell 0 5");
            this.labelThumbs.setVisible(false);
            this.btnMarkExtrathumbs = new SquareIconButton(IconManager.CHECK_ALL);
            contentPanel.add((Component)this.btnMarkExtrathumbs, "cell 0 5");
            this.btnMarkExtrathumbs.setVisible(false);
            this.btnMarkExtrathumbs.setToolTipText(TmmResourceBundle.getString("image.extrathumbs.markall"));
            this.btnMarkExtrathumbs.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb");
                    chkbx.setSelected(true);
                }
            });
            this.btnUnMarkExtrathumbs = new SquareIconButton(IconManager.CLEAR_ALL);
            contentPanel.add((Component)this.btnUnMarkExtrathumbs, "cell 0 5, gapx n 50lp");
            this.btnUnMarkExtrathumbs.setVisible(false);
            this.btnUnMarkExtrathumbs.setToolTipText(TmmResourceBundle.getString("image.extrathumbs.unmarkall"));
            this.btnUnMarkExtrathumbs.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb");
                    chkbx.setSelected(false);
                }
            });
        }
        if (this.type == MediaArtwork.MediaArtworkType.BACKGROUND) {
            this.labelFanart = new JLabel(TmmResourceBundle.getString("mediafiletype.extrafanart") + ":");
            contentPanel.add((Component)this.labelFanart, "flowx,cell 0 5");
            this.labelFanart.setVisible(false);
            this.btnMarkExtrafanart = new SquareIconButton(IconManager.CHECK_ALL);
            contentPanel.add((Component)this.btnMarkExtrafanart, "cell 0 5");
            this.btnMarkExtrafanart.setVisible(false);
            this.btnMarkExtrafanart.setToolTipText(TmmResourceBundle.getString("image.extrafanart.markall"));
            this.btnMarkExtrafanart.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart");
                    chkbx.setSelected(true);
                }
            });
            this.btnUnMarkExtrafanart = new SquareIconButton(IconManager.CLEAR_ALL);
            contentPanel.add((Component)this.btnUnMarkExtrafanart, "cell 0 5");
            this.btnUnMarkExtrafanart.setVisible(false);
            this.btnUnMarkExtrafanart.setToolTipText(TmmResourceBundle.getString("image.extrafanart.unmarkall"));
            this.btnUnMarkExtrafanart.addActionListener(arg0 -> {
                for (JToggleButton button : this.buttons) {
                    if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox)) continue;
                    JCheckBox chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart");
                    chkbx.setSelected(false);
                }
            });
        }
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        JButton cancelButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        CancelAction actionCancel = new CancelAction();
        cancelButton.setAction(actionCancel);
        cancelButton.setActionCommand("Cancel");
        this.addButton(cancelButton);
        JButton btnAddFile = new JButton(TmmResourceBundle.getString("Button.addfile"));
        LocalFileChooseAction actionLocalFile = new LocalFileChooseAction();
        btnAddFile.setAction(actionLocalFile);
        this.addButton(btnAddFile);
        JButton okButton = new JButton(TmmResourceBundle.getString("Button.ok"));
        OkAction actionOK = new OkAction();
        okButton.setAction(actionOK);
        okButton.setActionCommand("OK");
        this.addDefaultButton(okButton);
        this.task = new DownloadTask(this.ids, this.artworkScrapers);
        this.task.execute();
    }

    public void bindExtraThumbs(List<String> extraThumbs) {
        if (this.type != MediaArtwork.MediaArtworkType.BACKGROUND && this.type != MediaArtwork.MediaArtworkType.THUMB) {
            return;
        }
        this.extraThumbs = extraThumbs;
        if (extraThumbs != null) {
            this.labelThumbs.setVisible(true);
            this.btnMarkExtrathumbs.setVisible(true);
            this.btnUnMarkExtrathumbs.setVisible(true);
        } else {
            this.labelThumbs.setVisible(false);
            this.btnMarkExtrathumbs.setVisible(false);
            this.btnUnMarkExtrathumbs.setVisible(false);
        }
    }

    public void bindExtraFanarts(List<String> extraFanarts) {
        if (this.type != MediaArtwork.MediaArtworkType.BACKGROUND) {
            return;
        }
        this.extraFanarts = extraFanarts;
        if (extraFanarts != null) {
            this.labelFanart.setVisible(true);
            this.btnMarkExtrafanart.setVisible(true);
            this.btnUnMarkExtrafanart.setVisible(true);
        } else {
            this.labelFanart.setVisible(false);
            this.btnMarkExtrafanart.setVisible(false);
            this.btnUnMarkExtrafanart.setVisible(false);
        }
    }

    public void setOpenFolderPath(String openFolderPath) {
        this.openFolderPath = openFolderPath;
    }

    private void startProgressBar(String description) {
        this.lblProgressAction.setText(description);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
    }

    private void stopProgressBar() {
        this.lblProgressAction.setText("");
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(false);
    }

    private void addImage(BufferedImage originalImage, MediaArtwork artwork) {
        JCheckBox chkbx;
        JLabel label;
        Point size = null;
        GridBagLayout gbl = new GridBagLayout();
        switch (this.type) {
            case BACKGROUND: 
            case CLEARART: 
            case DISC: 
            case CHARACTERART: 
            case THUMB: {
                size = ImageUtils.calculateSize(300, 150, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            case BANNER: 
            case LOGO: 
            case CLEARLOGO: {
                size = ImageUtils.calculateSize(300, 100, originalImage.getWidth(), originalImage.getHeight(), true);
                break;
            }
            default: {
                size = ImageUtils.calculateSize(150, 250, originalImage.getWidth(), originalImage.getHeight(), true);
            }
        }
        gbl.columnWeights = new double[]{Double.MIN_VALUE};
        gbl.rowWeights = new double[]{Double.MIN_VALUE};
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(gbl);
        int row = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        final JToggleButton button = new JToggleButton();
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && e.getButton() == 1) {
                    button.setSelected(true);
                    new OkAction().actionPerformed(new ActionEvent(e.getSource(), e.getID(), "OK"));
                }
            }
        });
        button.setBackground(Color.white);
        button.setMargin(new Insets(10, 10, 10, 10));
        if (artwork.isAnimated()) {
            button.setText("<html><img width=\"" + size.x + "\" height=\"" + size.y + "\" src='" + artwork.getPreviewUrl() + "'/></html>");
            button.setBorder(BorderFactory.createLineBorder(Color.GREEN, 3));
        } else {
            ImageIcon imageIcon = new ImageIcon(Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.BALANCED, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS}));
            button.setIcon(imageIcon);
        }
        button.putClientProperty("MediaArtwork", artwork);
        this.buttonGroup.add(button);
        this.buttons.add(button);
        imagePanel.add((Component)button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = ++row;
        gbc.gridwidth = 3;
        gbc.anchor = 25;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        JComboBox<Object> cb = null;
        cb = !artwork.getImageSizes().isEmpty() ? new JComboBox<Object>(artwork.getImageSizes().toArray()) : new JComboBox<String>(new String[]{originalImage.getWidth() + "x" + originalImage.getHeight()});
        button.putClientProperty("MediaArtworkSize", cb);
        imagePanel.add(cb, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = ++row;
        gbc.anchor = 21;
        gbc.fill = 2;
        gbc.gridwidth = this.extraThumbs != null || this.extraFanarts != null ? 1 : 3;
        gbc.insets = new Insets(0, 5, 0, 5);
        LinkLabel lblShowImage = new LinkLabel(TmmResourceBundle.getString("image.showoriginal"));
        lblShowImage.addActionListener(e -> {
            ImagePreviewDialog dialog = new ImagePreviewDialog(artwork.getOriginalUrl());
            dialog.setVisible(true);
        });
        imagePanel.add((Component)lblShowImage, gbc);
        if (this.extraThumbs != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = row;
            gbc.anchor = 22;
            gbc.insets = new Insets(0, 5, 0, 5);
            label = new JLabel("Extrathumb");
            imagePanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = row++;
            gbc.anchor = 21;
            gbc.insets = new Insets(0, 5, 0, 5);
            chkbx = new JCheckBox();
            button.putClientProperty("MediaArtworkExtrathumb", chkbx);
            imagePanel.add((Component)chkbx, gbc);
        }
        if (this.extraFanarts != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = row;
            gbc.anchor = 22;
            gbc.insets = new Insets(0, 5, 0, 5);
            label = new JLabel("Extrafanart");
            imagePanel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = row;
            gbc.anchor = 21;
            gbc.insets = new Insets(0, 5, 0, 5);
            chkbx = new JCheckBox();
            button.putClientProperty("MediaArtworkExtrafanart", chkbx);
            imagePanel.add((Component)chkbx, gbc);
        }
        imagePanel.putClientProperty("MediaArtwork", artwork);
        this.imagePanels.add(imagePanel);
        this.imagePanels.sort((o1, o2) -> {
            Object obj1 = o1.getClientProperty("MediaArtwork");
            Object obj2 = o2.getClientProperty("MediaArtwork");
            if (!(obj1 instanceof MediaArtwork) || !(obj2 instanceof MediaArtwork)) {
                return 0;
            }
            MediaArtwork artwork1 = (MediaArtwork)obj1;
            MediaArtwork artwork2 = (MediaArtwork)obj2;
            if (artwork1.getBiggestArtwork() == null || artwork2.getBiggestArtwork() == null) {
                return 0;
            }
            return artwork2.getBiggestArtwork().compareTo(artwork1.getBiggestArtwork());
        });
        this.updateSizeCombobox(artwork.getImageSizes());
        this.updateLanguageCombobox(artwork.getLanguage());
        this.filterChanged();
    }

    private void updateSizeCombobox(List<MediaArtwork.ImageSizeAndUrl> newSizes) {
        this.cbSize.removeActionListener(this.filterListener);
        List<MediaArtwork.ImageSizeAndUrl> selectedItems = this.cbSize.getSelectedItems();
        List<MediaArtwork.ImageSizeAndUrl> allItems = this.cbSize.getItems();
        HashSet<String> sizes = new HashSet<String>();
        for (MediaArtwork.ImageSizeAndUrl sizeAndUrl : allItems) {
            sizes.add(sizeAndUrl.toString());
        }
        for (MediaArtwork.ImageSizeAndUrl sizeAndUrl : ListUtils.nullSafe(newSizes)) {
            if (sizes.contains(sizeAndUrl.toString())) continue;
            allItems.add(sizeAndUrl);
            sizes.add(sizeAndUrl.toString());
        }
        allItems.sort(MediaArtwork.ImageSizeAndUrl::compareTo);
        allItems.sort(Collections.reverseOrder());
        this.cbSize.setItems(allItems);
        this.cbSize.setSelectedItems(selectedItems);
        this.cbSize.addActionListener(this.filterListener);
    }

    private void updateLanguageCombobox(String language) {
        this.cbLanguage.removeActionListener(this.filterListener);
        List<MediaLanguages> selectedItems = this.cbLanguage.getSelectedItems();
        List<MediaLanguages> allItems = this.cbLanguage.getItems();
        if ("-".equals(language)) {
            if (!allItems.contains((Object)MediaLanguages.none)) {
                allItems.add(MediaLanguages.none);
            }
        } else {
            MediaLanguages mediaLanguages = MediaLanguages.get(language);
            if (!allItems.contains((Object)mediaLanguages)) {
                allItems.add(mediaLanguages);
            }
        }
        ArrayList<MediaLanguages> newValues = new ArrayList<MediaLanguages>();
        for (MediaLanguages mediaLanguages : MediaLanguages.valuesSorted()) {
            if (!allItems.contains((Object)mediaLanguages)) continue;
            newValues.add(mediaLanguages);
        }
        this.cbLanguage.setItems(newValues);
        this.cbLanguage.setSelectedItems(selectedItems);
        this.cbLanguage.addActionListener(this.filterListener);
    }

    private void filterChanged() {
        this.panelImages.removeAll();
        for (JPanel panel : this.imagePanels) {
            Object obj = panel.getClientProperty("MediaArtwork");
            if (!(obj instanceof MediaArtwork)) continue;
            MediaArtwork artwork = (MediaArtwork)obj;
            if (this.cbScraper.getSelectedItems().isEmpty() && this.cbSize.getSelectedItems().isEmpty() && this.cbLanguage.getSelectedItems().isEmpty()) {
                this.panelImages.add(panel);
                continue;
            }
            boolean scraperMatch = true;
            boolean sizeMatch = true;
            boolean languageMatch = true;
            if (!this.cbScraper.getSelectedItems().isEmpty()) {
                scraperMatch = false;
                for (MediaScraper scraper : this.cbScraper.getSelectedItems()) {
                    if (!scraper.getId().equals(artwork.getProviderId())) continue;
                    scraperMatch = true;
                    break;
                }
            }
            if (!this.cbSize.getSelectedItems().isEmpty()) {
                sizeMatch = false;
                ArrayList<String> sizes = new ArrayList<String>();
                for (MediaArtwork.ImageSizeAndUrl sizeAndUrl : this.cbSize.getSelectedItems()) {
                    sizes.add(sizeAndUrl.toString());
                }
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : artwork.getImageSizes()) {
                    if (!sizes.contains(imageSizeAndUrl.toString())) continue;
                    sizeMatch = true;
                    break;
                }
            }
            if (!this.cbLanguage.getSelectedItems().isEmpty()) {
                languageMatch = false;
                ArrayList<String> languages = new ArrayList<String>();
                for (MediaLanguages mediaLanguages : this.cbLanguage.getSelectedItems()) {
                    if (mediaLanguages == MediaLanguages.none) {
                        languages.add("");
                        continue;
                    }
                    languages.add(mediaLanguages.getLanguage().toLowerCase(Locale.ROOT));
                }
                if (languages.contains(artwork.getLanguage())) {
                    languageMatch = true;
                }
            }
            if (!scraperMatch || !sizeMatch || !languageMatch) continue;
            this.panelImages.add(panel);
        }
        this.viewport.setLocked(true);
        this.panelImages.revalidate();
        this.scrollPane.repaint();
        SwingUtilities.invokeLater(() -> this.viewport.setLocked(false));
    }

    private void downloadAndPreviewImage(String url) {
        Runnable task = () -> {
            try {
                MediaArtwork art;
                switch (this.type) {
                    case BANNER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BANNER);
                        break;
                    }
                    case CLEARART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARART);
                        break;
                    }
                    case DISC: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.DISC);
                        break;
                    }
                    case BACKGROUND: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.BACKGROUND);
                        break;
                    }
                    case LOGO: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.LOGO);
                        break;
                    }
                    case CLEARLOGO: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CLEARLOGO);
                        break;
                    }
                    case CHARACTERART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.CHARACTERART);
                        break;
                    }
                    case POSTER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.POSTER);
                        break;
                    }
                    case SEASON_POSTER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_POSTER);
                        break;
                    }
                    case SEASON_FANART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_FANART);
                        break;
                    }
                    case SEASON_BANNER: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_BANNER);
                        break;
                    }
                    case SEASON_THUMB: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.SEASON_THUMB);
                        break;
                    }
                    case THUMB: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.THUMB);
                        break;
                    }
                    case KEYART: {
                        art = new MediaArtwork("", MediaArtwork.MediaArtworkType.KEYART);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                art.setDefaultUrl(url);
                art.setPreviewUrl(url);
                art.setOriginalUrl(url);
                Url url1 = new Url(art.getPreviewUrl());
                BufferedImage bufferedImage = ImageUtils.createImage(url1.getBytesWithRetry(5));
                if (bufferedImage != null) {
                    SwingUtilities.invokeLater(() -> {
                        this.addImage(bufferedImage, art);
                        bufferedImage.flush();
                    });
                    this.tfImageUrl.setText("");
                } else {
                    JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("message.errorloadimage"));
                }
            }
            catch (Exception e) {
                LOGGER.error("could not download manually entered image url: {} - {}", (Object)this.tfImageUrl.getText(), (Object)e.getMessage());
            }
        };
        task.run();
    }

    public static String chooseImage(JDialog parent, Map<String, Object> ids, MediaArtwork.MediaArtworkType type, List<MediaScraper> artworkScrapers, MediaType mediaType, String defaultPath) {
        return ImageChooserDialog.chooseImage(parent, ids, type, artworkScrapers, null, null, mediaType, defaultPath);
    }

    public static String chooseImage(JDialog parent, Map<String, Object> ids, MediaArtwork.MediaArtworkType type, List<MediaScraper> artworkScrapers, List<String> extraThumbs, List<String> extraFanarts, MediaType mediaType, String defaultPath) {
        if (ids.isEmpty()) {
            return "";
        }
        ImageLabel lblImage = new ImageLabel();
        ImageChooserDialog dialog = new ImageChooserDialog(parent, ids, type, artworkScrapers, lblImage, mediaType);
        dialog.bindExtraThumbs(extraThumbs);
        dialog.bindExtraFanarts(extraFanarts);
        dialog.setOpenFolderPath(defaultPath);
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        return lblImage.getImageUrl();
    }

    private static class NoneSelectedButtonGroup
    extends ButtonGroup {
        private NoneSelectedButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, selected);
            } else {
                this.clearSelection();
            }
        }
    }

    private static final class LockableViewPort
    extends JViewport {
        private boolean locked = false;

        private LockableViewPort() {
        }

        @Override
        public void setViewPosition(Point p) {
            if (this.locked) {
                return;
            }
            super.setViewPosition(p);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }
    }

    private class LocalFileChooseAction
    extends AbstractAction {
        private static final long serialVersionUID = -1178325861474276709L;

        public LocalFileChooseAction() {
            this.putValue("Name", TmmResourceBundle.getString("image.choose.file"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("image.choose.file"));
            this.putValue("SmallIcon", IconManager.FILE_OPEN_INV);
            this.putValue("SwingLargeIconKey", IconManager.FILE_OPEN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String path = StringUtils.isNotBlank((CharSequence)ImageChooserDialog.this.openFolderPath) ? ImageChooserDialog.this.openFolderPath : TmmProperties.getInstance().getProperty("imageChooser.path");
            Path file = TmmUIHelper.selectFile(TmmResourceBundle.getString("image.choose"), path, new FileNameExtensionFilter("Image files", ".jpg", ".jpeg", ".png", ".bmp", ".gif", ".tbn", ".webp"));
            if (file != null && Utils.isRegularFile(file)) {
                String fileName = file.toAbsolutePath().toString();
                ImageChooserDialog.this.imageLabel.clearImage();
                ImageChooserDialog.this.imageLabel.setImageUrl("file:/" + fileName);
                ImageChooserDialog.this.task.cancel(true);
                TmmProperties.getInstance().putProperty("imageChooser.path", file.getParent().toString());
                ImageChooserDialog.this.setVisible(false);
            }
        }
    }

    private static class DownloadChunk {
        private BufferedImage image;
        private MediaArtwork artwork;

        private DownloadChunk() {
        }
    }

    private class DownloadTask
    extends SwingWorker<Void, DownloadChunk> {
        private final Map<String, Object> ids;
        private final List<MediaScraper> artworkScrapers;
        private boolean imagesFound = false;

        public DownloadTask(Map<String, Object> ids, List<MediaScraper> artworkScrapers) {
            this.ids = ids;
            this.artworkScrapers = artworkScrapers;
        }

        @Override
        public Void doInBackground() {
            if (this.ids.isEmpty()) {
                JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("image.download.noid"));
                return null;
            }
            SwingUtilities.invokeLater(() -> ImageChooserDialog.this.startProgressBar(TmmResourceBundle.getString("image.download.progress")));
            if (this.artworkScrapers == null || this.artworkScrapers.isEmpty()) {
                return null;
            }
            ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            pool.allowCoreThreadTimeOut(true);
            ExecutorCompletionService<DownloadChunk> service = new ExecutorCompletionService<DownloadChunk>(pool);
            for (MediaScraper scraper : this.artworkScrapers) {
                try {
                    IMediaArtworkProvider artworkProvider = (IMediaArtworkProvider)scraper.getMediaProvider();
                    ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(ImageChooserDialog.this.mediaType);
                    if (ImageChooserDialog.this.mediaType == MediaType.MOVIE || ImageChooserDialog.this.mediaType == MediaType.MOVIE_SET) {
                        options.setLanguage(MovieModuleManager.getInstance().getSettings().getImageScraperLanguage());
                        options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
                        options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
                    } else {
                        if (ImageChooserDialog.this.mediaType != MediaType.TV_SHOW && ImageChooserDialog.this.mediaType != MediaType.TV_EPISODE) continue;
                        options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
                        options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
                        options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
                    }
                    switch (ImageChooserDialog.this.type) {
                        case POSTER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.POSTER);
                            break;
                        }
                        case BACKGROUND: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.BACKGROUND);
                            break;
                        }
                        case BANNER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.BANNER);
                            break;
                        }
                        case SEASON_POSTER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_POSTER);
                            break;
                        }
                        case SEASON_FANART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_FANART);
                            break;
                        }
                        case SEASON_BANNER: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_BANNER);
                            break;
                        }
                        case SEASON_THUMB: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.SEASON_THUMB);
                            break;
                        }
                        case CLEARART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARART);
                            break;
                        }
                        case DISC: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.DISC);
                            break;
                        }
                        case LOGO: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.LOGO);
                            break;
                        }
                        case CLEARLOGO: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CLEARLOGO);
                            break;
                        }
                        case CHARACTERART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.CHARACTERART);
                            break;
                        }
                        case KEYART: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.KEYART);
                            break;
                        }
                        case THUMB: {
                            options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
                        }
                    }
                    options.setIds(this.ids);
                    List<MediaArtwork> artwork = artworkProvider.getArtwork(options);
                    if (artwork == null || artwork.isEmpty()) continue;
                    int season = MediaIdUtil.getIdAsIntOrDefault(this.ids, "tvShowSeason", -1);
                    for (MediaArtwork art : artwork) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        if (art.getPreviewUrl().isEmpty() || season > -1 && season != art.getSeason()) continue;
                        Callable<DownloadChunk> callable = () -> {
                            Url url = new Url(art.getPreviewUrl());
                            DownloadChunk chunk = new DownloadChunk();
                            chunk.artwork = art;
                            try {
                                chunk.image = ImageUtils.createImage(url.getBytesWithRetry(5));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return chunk;
                        };
                        service.submit(callable);
                    }
                }
                catch (MissingIdException e) {
                    LOGGER.debug("could not fetch artwork: {}", (Object[])e.getIds());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                        pool.getQueue().clear();
                        pool.shutdownNow();
                        return null;
                    }
                    LOGGER.error("could not process artwork downloading - {}", (Object)e.getMessage());
                }
            }
            pool.shutdown();
            while (true) {
                try {
                    while (true) {
                        Future future;
                        if ((future = service.poll(1L, TimeUnit.SECONDS)) != null) {
                            DownloadChunk dc = (DownloadChunk)future.get();
                            if (dc.image == null) continue;
                            this.publish(dc);
                            this.imagesFound = true;
                            continue;
                        }
                        if (pool.isTerminated()) break;
                    }
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (ExecutionException e) {
                    LOGGER.error("ThreadPool imageChooser: Error getting result! - {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
            return null;
        }

        @Override
        protected void process(List<DownloadChunk> chunks) {
            for (DownloadChunk chunk : chunks) {
                ImageChooserDialog.this.addImage(chunk.image, chunk.artwork);
            }
        }

        @Override
        public void done() {
            if (!this.imagesFound) {
                JLabel lblNothingFound = new JLabel(TmmResourceBundle.getString("image.download.nothingfound"));
                TmmFontHelper.changeFont((JComponent)lblNothingFound, 1.33);
                ImageChooserDialog.this.panelImages.add(lblNothingFound);
                ImageChooserDialog.this.panelImages.validate();
                ImageChooserDialog.this.panelImages.getParent().validate();
            }
            SwingUtilities.invokeLater(() -> ImageChooserDialog.this.stopProgressBar());
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 403327079655572423L;

        public CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageChooserDialog.this.task.cancel(true);
            ImageChooserDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -1255049344169945137L;

        public OkAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("image.seteselected"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaArtwork artwork = null;
            MediaArtwork.ImageSizeAndUrl resolution = null;
            List<String> selectedExtraThumbs = this.getSelectedExtraThumbs();
            List<String> selectedExtraFanarts = this.getSelectedExtrafanarts();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JComboBox cb;
                Object clientProperty;
                if (!button.isSelected() || !((clientProperty = button.getClientProperty("MediaArtwork")) instanceof MediaArtwork)) continue;
                artwork = (MediaArtwork)clientProperty;
                clientProperty = button.getClientProperty("MediaArtworkSize");
                if (!(clientProperty instanceof JComboBox) || !((cb = (JComboBox)clientProperty).getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl)) break;
                resolution = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                break;
            }
            if (artwork == null && selectedExtraFanarts.isEmpty() && selectedExtraThumbs.isEmpty()) {
                JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("image.noneselected"));
                return;
            }
            if (artwork != null) {
                ImageChooserDialog.this.imageLabel.clearImage();
                if (resolution != null) {
                    ImageChooserDialog.this.imageLabel.setImageUrl(resolution.getUrl());
                } else {
                    ImageChooserDialog.this.imageLabel.setImageUrl(artwork.getDefaultUrl());
                }
            }
            if (ImageChooserDialog.this.extraThumbs != null) {
                ImageChooserDialog.this.extraThumbs.clear();
                ImageChooserDialog.this.extraThumbs.addAll(selectedExtraThumbs);
            }
            if (ImageChooserDialog.this.extraFanarts != null) {
                ImageChooserDialog.this.extraFanarts.clear();
                ImageChooserDialog.this.extraFanarts.addAll(selectedExtraFanarts);
            }
            ImageChooserDialog.this.task.cancel(true);
            ImageChooserDialog.this.setVisible(false);
        }

        private List<String> getSelectedExtraThumbs() {
            ArrayList<String> selectedExtraThumbs = new ArrayList<String>();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrathumb") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrathumb")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                if (cb.getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                    if (size != null) {
                        selectedExtraThumbs.add(size.getUrl());
                        continue;
                    }
                    selectedExtraThumbs.add(artwork.getDefaultUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                selectedExtraThumbs.add(artwork.getDefaultUrl());
            }
            return selectedExtraThumbs;
        }

        private List<String> getSelectedExtrafanarts() {
            ArrayList<String> selectedExtrafanarts = new ArrayList<String>();
            for (JToggleButton button : ImageChooserDialog.this.buttons) {
                JCheckBox chkbx;
                if (!(button.getClientProperty("MediaArtworkExtrafanart") instanceof JCheckBox) || !(button.getClientProperty("MediaArtwork") instanceof MediaArtwork) || !(button.getClientProperty("MediaArtworkSize") instanceof JComboBox) || !(chkbx = (JCheckBox)button.getClientProperty("MediaArtworkExtrafanart")).isSelected()) continue;
                MediaArtwork artwork = (MediaArtwork)button.getClientProperty("MediaArtwork");
                JComboBox cb = (JComboBox)button.getClientProperty("MediaArtworkSize");
                if (cb.getSelectedItem() instanceof MediaArtwork.ImageSizeAndUrl) {
                    MediaArtwork.ImageSizeAndUrl size = (MediaArtwork.ImageSizeAndUrl)cb.getSelectedItem();
                    if (size != null) {
                        selectedExtrafanarts.add(size.getUrl());
                        continue;
                    }
                    selectedExtrafanarts.add(artwork.getDefaultUrl());
                    continue;
                }
                if (!(cb.getSelectedItem() instanceof String)) continue;
                selectedExtrafanarts.add(artwork.getDefaultUrl());
            }
            return selectedExtrafanarts;
        }
    }
}

