/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MessagePanel;

public class MessageHistoryDialog
extends TmmDialog
implements ListEventListener<Message> {
    private static final long serialVersionUID = -5054005564554148578L;
    private static MessageHistoryDialog instance;
    private final Map<Message, JPanel> messageMap;
    private final JPanel messagesPanel;

    private MessageHistoryDialog() {
        super(MainWindow.getInstance(), TmmResourceBundle.getString("summarywindow.title"), "messageSummary");
        this.setModal(false);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.messageMap = new HashMap<Message, JPanel>();
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        this.messagesPanel = new JPanel();
        this.messagesPanel.setOpaque(false);
        this.messagesPanel.setLayout(new BoxLayout(this.messagesPanel, 3));
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setViewportView(this.messagesPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[300lp:600lp,grow]", "[200lp:400lp,grow]"));
        panelContent.add((Component)scrollPane, "cell 0 0,grow, wmin 0");
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        TmmUIMessageCollector.instance.getMessages().addListEventListener((ListEventListener)this);
        this.updatePanel();
    }

    public static MessageHistoryDialog getInstance() {
        if (instance == null) {
            instance = new MessageHistoryDialog();
        }
        return instance;
    }

    @Override
    public void setVisible(boolean visible) {
        TmmUIMessageCollector.instance.resetNewMessageCount();
        super.setVisible(visible);
    }

    public void listChanged(ListEvent<Message> listChanges) {
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePanel() {
        EventList<Message> list = TmmUIMessageCollector.instance.getMessages();
        list.getReadWriteLock().readLock().lock();
        try {
            for (Message message : list) {
                if (this.messageMap.containsKey(message)) continue;
                MessagePanel panel = new MessagePanel(message);
                this.messageMap.put(message, panel);
                this.messagesPanel.add(panel);
            }
            this.messagesPanel.revalidate();
            this.messagesPanel.repaint();
        }
        finally {
            list.getReadWriteLock().readLock().unlock();
        }
    }
}

