/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class RegexpInputDialog
extends TmmDialog {
    private static final long serialVersionUID = 123315882962746712L;
    private static final String DIALOG_ID = "regexpInput";
    private String regularExpression;
    private JTextField tfExpression;
    private JButton btnOk;
    private JLabel lblInvalidExpression;
    private JLabel lblDescription;

    public RegexpInputDialog(Window owner) {
        super(owner, TmmResourceBundle.getString("tmm.regexp"), DIALOG_ID);
        this.initComponents();
        this.lblInvalidExpression.setVisible(false);
        this.btnOk.setEnabled(false);
        this.tfExpression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                this.checkExpression();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.checkExpression();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                this.checkExpression();
            }

            private void checkExpression() {
                String text = RegexpInputDialog.this.tfExpression.getText();
                if (StringUtils.isBlank((CharSequence)text)) {
                    RegexpInputDialog.this.lblInvalidExpression.setVisible(false);
                    RegexpInputDialog.this.btnOk.setEnabled(false);
                } else {
                    try {
                        Pattern.compile(text);
                        RegexpInputDialog.this.lblInvalidExpression.setVisible(false);
                        RegexpInputDialog.this.btnOk.setEnabled(true);
                    }
                    catch (Exception e) {
                        RegexpInputDialog.this.lblInvalidExpression.setVisible(true);
                        RegexpInputDialog.this.btnOk.setEnabled(false);
                    }
                }
            }
        });
    }

    private void initComponents() {
        JPanel panelContent = new JPanel();
        this.getContentPane().add(panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[300lp,grow]", "[][][]"));
        this.lblDescription = new JLabel(TmmResourceBundle.getString("tmm.regexp"));
        panelContent.add((Component)this.lblDescription, "cell 0 0");
        this.tfExpression = new JTextField();
        panelContent.add((Component)this.tfExpression, "cell 0 1,growx");
        this.tfExpression.setColumns(10);
        this.lblInvalidExpression = new JLabel(TmmResourceBundle.getString("tmm.regexp.invalid"));
        panelContent.add((Component)this.lblInvalidExpression, "cell 0 2");
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.addActionListener(e -> {
            this.regularExpression = null;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        this.btnOk = new JButton(TmmResourceBundle.getString("Button.ok"));
        this.btnOk.addActionListener(e -> {
            this.regularExpression = this.tfExpression.getText();
            this.setVisible(false);
        });
        this.addDefaultButton(this.btnOk);
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }
}

