/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.tree.TmmTree;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeTextFilter;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.settings.TmmSettingsDataProvider;
import org.tinymediamanager.ui.settings.TmmSettingsNode;

public class SettingsDialog
extends TmmDialog {
    private static final long serialVersionUID = 2435834806519338339L;
    private static JDialog instance;
    private final TmmSettingsDataProvider dataProvider = new TmmSettingsDataProvider();
    private TmmTree<TmmTreeNode> tree;
    private JPanel rightPanel;
    private TmmSettingsTreeFilter tfFilter;

    public static JDialog getInstance() {
        if (instance == null) {
            instance = new SettingsDialog();
        }
        return instance;
    }

    private SettingsDialog() {
        super(TmmResourceBundle.getString("tmm.settings"), "settings");
        this.initComponents();
        this.initPanels();
        this.tree.addFilter(this.tfFilter);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node != null && node.getUserObject() instanceof TmmSettingsNode) {
                TmmSettingsNode settingsNode = (TmmSettingsNode)node.getUserObject();
                CardLayout cl = (CardLayout)this.rightPanel.getLayout();
                cl.show(this.rightPanel, settingsNode.getId());
                if (settingsNode.getComponent() != null) {
                    settingsNode.getComponent().invalidate();
                }
            }
        });
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        SwingUtilities.invokeLater(() -> {
            DefaultMutableTreeNode firstLeaf = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getFirstChild();
            this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)firstLeaf.getParent()).getPath()));
            this.tree.setSelectionPath(new TreePath(firstLeaf.getPath()));
            this.tree.requestFocus();
        });
    }

    private void initPanels() {
        for (TmmTreeNode node : this.tree.getDataProvider().getChildren(this.tree.getDataProvider().getRoot())) {
            this.addSettingsPanel(node);
        }
    }

    private void addSettingsPanel(TmmTreeNode node) {
        if (!(node.getUserObject() instanceof TmmSettingsNode)) {
            return;
        }
        JComponent component = ((TmmSettingsNode)node.getUserObject()).getComponent();
        if (component != null) {
            NoBorderScrollPane scrollPane = new NoBorderScrollPane(component);
            scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            this.rightPanel.add((Component)scrollPane, ((TmmSettingsNode)node.getUserObject()).getId());
        }
        for (TmmTreeNode child : this.tree.getDataProvider().getChildren(node)) {
            this.addSettingsPanel(child);
        }
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[600lp:1000lp,grow]", "[600lp,grow]"));
        this.getContentPane().add((Component)contentPanel, "Center");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        contentPanel.add((Component)splitPane, "cell 0 0, grow");
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new CardLayout(0, 0));
        splitPane.setRightComponent(this.rightPanel);
        JPanel panelLeft = new JPanel();
        splitPane.setLeftComponent(panelLeft);
        panelLeft.setLayout((LayoutManager)new MigLayout("", "[200lp:200lp,grow]", "[][400lp,grow]"));
        this.tfFilter = new TmmSettingsTreeFilter();
        panelLeft.add((Component)this.tfFilter, "cell 0 0,grow");
        this.tfFilter.setColumns(10);
        NoBorderScrollPane scrollPaneLeft = new NoBorderScrollPane();
        panelLeft.add((Component)scrollPaneLeft, "cell 0 1,grow");
        this.tree = new TmmTree<TmmTreeNode>(this.dataProvider);
        scrollPaneLeft.setViewportView(this.tree);
        scrollPaneLeft.setHorizontalScrollBarPolicy(31);
        JPanel southPanel = new JPanel();
        this.getContentPane().add((Component)southPanel, "South");
        southPanel.setLayout((LayoutManager)new MigLayout("insets n 0 0 0, gap rel 0", "[grow][]", "[shrink 0][]"));
        JSeparator separator = new JSeparator();
        southPanel.add((Component)separator, "cell 0 0 2 1,growx");
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        southPanel.add((Component)panelButtons, "cell 1 1,alignx left,aligny top");
        JButton okButton = new JButton(TmmResourceBundle.getString("Button.close"));
        panelButtons.add(okButton);
        okButton.setAction(new CloseAction());
        this.getRootPane().setDefaultButton(okButton);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            TmmModuleManager.getInstance().saveSettings();
        }
        super.setVisible(visible);
    }

    private static class TmmSettingsTreeFilter
    extends TmmTreeTextFilter<TmmTreeNode> {
        private TmmSettingsTreeFilter() {
        }

        @Override
        public boolean accept(TmmTreeNode node) {
            if (StringUtils.isBlank((CharSequence)this.filterText)) {
                return true;
            }
            Matcher matcher = this.filterPattern.matcher(node.toString());
            if (matcher.find()) {
                return true;
            }
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                if (!this.accept((TmmTreeNode)e.nextElement())) continue;
                return true;
            }
            return this.checkParent(node.getDataProvider().getParent(node), this.filterPattern);
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 2386371884117941373L;

        CloseAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.close"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.setVisible(false);
        }
    }
}

