/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.TaskListComponent;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TaskListDialog
extends TmmDialog
implements TmmTaskListener {
    private static final long serialVersionUID = 4151412495928010232L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private static TaskListDialog instance;
    private final Map<TmmTaskHandle, TaskListComponent> taskMap = new ConcurrentHashMap<TmmTaskHandle, TaskListComponent>();
    private final TaskListComponent noActiveTask;
    private final JPanel panelContent;

    private TaskListDialog() {
        super(TmmResourceBundle.getString("tasklist.title"), "taskList");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.panelContent = new JPanel();
        this.panelContent.setOpaque(false);
        this.noActiveTask = new TaskListComponent(TmmResourceBundle.getString("task.nonerunning"));
        this.noActiveTask.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.panelContent.add(this.noActiveTask);
        this.panelContent.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow]", "[]"));
        this.panelContent.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        NoBorderScrollPane scrollPane = new NoBorderScrollPane();
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setViewportView(this.panelContent);
        JPanel rootPanel = new JPanel();
        rootPanel.setBackground(UIManager.getColor("Menu.background"));
        rootPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[200lp:300lp,grow]", "[100lp:300lp,grow]"));
        rootPanel.add((Component)scrollPane, "cell 0 0, top, grow");
        this.getContentPane().add((Component)rootPanel, "Center");
        JButton btnAbortAll = new JButton(TmmResourceBundle.getString("Button.abortqueue"));
        btnAbortAll.addActionListener(e -> this.taskMap.forEach((task, component) -> {
            task.cancel();
            this.removeListItem((TmmTaskHandle)task);
        }));
        this.addButton(btnAbortAll);
        TmmTaskManager.getInstance().addTaskListener(this);
        TmmUILayoutStore.getInstance().install(this.panelContent);
    }

    @Override
    public void dispose() {
        TmmUILayoutStore.getInstance().saveSettings(this);
    }

    public static TaskListDialog getInstance() {
        if (instance == null) {
            instance = new TaskListDialog();
        }
        return instance;
    }

    @Override
    public void processTaskEvent(TmmTaskHandle task) {
        SwingUtilities.invokeLater(() -> {
            TmmTaskHandle.TaskState state = task.getState();
            if (state == null) {
                return;
            }
            switch (state) {
                case CREATED: 
                case QUEUED: {
                    this.addListItem(task);
                    break;
                }
                case STARTED: {
                    TaskListComponent comp = this.taskMap.get(task);
                    if (comp == null) {
                        this.addListItem(task);
                        comp = this.taskMap.get(task);
                    }
                    comp.updateTaskInformation();
                    break;
                }
                default: {
                    this.removeListItem(task);
                }
            }
        });
    }

    private void addListItem(TmmTaskHandle task) {
        TaskListComponent comp;
        if (this.taskMap.containsKey(task)) {
            comp = this.taskMap.get(task);
        } else {
            comp = new TaskListComponent(task);
            this.taskMap.put(task, comp);
        }
        this.panelContent.remove(this.noActiveTask);
        comp.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.panelContent.add((Component)comp, "wrap, growx");
        this.bottomPanel.setVisible(true);
        if (this.isShowing()) {
            this.invalidate();
            this.panelContent.invalidate();
            this.repaint();
            this.panelContent.repaint();
        }
    }

    private void removeListItem(TmmTaskHandle task) {
        TaskListComponent comp = this.taskMap.remove(task);
        if (comp != null) {
            this.panelContent.remove(comp);
        }
        if (this.taskMap.isEmpty()) {
            this.panelContent.add((Component)this.noActiveTask, "wrap, growx");
            this.bottomPanel.setVisible(false);
        }
        if (this.isShowing()) {
            this.invalidate();
            this.panelContent.invalidate();
            this.repaint();
            this.panelContent.repaint();
        }
    }
}

