/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Paths;
import java.time.LocalDate;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.license.License;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class UnlockDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockDialog.class);

    public UnlockDialog() {
        super(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.unlock.desc"), "unlockDialog");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][500lp,grow]", "[][][20lp!][10lp:n][20lp!][][100lp:150lp,grow][]"));
        ReadOnlyTextArea taLicenseHint = new ReadOnlyTextArea(TmmResourceBundle.getString("tmm.license.hint") + "\n\n" + TmmResourceBundle.getString("tmm.license.hint2"));
        taLicenseHint.setLineWrap(true);
        panelContent.add((Component)taLicenseHint, "cell 0 0 2 1,grow, wmin 0");
        JButton btnOpenPaddle = new JButton(TmmResourceBundle.getString("tmm.license.buy"));
        btnOpenPaddle.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/purchase/");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                LOGGER.error("FAQ", (Throwable)e1);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelContent.add((Component)btnOpenPaddle, "cell 0 1 2 1");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 3 2 1,growx");
        JLabel lblEnterLicenseCodeT = new JLabel(TmmResourceBundle.getString("tmm.license.code"));
        panelContent.add((Component)lblEnterLicenseCodeT, "cell 0 5");
        JTextArea taLicenseCode = new JTextArea();
        taLicenseCode.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(taLicenseCode);
        scrollPane.setHorizontalScrollBarPolicy(31);
        panelContent.add((Component)scrollPane, "cell 1 5 1 2,grow, wmin 0");
        JButton btnUnlock = new JButton(TmmResourceBundle.getString("tmm.license.unlock"));
        btnUnlock.addActionListener(arg0 -> {
            try {
                String cleanedLicenseCode = taLicenseCode.getText().replaceAll("\\s", "");
                License.getInstance().setLicenseCode(cleanedLicenseCode);
                if (License.getInstance().validUntil() != null && License.getInstance().validUntil().isBefore(LocalDate.now())) {
                    JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("tmm.license.expired"));
                } else if (License.getInstance().isValidLicense()) {
                    Utils.writeStringToFile(Paths.get(Globals.DATA_FOLDER, "tmm.lic"), cleanedLicenseCode);
                    JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("tmm.license.thanks"));
                    JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("tmm.license.restart"));
                    this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("tmm.license.invalid"));
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("tmm.license.invalid"));
            }
        });
        panelContent.add((Component)btnUnlock, "cell 1 7");
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
    }
}

