/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.images;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class TmmTextIcon
extends ImageIcon {
    private final String text;
    private float fontSize;
    private Color color;

    public TmmTextIcon(String text, float fontSize, Color color) {
        this.text = text;
        this.fontSize = fontSize;
        this.color = color;
        this.update();
    }

    public void setFontSize(float size) {
        this.fontSize = size;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void update() {
        this.setImage(this.createImage());
    }

    private Image createImage() {
        try {
            Font font = UIManager.getFont("Label.font").deriveFont(1, this.fontSize);
            BufferedImage tmp = new BufferedImage(1, 1, 2);
            Graphics2D g2 = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(tmp);
            g2.setFont(font);
            Rectangle2D defaultBounds = g2.getFontMetrics().getStringBounds("M", g2);
            Rectangle2D bounds = font.createGlyphVector(g2.getFontRenderContext(), this.text).getVisualBounds();
            int iconWidth = (int)Math.ceil(bounds.getWidth()) + 2;
            int iconHeight = (int)Math.ceil(bounds.getHeight()) + 2;
            if ((double)iconHeight < defaultBounds.getHeight()) {
                iconHeight = (int)Math.ceil(defaultBounds.getHeight());
            }
            g2.dispose();
            if (iconWidth < iconHeight) {
                iconWidth = iconHeight;
            }
            BufferedImage buffer = new BufferedImage(iconWidth, iconHeight, 2);
            g2 = (Graphics2D)buffer.getGraphics();
            Map desktopHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (desktopHints != null) {
                g2.setRenderingHints(desktopHints);
            }
            g2.setFont(font);
            g2.setColor(this.color);
            int y = (int)Math.floor(bounds.getY() - (defaultBounds.getHeight() - bounds.getHeight()) / 2.0);
            g2.drawString(this.text, (int)(((double)iconWidth - Math.ceil(bounds.getWidth())) / 2.0), -y);
            g2.dispose();
            return buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

