/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieExtendedComparator
implements Comparator<Movie> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieExtendedComparator.class);
    private SortColumn sortColumn;
    private boolean sortAscending;
    private RuleBasedCollator stringCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();

    public MovieExtendedComparator(SortColumn sortColumn, boolean sortAscending) {
        this.sortColumn = sortColumn;
        this.sortAscending = sortAscending;
    }

    @Override
    public int compare(Movie movie1, Movie movie2) {
        Integer sortOrder = 0;
        try {
            switch (this.sortColumn) {
                case TITLE: {
                    sortOrder = this.stringCollator.compare(movie1.getTitleSortable().toLowerCase(Locale.ROOT), movie2.getTitleSortable().toLowerCase(Locale.ROOT));
                    break;
                }
                case SORT_TITLE: {
                    String title1 = StringUtils.isNotBlank((CharSequence)movie1.getSortTitle()) ? movie1.getSortTitle() : movie1.getTitleSortable();
                    String title2 = StringUtils.isNotBlank((CharSequence)movie2.getSortTitle()) ? movie2.getSortTitle() : movie2.getTitleSortable();
                    sortOrder = this.stringCollator.compare(title1.toLowerCase(Locale.ROOT), title2.toLowerCase(Locale.ROOT));
                    break;
                }
                case YEAR: {
                    sortOrder = this.compareNullFirst(movie1.getYear(), movie2.getYear());
                    if (sortOrder != 0) break;
                    sortOrder = Integer.compare(movie1.getYear(), movie2.getYear());
                    break;
                }
                case DATE_ADDED: {
                    sortOrder = this.compareNullFirst(movie1.getDateAdded(), movie2.getDateAdded());
                    if (sortOrder == null || sortOrder != 0) break;
                    sortOrder = movie1.getDateAdded().compareTo(movie2.getDateAdded());
                    break;
                }
                case WATCHED: {
                    sortOrder = this.compareNullFirst(movie1.isWatched(), movie2.isWatched());
                    if (sortOrder == null || sortOrder != 0) break;
                    sortOrder = Boolean.compare(movie1.isWatched(), movie2.isWatched());
                    break;
                }
                case RATING: {
                    sortOrder = this.compareNullFirst(movie1.getRating(), movie2.getRating());
                    if (sortOrder == null || sortOrder != 0) break;
                    sortOrder = Float.compare(movie1.getRating().getRating(), movie2.getRating().getRating());
                    break;
                }
                case RUNTIME: {
                    sortOrder = this.compareNullFirst(movie1.getRuntime(), movie2.getRuntime());
                    if (sortOrder == null || sortOrder != 0) break;
                    sortOrder = Integer.compare(movie1.getRuntime(), movie2.getRuntime());
                    break;
                }
                case VIDEO_BITRATE: {
                    sortOrder = this.compareNullFirst(movie1.getMediaInfoVideoBitrate(), movie2.getMediaInfoVideoBitrate());
                    if (sortOrder == null || sortOrder != 0) break;
                    sortOrder = Integer.compare(movie1.getMediaInfoVideoBitrate(), movie2.getMediaInfoVideoBitrate());
                    break;
                }
                case FRAME_RATE: {
                    sortOrder = this.compareNullFirst(movie1.getMediaInfoFrameRate(), movie2.getMediaInfoFrameRate());
                    if (sortOrder == null || sortOrder != 0) break;
                    sortOrder = Double.compare(movie1.getMediaInfoFrameRate(), movie2.getMediaInfoFrameRate());
                    break;
                }
                case RELEASE_DATE: {
                    sortOrder = this.compareNullFirst(movie1.getReleaseDate(), movie2.getReleaseDate());
                    if (sortOrder == null || sortOrder != 0) break;
                    sortOrder = movie1.getReleaseDate().compareTo(movie2.getReleaseDate());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        if (sortOrder == null) {
            sortOrder = 0;
        }
        if (sortOrder == 0 && this.sortColumn != SortColumn.TITLE && this.sortColumn != SortColumn.SORT_TITLE) {
            sortOrder = this.stringCollator.compare(movie1.getTitleSortable().toLowerCase(Locale.ROOT), movie2.getTitleSortable().toLowerCase(Locale.ROOT));
        }
        if (this.sortAscending) {
            return sortOrder;
        }
        return sortOrder * -1;
    }

    private Integer compareNullFirst(Object o1, Object o2) {
        Integer sort = o1 == null && o2 == null ? null : (o1 == null ? Integer.valueOf(-1) : (o2 == null ? Integer.valueOf(1) : Integer.valueOf(0)));
        return sort;
    }

    public static enum OfflineMovie {
        OFFLINE(TmmResourceBundle.getString("movie.offline")),
        NOT_OFFLINE(TmmResourceBundle.getString("movie.online"));

        private String title;

        private OfflineMovie(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum MovieInMovieSet {
        IN_MOVIESET(TmmResourceBundle.getString("movie.inmovieset")),
        NOT_IN_MOVIESET(TmmResourceBundle.getString("movie.notinmovieset"));

        private String title;

        private MovieInMovieSet(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum SortOrder {
        ASCENDING(TmmResourceBundle.getString("sort.ascending")),
        DESCENDING(TmmResourceBundle.getString("sort.descending"));

        private String title;

        private SortOrder(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum WatchedFlag {
        WATCHED(TmmResourceBundle.getString("metatag.watched")),
        NOT_WATCHED(TmmResourceBundle.getString("metatag.notwatched"));

        private String title;

        private WatchedFlag(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum SortColumn {
        TITLE(TmmResourceBundle.getString("metatag.title")),
        SORT_TITLE(TmmResourceBundle.getString("metatag.sorttitle")),
        YEAR(TmmResourceBundle.getString("metatag.year")),
        DATE_ADDED(TmmResourceBundle.getString("metatag.dateadded")),
        RELEASE_DATE(TmmResourceBundle.getString("metatag.releasedate")),
        WATCHED(TmmResourceBundle.getString("metatag.watched")),
        RATING(TmmResourceBundle.getString("metatag.rating")),
        RUNTIME(TmmResourceBundle.getString("metatag.runtime")),
        VIDEO_BITRATE(TmmResourceBundle.getString("metatag.videobitrate")),
        FRAME_RATE(TmmResourceBundle.getString("metatag.framerate"));

        private String title;

        private SortColumn(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

