/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;

public class MovieSubtitleChooserModel
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSubtitleChooserModel.class);
    public static final MovieSubtitleChooserModel EMPTY_RESULT = new MovieSubtitleChooserModel();
    private MediaLanguages language = null;
    private SubtitleSearchResult result = null;
    private String name = "";
    private String releaseName = "";
    private String downloadUrl = "";

    public MovieSubtitleChooserModel(SubtitleSearchResult result, MediaLanguages language) {
        this.result = result;
        this.language = language;
        this.name = result.getTitle();
        this.releaseName = result.getReleaseName();
        this.downloadUrl = result.getUrl();
    }

    private MovieSubtitleChooserModel() {
        this.name = TmmResourceBundle.getString("chooser.nothingfound");
    }

    public String getName() {
        return this.name;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }
}

