/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieBulkEditorDialog;

public class MovieBulkEditAction
extends TmmAction {
    private static final long serialVersionUID = -3974602352019088416L;

    public MovieBulkEditAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.bulkedit"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.bulkedit.desc"));
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieBulkEditorDialog editor = new MovieBulkEditorDialog(selectedMovies);
        editor.setLocationRelativeTo(MainWindow.getInstance());
        editor.pack();
        editor.setVisible(true);
    }
}

