/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieEditorDialog;

public class MovieEditAction
extends TmmAction {
    private static final long serialVersionUID = -8473181347332963044L;

    @Deprecated
    public MovieEditAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", TmmResourceBundle.getString("movie.edit"));
        }
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit"));
    }

    public MovieEditAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.edit"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            return;
        }
        int selectedCount = selectedMovies.size();
        int index = 0;
        int selectedTab = 0;
        do {
            Movie movie = selectedMovies.get(index);
            MovieEditorDialog dialogMovieEditor = new MovieEditorDialog(movie, index, selectedCount, selectedTab);
            dialogMovieEditor.setVisible(true);
            selectedTab = dialogMovieEditor.getSelectedTab();
            if (!dialogMovieEditor.isContinueQueue()) break;
            if (dialogMovieEditor.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

