/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieKodiGetWatchedAction
extends TmmAction {
    private static final long serialVersionUID = -6731682301579049379L;

    public MovieKodiGetWatchedAction() {
        this.putValue("SwingLargeIconKey", IconManager.WATCHED_MENU);
        this.putValue("SmallIcon", IconManager.WATCHED_MENU);
        this.putValue("Name", TmmResourceBundle.getString("kodi.rpc.getwatched"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("kodi.rpc.getwatched"), selectedMovies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                KodiRPC kodiRPC = KodiRPC.getInstance();
                int i = 0;
                for (Movie movie : selectedMovies) {
                    kodiRPC.readWatchedState(movie);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
            }
        });
    }
}

