/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieKodiRefreshNfoAction
extends TmmAction {
    private static final long serialVersionUID = -6731682301579049379L;

    public MovieKodiRefreshNfoAction() {
        this.putValue("SwingLargeIconKey", IconManager.MEDIAINFO);
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("Name", TmmResourceBundle.getString("kodi.rpc.refreshnfo"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies(true);
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("kodi.rpc.refreshnfo"), selectedMovies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                KodiRPC kodiRPC = KodiRPC.getInstance();
                int i = 0;
                for (Movie movie : selectedMovies) {
                    kodiRPC.refreshFromNfo(movie);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
                if (this.progressDone > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    kodiRPC.updateMovieMappings();
                }
            }
        });
    }
}

