/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieReloadMediaInformationTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRebuildMediainfoXmlAction
extends TmmAction {
    private static final long serialVersionUID = -2019243514238173721L;

    public MovieRebuildMediainfoXmlAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.rebuildmediainfoxml"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.rebuildmediainfoxml"));
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("SwingLargeIconKey", IconManager.MEDIAINFO);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        if (!TmmProperties.getInstance().getPropertyAsBoolean("movie.hidedeletemediainfoxmlhint").booleanValue()) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            Object[] params = new Object[]{TmmResourceBundle.getString("movie.deletemediainfoxml.desc"), checkBox};
            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("movie.deletemediainfoxml"), 0, 3, null, options, null);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("movie.hidedeletemediainfoxmlhint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        for (Movie movie : selectedMovies) {
            movie.getMediaFiles(MediaFileType.MEDIAINFO).forEach(mediaFile -> {
                Utils.deleteFileSafely(mediaFile.getFileAsPath());
                movie.removeFromMediaFiles((MediaFile)mediaFile);
            });
        }
        MovieReloadMediaInformationTask task = new MovieReloadMediaInformationTask(selectedMovies);
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

