/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRenameAction
extends TmmAction {
    private static final long serialVersionUID = 4804592958868052533L;

    public MovieRenameAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.rename"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.rename"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        if (!TmmProperties.getInstance().getPropertyAsBoolean("movie.hiderenamehint").booleanValue()) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            Object[] params = new Object[]{TmmResourceBundle.getString("movie.rename.desc"), checkBox};
            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("movie.rename"), 0, 3, null, options, null);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("movie.hiderenamehint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        MovieRenameTask renameTask = new MovieRenameTask(selectedMovies);
        TmmTaskManager.getInstance().addMainTask(renameTask);
    }
}

