/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieSubtitleChooserDialog;

public class MovieSubtitleSearchAction
extends TmmAction {
    private static final long serialVersionUID = -6006932119900795735L;

    public MovieSubtitleSearchAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.search.subtitle"));
        this.putValue("SmallIcon", IconManager.SUBTITLE);
        this.putValue("SwingLargeIconKey", IconManager.SUBTITLE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.search.subtitle"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        for (Movie movie : selectedMovies) {
            if (movie.isDisc()) continue;
            for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
                MovieSubtitleChooserDialog dialogMovieSubtitleChooser = new MovieSubtitleChooserDialog(movie, mediaFile, selectedMovies.size() > 1);
                if (dialogMovieSubtitleChooser.showDialog()) continue;
                return;
            }
        }
    }
}

