/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieTrailerDownloadAction
extends TmmAction {
    private static final long serialVersionUID = -8668265401054434251L;

    public MovieTrailerDownloadAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.downloadtrailer"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.downloadtrailer"));
        this.putValue("SmallIcon", IconManager.DOWNLOAD);
        this.putValue("SwingLargeIconKey", IconManager.DOWNLOAD);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        boolean existingTrailer = false;
        for (Movie movie : selectedMovies) {
            if (movie.getMediaFiles(MediaFileType.TRAILER).isEmpty()) continue;
            existingTrailer = true;
            break;
        }
        boolean overwriteTrailer = false;
        if (existingTrailer) {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int answer = JOptionPane.showOptionDialog(MainWindow.getFrame(), TmmResourceBundle.getString("movie.overwritetrailer"), TmmResourceBundle.getString("movie.downloadtrailer"), 0, 3, null, options, null);
            if (answer == 0) {
                overwriteTrailer = true;
            }
        }
        for (Movie movie : selectedMovies) {
            if (!movie.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !overwriteTrailer || movie.getTrailer().isEmpty()) continue;
            MovieHelpers.downloadBestTrailer(movie);
        }
    }
}

