/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.floreysoft.jmte.Engine;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.components.table.NullSelectionModel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.actions.MovieSetAddAction;

public class MovieBulkEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -8515248604267310279L;
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final List<Movie> moviesToEdit = new ArrayList<Movie>();
    private boolean changed = false;
    private final JComboBox cbMovieSet;
    private final JComboBox<MovieProperty> cbProperty;
    private final EventList<MovieValues> movieValuesEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieValues.class)));

    public MovieBulkEditorDialog(List<Movie> movies) {
        super(TmmResourceBundle.getString("movie.edit"), "movieBulkEditor");
        TmmTabbedPane tabbedPane = new TmmTabbedPane();
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("", "[20lp:n][200lp:350lp,grow][][][]", "[][][][][][][][][][][][][][]"));
        TmmLabel lblYearT = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        panelContent.add((Component)lblYearT, "cell 0 0,alignx right");
        YearSpinner spYear = new YearSpinner();
        panelContent.add((Component)spYear, "cell 1 0");
        SquareIconButton btnYear = new SquareIconButton(IconManager.APPLY_INV);
        btnYear.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setYear((Integer)spYear.getValue());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnYear, "cell 2 0");
        TmmLabel lblGenresT = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        panelContent.add((Component)lblGenresT, "cell 0 1,alignx right");
        tabbedPane.addTab(TmmResourceBundle.getString("bulkedit.basic"), panelContent);
        AutocompleteComboBox<MediaGenres> cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        cbGenres.setEditable(true);
        panelContent.add(cbGenres, "cell 1 1,growx,wmin 0");
        SquareIconButton btnAddGenre = new SquareIconButton(IconManager.ADD_INV);
        btnAddGenre.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                genre = (MediaGenres)item;
            }
            if (item instanceof String) {
                genre = MediaGenres.getGenre((String)item);
            }
            if (genre != null) {
                for (Movie movie : this.moviesToEdit) {
                    movie.addToGenres(Collections.singletonList(genre));
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnAddGenre, "cell 2 1");
        SquareIconButton btnRemoveGenre = new SquareIconButton(IconManager.REMOVE_INV);
        btnRemoveGenre.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                genre = (MediaGenres)item;
            }
            if (item instanceof String) {
                genre = MediaGenres.getGenre((String)item);
            }
            if (genre != null) {
                for (Movie movie : this.moviesToEdit) {
                    movie.removeGenre(genre);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnRemoveGenre, "cell 3 1");
        SquareIconButton btnRemoveAllGenres = new SquareIconButton(IconManager.DELETE);
        btnRemoveAllGenres.addActionListener(e -> {
            if (this.isDeleteConfirmed(TmmResourceBundle.getString("metatag.genre"))) {
                this.changed = true;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.removeAllGenres();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnRemoveAllGenres, "cell 4 1");
        TmmLabel lblTagsT = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelContent.add((Component)lblTagsT, "cell 0 2,alignx right");
        AutocompleteComboBox<String> cbTags = new AutocompleteComboBox<String>(ListUtils.asSortedList(this.movieList.getTagsInMovies()));
        cbTags.setEditable(true);
        panelContent.add(cbTags, "cell 1 2,growx,wmin 0");
        SquareIconButton btnAddTag = new SquareIconButton(IconManager.ADD_INV);
        btnAddTag.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)tag)) {
                return;
            }
            for (Movie movie : this.moviesToEdit) {
                movie.addToTags(Collections.singletonList(tag));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnAddTag, "cell 2 2");
        SquareIconButton btnRemoveTag = new SquareIconButton(IconManager.REMOVE_INV);
        btnRemoveTag.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            for (Movie movie : this.moviesToEdit) {
                movie.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnRemoveTag, "cell 3 2");
        SquareIconButton btnRemoveAllTags = new SquareIconButton(IconManager.DELETE);
        btnRemoveAllTags.addActionListener(e -> {
            if (this.isDeleteConfirmed(TmmResourceBundle.getString("metatag.tags"))) {
                this.changed = true;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.removeAllTags();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnRemoveAllTags, "cell 4 2");
        TmmLabel lblEditionT = new TmmLabel(TmmResourceBundle.getString("metatag.edition"));
        panelContent.add((Component)lblEditionT, "cell 0 3,alignx right");
        AutocompleteComboBox<MovieEdition> cbEdition = new AutocompleteComboBox<MovieEdition>(MovieEdition.values());
        panelContent.add(cbEdition, "cell 1 3,growx");
        SquareIconButton btnMovieEdition = new SquareIconButton(IconManager.APPLY_INV);
        btnMovieEdition.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MovieEdition edition = null;
            Object item = cbEdition.getSelectedItem();
            if (item instanceof MovieEdition) {
                edition = (MovieEdition)item;
            }
            if (item instanceof String) {
                edition = MovieEdition.getMovieEdition((String)item);
            }
            if (edition != null) {
                for (Movie movie : this.moviesToEdit) {
                    movie.setEdition(edition);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnMovieEdition, "cell 2 3");
        TmmLabel lblCertificationT = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        panelContent.add((Component)lblCertificationT, "cell 0 4,alignx right");
        JComboBox<MediaCertification> cbCertification = new JComboBox<MediaCertification>();
        for (MediaCertification cert : MediaCertification.getCertificationsforCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry())) {
            cbCertification.addItem(cert);
        }
        panelContent.add(cbCertification, "cell 1 4,growx");
        SquareIconButton btnCertification = new SquareIconButton(IconManager.APPLY_INV);
        btnCertification.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaCertification cert = (MediaCertification)((Object)((Object)cbCertification.getSelectedItem()));
            for (Movie movie : this.moviesToEdit) {
                movie.setCertification(cert);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnCertification, "cell 2 4");
        TmmLabel lblMovieSetT = new TmmLabel(TmmResourceBundle.getString("metatag.movieset"));
        panelContent.add((Component)lblMovieSetT, "cell 0 5,alignx right");
        this.cbMovieSet = new JComboBox();
        panelContent.add((Component)this.cbMovieSet, "cell 1 5,growx,wmin 0");
        SquareIconButton btnSetMovieSet = new SquareIconButton(IconManager.APPLY_INV);
        btnSetMovieSet.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object obj = this.cbMovieSet.getSelectedItem();
            for (Movie movie : this.moviesToEdit) {
                if (obj instanceof String) {
                    movie.removeFromMovieSet();
                }
                if (!(obj instanceof MovieSet)) continue;
                MovieSet movieSet = (MovieSet)obj;
                if (movie.getMovieSet() == movieSet) continue;
                movie.removeFromMovieSet();
                movie.setMovieSet(movieSet);
                movieSet.insertMovie(movie);
            }
            if (obj instanceof MovieSet) {
                MovieSet movieSet = (MovieSet)obj;
                movieSet.saveToDb();
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnSetMovieSet, "cell 2 5");
        JButton btnNewMovieset = new JButton(new MovieSetAddAction());
        panelContent.add((Component)btnNewMovieset, "cell 3 5 2 1,growx");
        TmmLabel lblWatchedT = new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
        panelContent.add((Component)lblWatchedT, "cell 0 6,alignx right");
        JCheckBox chckbxWatched = new JCheckBox("");
        panelContent.add((Component)chckbxWatched, "cell 1 6,aligny top");
        SquareIconButton btnWatched = new SquareIconButton(IconManager.APPLY_INV);
        btnWatched.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                if (chckbxWatched.isSelected()) {
                    movie.setWatched(true);
                    if (movie.getPlaycount() != 0) continue;
                    movie.setPlaycount(1);
                    movie.setLastWatched(new Date());
                    continue;
                }
                movie.setWatched(false);
                movie.setPlaycount(0);
                movie.setLastWatched(null);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnWatched, "cell 2 6");
        TmmLabel lblVideo3DT = new TmmLabel(TmmResourceBundle.getString("metatag.3d"));
        panelContent.add((Component)lblVideo3DT, "cell 0 7,alignx right");
        JCheckBox chckbxVideo3D = new JCheckBox("");
        panelContent.add((Component)chckbxVideo3D, "cell 1 7");
        SquareIconButton btnVideo3D = new SquareIconButton(IconManager.APPLY_INV);
        btnVideo3D.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setVideoIn3D(chckbxVideo3D.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnVideo3D, "cell 2 7");
        TmmLabel lblMediasourceT = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        panelContent.add((Component)lblMediasourceT, "cell 0 8,alignx right");
        JComboBox<MediaSource> cbMediaSource = new JComboBox<MediaSource>(MediaSource.values());
        panelContent.add(cbMediaSource, "cell 1 8,growx");
        SquareIconButton btnMediaSource = new SquareIconButton(IconManager.APPLY_INV);
        btnMediaSource.addActionListener(e -> {
            this.changed = true;
            Object obj = cbMediaSource.getSelectedItem();
            if (obj instanceof MediaSource) {
                MediaSource mediaSource = (MediaSource)obj;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.setMediaSource(mediaSource);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnMediaSource, "cell 2 8");
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 9,alignx right");
        JTextField tfLanguage = new JTextField();
        panelContent.add((Component)tfLanguage, "cell 1 9,growx");
        SquareIconButton btnLanguage = new SquareIconButton(IconManager.APPLY_INV);
        btnLanguage.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSpokenLanguages(tfLanguage.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnLanguage, "cell 2 9");
        TmmLabel lblCountryT = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        panelContent.add((Component)lblCountryT, "cell 0 10,alignx trailing");
        JTextField tfCountry = new JTextField();
        panelContent.add((Component)tfCountry, "cell 1 10,growx");
        SquareIconButton btnCountry = new SquareIconButton(IconManager.APPLY_INV);
        btnCountry.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setCountry(tfCountry.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnCountry, "cell 2 10");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelContent.add((Component)lblNoteT, "cell 0 11,alignx trailing");
        JTextField tfNote = new JTextField();
        panelContent.add((Component)tfNote, "cell 1 11,growx");
        SquareIconButton btnNote = new SquareIconButton(IconManager.APPLY_INV);
        btnNote.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setNote(tfNote.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnNote, "cell 2 11");
        TmmLabel lblSorttitleT = new TmmLabel(TmmResourceBundle.getString("metatag.sorttitle"));
        panelContent.add((Component)lblSorttitleT, "flowx,cell 0 12,alignx right");
        JLabel lblSorttitleInfo = new JLabel(IconManager.HINT);
        lblSorttitleInfo.setToolTipText(TmmResourceBundle.getString("edit.setsorttitle.desc"));
        panelContent.add((Component)lblSorttitleInfo, "cell 0 12");
        JButton btnSetSorttitle = new JButton(TmmResourceBundle.getString("edit.setsorttitle"));
        btnSetSorttitle.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSortTitle(movie.getTitleSortable());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnSetSorttitle, "flowx,cell 1 12 4 1");
        TmmLabel lblSpokenLanguages = new TmmLabel(TmmResourceBundle.getString("metatag.spokenlanguages"));
        panelContent.add((Component)lblSpokenLanguages, "cell 0 13,alignx right");
        JButton btnFirstAudioStream = new JButton(TmmResourceBundle.getString("edit.audio.first"));
        btnFirstAudioStream.setToolTipText(TmmResourceBundle.getString("edit.audio.first.desc"));
        btnFirstAudioStream.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSpokenLanguages(movie.getMediaInfoAudioLanguageList().stream().findFirst().orElse(""));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnFirstAudioStream, "flowx,cell 1 13 4 1");
        JButton btnBestAudioStream = new JButton(TmmResourceBundle.getString("edit.audio.best"));
        btnBestAudioStream.setToolTipText(TmmResourceBundle.getString("edit.audio.best.desc"));
        btnBestAudioStream.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSpokenLanguages(movie.getMediaInfoAudioLanguage());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnBestAudioStream, "cell 1 13");
        JButton btnAllAudioStreams = new JButton(TmmResourceBundle.getString("edit.audio.all"));
        btnAllAudioStreams.setToolTipText(TmmResourceBundle.getString("edit.audio.all.desc"));
        btnAllAudioStreams.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSpokenLanguages(String.join((CharSequence)", ", movie.getMediaInfoAudioLanguageList()));
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnAllAudioStreams, "cell 1 13");
        JButton btnClearSorttitle = new JButton(TmmResourceBundle.getString("edit.clearsorttitle"));
        btnClearSorttitle.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSortTitle("");
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnClearSorttitle, "cell 1 12 4 1");
        panelContent = new JPanel();
        tabbedPane.addTab(TmmResourceBundle.getString("bulkedit.expert"), panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][100lp:200lp,grow]", "[grow][20lp!][][50lp][20lp!][200lp:250lp,grow]"));
        ReadOnlyTextPane tpDescription = new ReadOnlyTextPane(TmmResourceBundle.getString("bulkedit.description"));
        panelContent.add((Component)tpDescription, "cell 0 0 2 1,grow");
        TmmLabel lblPropertyT = new TmmLabel(TmmResourceBundle.getString("bulkedit.field"));
        panelContent.add((Component)lblPropertyT, "cell 0 2,alignx right");
        this.cbProperty = new JComboBox();
        this.cbProperty.addItem(new MovieProperty("title", TmmResourceBundle.getString("metatag.title")));
        this.cbProperty.addItem(new MovieProperty("originalTitle", TmmResourceBundle.getString("metatag.originaltitle")));
        this.cbProperty.addItem(new MovieProperty("sortTitle", TmmResourceBundle.getString("metatag.sorttitle")));
        this.cbProperty.addItem(new MovieProperty("tagline", TmmResourceBundle.getString("metatag.tagline")));
        this.cbProperty.addItem(new MovieProperty("plot", TmmResourceBundle.getString("metatag.plot")));
        this.cbProperty.addItem(new MovieProperty("productionCompany", TmmResourceBundle.getString("metatag.production")));
        this.cbProperty.addItem(new MovieProperty("spokenLanguages", TmmResourceBundle.getString("metatag.spokenlanguages")));
        this.cbProperty.addItem(new MovieProperty("country", TmmResourceBundle.getString("metatag.country")));
        this.cbProperty.addItem(new MovieProperty("note", TmmResourceBundle.getString("metatag.note")));
        this.cbProperty.addItem(new MovieProperty("originalFilename", TmmResourceBundle.getString("metatag.originalfile")));
        this.cbProperty.addItemListener(e -> this.movieValuesEventList.forEach(movieValues -> movieValues.changeProperty(((MovieProperty)this.cbProperty.getSelectedItem()).property)));
        panelContent.add(this.cbProperty, "cell 1 2,growx,wmin 0");
        TmmLabel lblPatternT = new TmmLabel(TmmResourceBundle.getString("bulkedit.value"));
        panelContent.add((Component)lblPatternT, "cell 0 3,alignx right");
        final JTextArea taPattern = new JTextArea();
        taPattern.setBorder(UIManager.getBorder("ScrollPane.border"));
        taPattern.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changePattern();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changePattern();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changePattern();
            }

            private void changePattern() {
                MovieBulkEditorDialog.this.movieValuesEventList.forEach(movieValues -> movieValues.changePattern(taPattern.getText()));
            }
        });
        taPattern.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                taPattern.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                taPattern.repaint();
            }
        });
        panelContent.add((Component)taPattern, "flowx,cell 1 3,wmin 0,grow");
        SquareIconButton btnApply = new SquareIconButton(IconManager.APPLY_INV);
        btnApply.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.movieValuesEventList.forEach(MovieValues::applyValue);
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnApply, "cell 1 3,aligny bottom");
        TmmTable tableValues = new TmmTable((TableModel)((Object)new TmmTableModel<MovieValues>(this.movieValuesEventList, new MovieValuesTableFormat())));
        tableValues.setSelectionModel(new NullSelectionModel());
        JScrollPane scrollPane = new JScrollPane();
        tableValues.configureScrollPane(scrollPane);
        panelContent.add((Component)scrollPane, "cell 0 5 2 1,grow");
        scrollPane.setViewportView(tableValues);
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> {
            if (this.changed) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.writeNFO();
                    movie.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.setVisible(false);
        });
        this.addDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MovieBulkEditorDialog.this.changed) {
                    for (Movie movie : MovieBulkEditorDialog.this.moviesToEdit) {
                        movie.writeNFO();
                        movie.saveToDb();
                    }
                    if (MovieModuleManager.getInstance().getSettings().getSyncTrakt()) {
                        MovieSyncTraktTvTask task = new MovieSyncTraktTvTask(MovieBulkEditorDialog.this.moviesToEdit);
                        task.setSyncCollection(MovieModuleManager.getInstance().getSettings().getSyncTraktCollection());
                        task.setSyncWatched(MovieModuleManager.getInstance().getSettings().getSyncTraktWatched());
                        task.setSyncRating(MovieModuleManager.getInstance().getSettings().getSyncTraktRating());
                        TmmTaskManager.getInstance().addUnnamedTask(task);
                    }
                }
            }
        });
        this.setMovieSets();
        this.moviesToEdit.addAll(movies);
        for (Movie movie : this.moviesToEdit) {
            MovieValues movieValues = new MovieValues(movie);
            movieValues.changeProperty(((MovieProperty)this.cbProperty.getSelectedItem()).property);
            this.movieValuesEventList.add((Object)movieValues);
        }
        PropertyChangeListener listener = evt -> {
            if ("addedMovieSet".equals(evt.getPropertyName())) {
                this.setMovieSets();
            }
        };
        this.movieList.addPropertyChangeListener(listener);
    }

    private void setMovieSets() {
        MovieSet selectedMovieSet = null;
        Object obj = this.cbMovieSet.getSelectedItem();
        if (obj instanceof MovieSet) {
            selectedMovieSet = (MovieSet)obj;
        }
        this.cbMovieSet.removeAllItems();
        this.cbMovieSet.addItem("");
        for (MovieSet movieSet : this.movieList.getSortedMovieSetList()) {
            this.cbMovieSet.addItem(movieSet);
        }
        if (selectedMovieSet != null) {
            this.cbMovieSet.setSelectedItem(selectedMovieSet);
        }
    }

    private boolean isDeleteConfirmed(String attribute) {
        Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
        int dialogResult = JOptionPane.showOptionDialog(null, MessageFormat.format(TmmResourceBundle.getString("message.bulkedit.delete"), attribute), TmmResourceBundle.getString("message.bulkedit.warning"), 0, 3, null, options, null);
        return dialogResult == 0;
    }

    private static class MovieProperty {
        private final String property;
        private final String description;

        public MovieProperty(String property, String description) {
            this.property = property;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class MovieValuesTableFormat
    extends TmmTableFormat<MovieValues> {
        public MovieValuesTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", MovieValues::getMovieTitle, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("bulkedit.oldvalue"), "oldValue", MovieValues::getPropertyValue, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("bulkedit.newvalue"), "newValue", MovieValues::getPatternValue, String.class);
            this.addColumn(col);
        }
    }

    private static class MovieValues
    extends AbstractModelObject {
        private final Movie movie;
        private String property;
        private String propertyValue = "";
        private String patternValue = "";

        public MovieValues(Movie movie) {
            this.movie = movie;
        }

        public void changeProperty(String property) {
            this.property = property;
            String oldValue = this.propertyValue;
            this.propertyValue = "";
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(property, Movie.class);
                Object value = descriptor.getReadMethod().invoke((Object)this.movie, new Object[0]);
                if (value != null) {
                    this.propertyValue = value.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firePropertyChange("propertyValue", oldValue, this.propertyValue);
        }

        public void changePattern(String pattern) {
            String oldValue = this.patternValue;
            this.patternValue = this.getPatternValue(pattern);
            this.firePropertyChange("patternValue", oldValue, this.patternValue);
        }

        private String getPatternValue(String pattern) {
            try {
                Engine engine = MovieRenamer.createEngine();
                HashMap<String, Movie> root = new HashMap<String, Movie>();
                root.put("movie", this.movie);
                return engine.transform(JmteUtils.morphTemplate(pattern, MovieRenamer.getTokenMap()), root);
            }
            catch (Exception e) {
                return pattern;
            }
        }

        public void applyValue() {
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(this.property, Movie.class);
                descriptor.getWriteMethod().invoke((Object)this.movie, this.patternValue);
                String oldValue = this.propertyValue;
                this.propertyValue = this.patternValue;
                this.firePropertyChange("propertyValue", oldValue, this.propertyValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getMovieTitle() {
            return this.movie.getTitle();
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPatternValue() {
            return this.patternValue;
        }
    }
}

