/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieCreateOfflineDialog
extends TmmDialog {
    private static final long serialVersionUID = -8515248604267318279L;
    private MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieCreateOfflineDialog() {
        super(TmmResourceBundle.getString("movie.createoffline"), "movieCreateOffline");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][][]", "[][][]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        panelContent.add((Component)lblTitle, "cell 0 0,alignx right");
        JTextField tfMovieName = new JTextField();
        panelContent.add((Component)tfMovieName, "cell 1 0,growx");
        tfMovieName.setColumns(10);
        TmmLabel lblMediaSource = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        panelContent.add((Component)lblMediaSource, "cell 0 1,alignx right");
        JComboBox<MediaSource> cbMediaSource = new JComboBox<MediaSource>();
        cbMediaSource.addItem(MediaSource.UNKNOWN);
        cbMediaSource.addItem(MediaSource.DVD);
        cbMediaSource.addItem(MediaSource.BLURAY);
        cbMediaSource.addItem(MediaSource.HDDVD);
        cbMediaSource.addItem(MediaSource.VHS);
        panelContent.add(cbMediaSource, "cell 1 1,growx");
        TmmLabel lblDatasource = new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
        panelContent.add((Component)lblDatasource, "cell 0 2,alignx right");
        JComboBox<String> cbDatasource = new JComboBox<String>();
        panelContent.add(cbDatasource, "cell 1 2,growx");
        JButton btnAdd = new JButton(IconManager.ADD_INV);
        btnAdd.addActionListener(e -> {
            String title = tfMovieName.getText();
            String datasource = (String)cbDatasource.getSelectedItem();
            MediaSource mediaSource = (MediaSource)cbMediaSource.getSelectedItem();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{title, datasource})) {
                this.movieList.addOfflineMovie(title, datasource, mediaSource);
                String text = TmmResourceBundle.getString("movie.createoffline.created").replaceAll("\\{\\}", title);
                JOptionPane.showMessageDialog(this, text);
            }
        });
        panelContent.add((Component)btnAdd, "cell 2 0");
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(e -> this.setVisible(false));
        this.addButton(btnClose);
        for (String datasource : MovieModuleManager.getInstance().getSettings().getMovieDataSource()) {
            cbDatasource.addItem(datasource);
        }
    }
}

