/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieDownloadSubtitleDialog
extends TmmDialog {
    private static final long serialVersionUID = 3826984454317879241L;
    private final MediaScraperCheckComboBox cbSubtitleScraper;
    private final TmmCheckComboBox<MediaLanguages> cbLanguage;
    private final JCheckBox chckbxForceBestSubtitle;
    private boolean startDownload = false;

    public MovieDownloadSubtitleDialog(String title) {
        super(title, "downloadSubtitle");
        this.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        JPanel panelScraper = new JPanel();
        this.getContentPane().add((Component)panelScraper, "Center");
        panelScraper.setLayout((LayoutManager)new MigLayout("", "[16lp!][][300lp:300lp,grow]", "[][][][10lp:n][]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper"));
        panelScraper.add((Component)lblScraper, "cell 0 0 2 1,alignx right");
        this.cbSubtitleScraper = new MediaScraperCheckComboBox(MovieModuleManager.getInstance().getMovieList().getAvailableSubtitleScrapers());
        panelScraper.add((Component)this.cbSubtitleScraper, "cell 2 0,growx,wmin 0");
        TmmLabel lblLanguage = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelScraper.add((Component)lblLanguage, "cell 0 1 2 1,alignx right");
        this.cbLanguage = new TmmCheckComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelScraper.add(this.cbLanguage, "cell 2 1,growx,wmin 0");
        ReadOnlyTextArea taHint = new ReadOnlyTextArea(TmmResourceBundle.getString("movie.download.subtitles.hint"));
        panelScraper.add((Component)taHint, "cell 1 2 2 1,wmin 0,grow");
        this.chckbxForceBestSubtitle = new JCheckBox(TmmResourceBundle.getString("subtitle.download.force"));
        this.chckbxForceBestSubtitle.setToolTipText(TmmResourceBundle.getString("subtitle.download.force.desc"));
        panelScraper.add((Component)this.chckbxForceBestSubtitle, "cell 1 4 2 1");
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startDownload = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(TmmResourceBundle.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startDownload = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        ArrayList<MediaScraper> selectedSubtitleScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper subtitleScraper : MovieModuleManager.getInstance().getMovieList().getAvailableSubtitleScrapers()) {
            if (!MovieModuleManager.getInstance().getSettings().getSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            selectedSubtitleScrapers.add(subtitleScraper);
        }
        if (!selectedSubtitleScrapers.isEmpty()) {
            this.cbSubtitleScraper.setSelectedItems(selectedSubtitleScrapers);
        }
        this.cbLanguage.setSelectedItems(Collections.singletonList(MovieModuleManager.getInstance().getSettings().getSubtitleScraperLanguage()));
        this.chckbxForceBestSubtitle.setSelected(MovieModuleManager.getInstance().getSettings().isSubtitleForceBestMatch());
    }

    public List<MediaScraper> getSubtitleScrapers() {
        return new ArrayList<MediaScraper>(this.cbSubtitleScraper.getSelectedItems());
    }

    public List<MediaLanguages> getLanguages() {
        return this.cbLanguage.getSelectedItems();
    }

    public boolean isForceBestMatch() {
        return this.chckbxForceBestSubtitle.isSelected();
    }

    public boolean shouldStartDownload() {
        return this.startDownload;
    }
}

