/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.dialogs.FilterSaveDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.filters.IMovieUIFilter;
import org.tinymediamanager.ui.movies.filters.MovieAllInOneFilter;
import org.tinymediamanager.ui.movies.filters.MovieAspectRatioFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioChannelFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioCodecFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioLanguageFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioTitleFilter;
import org.tinymediamanager.ui.movies.filters.MovieCastFilter;
import org.tinymediamanager.ui.movies.filters.MovieCertificationFilter;
import org.tinymediamanager.ui.movies.filters.MovieCountAudioStreamFilter;
import org.tinymediamanager.ui.movies.filters.MovieCountSubtitleFilter;
import org.tinymediamanager.ui.movies.filters.MovieCountryFilter;
import org.tinymediamanager.ui.movies.filters.MovieDatasourceFilter;
import org.tinymediamanager.ui.movies.filters.MovieDateAddedFilter;
import org.tinymediamanager.ui.movies.filters.MovieDecadesFilter;
import org.tinymediamanager.ui.movies.filters.MovieDifferentRuntimeFilter;
import org.tinymediamanager.ui.movies.filters.MovieDuplicateFilter;
import org.tinymediamanager.ui.movies.filters.MovieEditionFilter;
import org.tinymediamanager.ui.movies.filters.MovieFilenameFilter;
import org.tinymediamanager.ui.movies.filters.MovieFrameRateFilter;
import org.tinymediamanager.ui.movies.filters.MovieGenreFilter;
import org.tinymediamanager.ui.movies.filters.MovieHDRFormatFilter;
import org.tinymediamanager.ui.movies.filters.MovieInMovieSetFilter;
import org.tinymediamanager.ui.movies.filters.MovieLanguageFilter;
import org.tinymediamanager.ui.movies.filters.MovieMediaFilesFilter;
import org.tinymediamanager.ui.movies.filters.MovieMediaSourceFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingArtworkFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingMetadataFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingSubtitlesFilter;
import org.tinymediamanager.ui.movies.filters.MovieNewMoviesFilter;
import org.tinymediamanager.ui.movies.filters.MovieNoteFilter;
import org.tinymediamanager.ui.movies.filters.MoviePathFilter;
import org.tinymediamanager.ui.movies.filters.MovieProductionCompanyFilter;
import org.tinymediamanager.ui.movies.filters.MovieSubtitleLanguageFilter;
import org.tinymediamanager.ui.movies.filters.MovieTagFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideo3DFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoCodecFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoContainerFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoExtrasFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoFilenameFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoFormatFilter;
import org.tinymediamanager.ui.movies.filters.MovieWatchedFilter;
import org.tinymediamanager.ui.movies.filters.MovieYearFilter;

public class MovieFilterDialog
extends TmmDialog {
    private static final long serialVersionUID = 2298540526428945319L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private final MovieSelectionModel selectionModel;
    private final Map<JPanel, Set<IMovieUIFilter>> filterMap;
    private final Set<IMovieUIFilter> filters;
    private final JCheckBox chkbxEnableAll;
    private final JTabbedPane tabbedPane;
    private JComboBox<String> cbPreset;

    public MovieFilterDialog(MovieSelectionModel selectionModel) {
        super(TmmResourceBundle.getString("movieextendedsearch.options") + " - " + TmmResourceBundle.getString("tmm.movies"), "movieFilter");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setMinimumSize(new Dimension(550, 400));
        this.selectionModel = selectionModel;
        this.filterMap = new HashMap<JPanel, Set<IMovieUIFilter>>();
        this.filters = new HashSet<IMovieUIFilter>();
        this.selectionModel.addPropertyChangeListener("filterChanged", evt -> this.filterChanged());
        ActionListener actionListener = e -> SwingUtilities.invokeLater(() -> {
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isNotBlank((CharSequence)filterName)) {
                selectionModel.setFilterValues(MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets().get(filterName));
            } else {
                selectionModel.clearFilters();
            }
        });
        ActionListener resetFilter = e -> SwingUtilities.invokeLater(selectionModel::clearFilters);
        this.tabbedPane = new TmmTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelMain = new JPanel((LayoutManager)new MigLayout("", "[][][50lp:150lp,grow]", "[]"));
        NoBorderScrollPane scrollPaneMain = new NoBorderScrollPane(panelMain);
        scrollPaneMain.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), scrollPaneMain);
        panelMain.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0 2 1");
        panelMain.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 2 0, right");
        panelMain.add((Component)new FlatButton(IconManager.DELETE, resetFilter), "cell 2 0, right, wrap");
        panelMain.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieNewMoviesFilter(), panelMain);
        this.addFilter(new MovieDatasourceFilter(), panelMain);
        this.addFilter(new MovieWatchedFilter(), panelMain);
        this.addFilter(new MovieDateAddedFilter(), panelMain);
        this.addFilter(new MovieDuplicateFilter(), panelMain);
        this.addFilter(new MovieInMovieSetFilter(), panelMain);
        this.addFilter(new MovieAllInOneFilter(), panelMain);
        JPanel panelMetadata = new JPanel((LayoutManager)new MigLayout("", "[][][50lp:150lp,grow]", "[]"));
        NoBorderScrollPane scrollPane = new NoBorderScrollPane(panelMetadata);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(TmmResourceBundle.getString("tmm.metadata"), scrollPane);
        panelMetadata.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0 2 1");
        panelMetadata.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 2 0, right");
        panelMetadata.add((Component)new FlatButton(IconManager.DELETE, resetFilter), "cell 2 0, right, wrap");
        panelMetadata.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieYearFilter(), panelMetadata);
        this.addFilter(new MovieDecadesFilter(), panelMetadata);
        this.addFilter(new MovieGenreFilter(), panelMetadata);
        this.addFilter(new MovieCertificationFilter(), panelMetadata);
        this.addFilter(new MovieCastFilter(), panelMetadata);
        this.addFilter(new MovieCountryFilter(), panelMetadata);
        this.addFilter(new MovieLanguageFilter(), panelMetadata);
        this.addFilter(new MovieProductionCompanyFilter(), panelMetadata);
        panelMetadata.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieTagFilter(), panelMetadata);
        this.addFilter(new MovieEditionFilter(), panelMetadata);
        this.addFilter(new MovieNoteFilter(), panelMetadata);
        JPanel panelVideo = new JPanel((LayoutManager)new MigLayout("", "[][][50lp:150lp,grow]", "[]"));
        scrollPane = new NoBorderScrollPane(panelVideo);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.video"), scrollPane);
        panelVideo.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0 2 1");
        panelVideo.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 2 0, right");
        panelVideo.add((Component)new FlatButton(IconManager.DELETE, resetFilter), "cell 2 0, right, wrap");
        panelVideo.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieVideoFormatFilter(), panelVideo);
        this.addFilter(new MovieVideoCodecFilter(), panelVideo);
        this.addFilter(new MovieVideoContainerFilter(), panelVideo);
        this.addFilter(new MovieAspectRatioFilter(), panelVideo);
        this.addFilter(new MovieFrameRateFilter(), panelVideo);
        this.addFilter(new MovieVideo3DFilter(), panelVideo);
        this.addFilter(new MovieHDRFormatFilter(), panelVideo);
        JPanel panelAudio = new JPanel((LayoutManager)new MigLayout("", "[][][50lp:150lp,grow]", "[]"));
        scrollPane = new NoBorderScrollPane(panelAudio);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.audio"), scrollPane);
        panelAudio.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0 2 1");
        panelAudio.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 2 0, right");
        panelAudio.add((Component)new FlatButton(IconManager.DELETE, resetFilter), "cell 2 0, right, wrap");
        panelAudio.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieAudioCodecFilter(), panelAudio);
        this.addFilter(new MovieAudioChannelFilter(), panelAudio);
        this.addFilter(new MovieCountAudioStreamFilter(), panelAudio);
        this.addFilter(new MovieAudioLanguageFilter(), panelAudio);
        this.addFilter(new MovieAudioTitleFilter(), panelAudio);
        JPanel panelOther = new JPanel((LayoutManager)new MigLayout("", "[][][50lp:150lp,grow]", "[]"));
        scrollPane = new NoBorderScrollPane(panelOther);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(TmmResourceBundle.getString("filter.others"), scrollPane);
        panelOther.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0 2 1");
        panelOther.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 2 0, right");
        panelOther.add((Component)new FlatButton(IconManager.DELETE, resetFilter), "cell 2 0, right, wrap");
        panelOther.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieMediaSourceFilter(), panelOther);
        this.addFilter(new MovieMediaFilesFilter(), panelOther);
        this.addFilter(new MovieFilenameFilter(), panelOther);
        this.addFilter(new MovieVideoFilenameFilter(), panelOther);
        this.addFilter(new MoviePathFilter(), panelOther);
        this.addFilter(new MovieCountSubtitleFilter(), panelOther);
        this.addFilter(new MovieSubtitleLanguageFilter(), panelOther);
        this.addFilter(new MovieVideoExtrasFilter(), panelOther);
        this.addFilter(new MovieDifferentRuntimeFilter(), panelOther);
        panelOther.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieMissingMetadataFilter(), panelOther);
        this.addFilter(new MovieMissingArtworkFilter(), panelOther);
        this.addFilter(new MovieMissingSubtitlesFilter(), panelOther);
        JPanel panelFilterPreset = new JPanel();
        panelFilterPreset.setLayout((LayoutManager)new MigLayout("insets n 0 n 0", "[5lp!][10lp][150lp,grow][5lp!]", "[]"));
        JSeparator separator = new JSeparator();
        panelFilterPreset.add((Component)separator, "cell 0 1 4 1,growx,aligny top");
        TmmLabel lblEnableAllT = new TmmLabel(TmmResourceBundle.getString("filter.enableall"));
        panelFilterPreset.add((Component)lblEnableAllT, "cell 1 2, alignx trailing");
        this.chkbxEnableAll = new JCheckBox();
        this.chkbxEnableAll.setSelected(true);
        this.chkbxEnableAll.addActionListener(e -> selectionModel.setFiltersActive(this.chkbxEnableAll.isSelected()));
        panelFilterPreset.add((Component)this.chkbxEnableAll, "cell 2 2");
        TmmLabel lblFilterPresetT = new TmmLabel(TmmResourceBundle.getString("filter.presets"));
        panelFilterPreset.add((Component)lblFilterPresetT, "cell 1 3, alignx trailing");
        this.cbPreset = new JComboBox();
        panelFilterPreset.add(this.cbPreset, "cell 2 3");
        FlatButton btnSavePreset = new FlatButton(IconManager.SAVE);
        btnSavePreset.setToolTipText(TmmResourceBundle.getString("filter.savepreset"));
        btnSavePreset.addActionListener(e -> {
            Set<AbstractSettings.UIFilters> activeUiFilters = this.getActiveUiFilters();
            if (!activeUiFilters.isEmpty()) {
                HashMap<String, List<AbstractSettings.UIFilters>> movieUiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets());
                FilterSaveDialog saveDialog = new FilterSaveDialog((JDialog)this, activeUiFilters, movieUiFilters);
                saveDialog.setVisible(true);
                String savedPreset = saveDialog.getSavedPreset();
                if (StringUtils.isNotBlank((CharSequence)savedPreset)) {
                    this.cbPreset.removeActionListener(actionListener);
                    MovieModuleManager.getInstance().getSettings().setMovieUiFilterPresets(movieUiFilters);
                    MovieModuleManager.getInstance().getSettings().saveSettings();
                    this.loadPresets();
                    this.cbPreset.setSelectedItem(savedPreset);
                    this.cbPreset.addActionListener(actionListener);
                }
            }
        });
        panelFilterPreset.add((Component)btnSavePreset, "cell 2 3");
        FlatButton btnDeletePreset = new FlatButton(IconManager.DELETE_GRAY);
        btnDeletePreset.setToolTipText(TmmResourceBundle.getString("filter.remove"));
        btnDeletePreset.addActionListener(e -> {
            HashMap<String, List<AbstractSettings.UIFilters>> movieUiFilters;
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)filterName)) {
                return;
            }
            if (Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("movie.hidefilterhint"))) {
                JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
                TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
                checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
                Object[] params = new Object[]{TmmResourceBundle.getString("filter.remove"), checkBox};
                int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("filter.remove"), 0, 3, null, options, null);
                if (checkBox.isSelected()) {
                    TmmProperties.getInstance().putProperty("movie.hidefilterhint", String.valueOf(checkBox.isSelected()));
                }
                if (answer != 0) {
                    return;
                }
            }
            if ((movieUiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets())).remove(filterName) != null) {
                this.cbPreset.removeActionListener(actionListener);
                MovieModuleManager.getInstance().getSettings().setMovieUiFilterPresets(movieUiFilters);
                MovieModuleManager.getInstance().getSettings().saveSettings();
                this.loadPresets();
                this.cbPreset.addActionListener(actionListener);
            }
        });
        panelFilterPreset.add((Component)btnDeletePreset, "cell 2 3");
        this.getContentPane().add((Component)panelFilterPreset, "South");
        this.loadPresets();
        this.cbPreset.addActionListener(actionListener);
    }

    private Set<AbstractSettings.UIFilters> getActiveUiFilters() {
        return new HashSet<AbstractSettings.UIFilters>(IMovieUIFilter.morphToUiFilters(this.filters));
    }

    private void loadPresets() {
        String preset = (String)this.cbPreset.getSelectedItem();
        this.cbPreset.removeAllItems();
        this.cbPreset.addItem("");
        MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets().keySet().stream().sorted().forEach(key -> this.cbPreset.addItem((String)key));
        if (StringUtils.isNotBlank((CharSequence)preset)) {
            this.cbPreset.setSelectedItem(preset);
        }
    }

    private void addFilter(IMovieUIFilter filter, JPanel panel) {
        panel.add((Component)filter.getCheckBox(), "");
        panel.add((Component)filter.getLabel(), "");
        if (filter.getFilterComponent() != null) {
            panel.add((Component)filter.getFilterComponent(), "wmin 100, grow, wrap");
        } else {
            panel.add(Box.createGlue(), "wrap");
        }
        this.filterMap.computeIfAbsent(panel, k -> new HashSet()).add(filter);
        this.filters.add(filter);
        this.selectionModel.addFilter(filter);
    }

    private void filterChanged() {
        block3: for (Map.Entry<JPanel, Set<IMovieUIFilter>> entry : this.filterMap.entrySet()) {
            boolean active = false;
            if (this.chkbxEnableAll.isSelected()) {
                for (IMovieUIFilter filter : entry.getValue()) {
                    switch (filter.getFilterState()) {
                        case ACTIVE: 
                        case ACTIVE_NEGATIVE: {
                            active = true;
                            break;
                        }
                    }
                    if (!active) continue;
                    break;
                }
            }
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!SwingUtilities.isDescendingFrom(entry.getKey(), this.tabbedPane.getComponentAt(i))) continue;
                if (active) {
                    this.tabbedPane.setIconAt(i, IconManager.FILTER_ACTIVE);
                    continue block3;
                }
                this.tabbedPane.setIconAt(i, null);
                continue block3;
            }
        }
    }

    @Override
    protected void initBottomPanel() {
    }
}

