/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieRenamerPreview;
import org.tinymediamanager.core.movie.MovieRenamerPreviewContainer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieRenamerPreviewDialog
extends TmmDialog {
    private static final long serialVersionUID = -8162631708278089277L;
    private final EventList<MovieRenamerPreviewContainer> results;
    private final ResultSelectionModel resultSelectionModel;
    private final EventList<MediaFileContainer> oldMediaFileEventList = GlazedLists.eventList(new ArrayList());
    private final EventList<MediaFileContainer> newMediaFileEventList = GlazedLists.eventList(new ArrayList());
    private final TmmTable tableMovies;
    private final JLabel lblTitle;
    private final JLabel lblDatasource;
    private final JLabel lblFolderOld;
    private final JLabel lblFolderNew;

    public MovieRenamerPreviewDialog(List<Movie> selectedMovies) {
        super(TmmResourceBundle.getString("movie.renamerpreview"), "movieRenamerPreview");
        this.results = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()));
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[950lp,grow]", "[600lp,grow]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        splitPane.setResizeWeight(0.4);
        panelContent.add((Component)splitPane, "cell 0 0,grow");
        TmmTableModel<MovieRenamerPreviewContainer> movieTableModel = new TmmTableModel<MovieRenamerPreviewContainer>((EventList<MovieRenamerPreviewContainer>)GlazedListsSwing.swingThreadProxyList(this.results), new ResultTableFormat());
        this.tableMovies = new TmmTable((TableModel)((Object)movieTableModel));
        DefaultEventSelectionModel tableSelectionModel = new DefaultEventSelectionModel(this.results);
        this.resultSelectionModel = new ResultSelectionModel();
        tableSelectionModel.addListSelectionListener((ListSelectionListener)this.resultSelectionModel);
        this.resultSelectionModel.selectedResults = tableSelectionModel.getSelected();
        this.tableMovies.setSelectionModel((ListSelectionModel)tableSelectionModel);
        movieTableModel.addTableModelListener(arg0 -> {
            ListSelectionModel selectionModel = this.tableMovies.getSelectionModel();
            if (selectionModel.isSelectionEmpty() && movieTableModel.getRowCount() > 0) {
                selectionModel.setSelectionInterval(0, 0);
            }
            if (selectionModel.isSelectionEmpty() && movieTableModel.getRowCount() == 0) {
                this.resultSelectionModel.setSelectedResult(null);
            }
        });
        JScrollPane scrollPaneMovies = new JScrollPane();
        this.tableMovies.configureScrollPane(scrollPaneMovies);
        splitPane.setLeftComponent(scrollPaneMovies);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new MigLayout("", "[][][grow]", "[][][][][][][][grow]"));
        this.lblTitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTitle, 1.33, 1);
        panelDetails.add((Component)this.lblTitle, "cell 0 0 3 1,growx");
        TmmLabel lblDatasourceT = new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
        panelDetails.add((Component)lblDatasourceT, "cell 0 2");
        this.lblDatasource = new JLabel("");
        panelDetails.add((Component)this.lblDatasource, "cell 2 2,growx,aligny center");
        TmmLabel lblFolderOldT = new TmmLabel(TmmResourceBundle.getString("renamer.oldfolder"));
        panelDetails.add((Component)lblFolderOldT, "cell 0 4");
        this.lblFolderOld = new JLabel("");
        panelDetails.add((Component)this.lblFolderOld, "cell 2 4,growx,aligny center");
        TmmLabel lblFolderNewT = new TmmLabel(TmmResourceBundle.getString("renamer.newfolder"));
        panelDetails.add((Component)lblFolderNewT, "cell 0 5");
        this.lblFolderNew = new JLabel("");
        panelDetails.add((Component)this.lblFolderNew, "cell 2 5,growx,aligny center");
        JPanel panelMediaFiles = new JPanel();
        panelDetails.add((Component)panelMediaFiles, "cell 0 7 3 1,grow");
        panelMediaFiles.setLayout((LayoutManager)new MigLayout("", "[grow][grow]", "[15px][grow]"));
        TmmLabel lblOldfilesT = new TmmLabel(TmmResourceBundle.getString("renamer.oldfiles"));
        panelMediaFiles.add((Component)lblOldfilesT, "cell 0 0,alignx center");
        TmmLabel lblNewfilesT = new TmmLabel(TmmResourceBundle.getString("renamer.newfiles"));
        panelMediaFiles.add((Component)lblNewfilesT, "cell 1 0,alignx center");
        TmmTable tableMediaFilesOld = new TmmTable((TableModel)((Object)new TmmTableModel<MediaFileContainer>((EventList<MediaFileContainer>)GlazedListsSwing.swingThreadProxyList(this.oldMediaFileEventList), new MediaFileTableFormat())));
        JScrollPane scrollPaneMediaFilesOld = new JScrollPane();
        tableMediaFilesOld.configureScrollPane(scrollPaneMediaFilesOld);
        panelMediaFiles.add((Component)scrollPaneMediaFilesOld, "cell 0 1,grow");
        tableMediaFilesOld.getColumnModel().getColumn(0).setMaxWidth(40);
        TmmTable tableMediaFilesNew = new TmmTable((TableModel)((Object)new TmmTableModel<MediaFileContainer>((EventList<MediaFileContainer>)GlazedListsSwing.swingThreadProxyList(this.newMediaFileEventList), new MediaFileTableFormat())));
        JScrollPane scrollPaneMediaFilesNew = new JScrollPane(tableMediaFilesNew);
        tableMediaFilesNew.configureScrollPane(scrollPaneMediaFilesNew);
        panelMediaFiles.add((Component)scrollPaneMediaFilesNew, "cell 1 1,grow");
        tableMediaFilesNew.getColumnModel().getColumn(0).setMaxWidth(40);
        JButton btnRename = new JButton(TmmResourceBundle.getString("Button.rename"));
        btnRename.setToolTipText(TmmResourceBundle.getString("movie.rename"));
        btnRename.addActionListener(arg0 -> {
            ArrayList<Movie> selectedMovies1 = new ArrayList<Movie>();
            ArrayList<MovieRenamerPreviewContainer> selectedResults = new ArrayList<MovieRenamerPreviewContainer>(this.resultSelectionModel.selectedResults);
            for (MovieRenamerPreviewContainer result : selectedResults) {
                selectedMovies1.add(result.getMovie());
            }
            MovieRenameTask renameTask = new MovieRenameTask(selectedMovies1);
            TmmTaskManager.getInstance().addMainTask(renameTask);
            this.results.removeAll(selectedResults);
        });
        this.addButton(btnRename);
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
        MoviePreviewWorker worker = new MoviePreviewWorker(selectedMovies);
        worker.execute();
    }

    private static class MediaFileContainer {
        ImageIcon icon = null;
        MediaFile mediaFile;

        private MediaFileContainer() {
        }
    }

    private class ResultSelectionModel
    extends AbstractModelObject
    implements ListSelectionListener {
        private final MovieRenamerPreviewContainer emptyResult = new MovieRenamerPreviewContainer(new Movie());
        private MovieRenamerPreviewContainer selectedResult;
        private List<MovieRenamerPreviewContainer> selectedResults;

        ResultSelectionModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void setSelectedResult(MovieRenamerPreviewContainer newValue) {
            this.selectedResult = newValue == null ? this.emptyResult : newValue;
            MovieRenamerPreviewDialog.this.lblTitle.setText(this.selectedResult.getMovie().getTitleSortable());
            MovieRenamerPreviewDialog.this.lblDatasource.setText(this.selectedResult.getMovie().getDataSource());
            if (this.selectedResult != this.emptyResult) {
                MovieRenamerPreviewDialog.this.lblFolderOld.setText(this.selectedResult.getOldPath().toString());
                MovieRenamerPreviewDialog.this.lblFolderNew.setText(this.selectedResult.getNewPath().toString());
            } else {
                MovieRenamerPreviewDialog.this.lblFolderOld.setText("");
                MovieRenamerPreviewDialog.this.lblFolderNew.setText("");
            }
            try {
                MediaFileContainer container;
                boolean found;
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().lock();
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getOldMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.mediaFile = mf;
                    for (MediaFile mf2 : this.selectedResult.getNewMediaFiles()) {
                        if (mf2 == null || !mf.getFilename().equals(mf2.getFilename())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        container.icon = IconManager.REMOVE;
                    }
                    MovieRenamerPreviewDialog.this.oldMediaFileEventList.add((Object)container);
                }
                MovieRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().lock();
                MovieRenamerPreviewDialog.this.newMediaFileEventList.clear();
                for (MediaFile mf : this.selectedResult.getNewMediaFiles()) {
                    found = false;
                    container = new MediaFileContainer();
                    container.mediaFile = mf;
                    for (MediaFile mf2 : this.selectedResult.getOldMediaFiles()) {
                        if (!mf.getFilename().equals(mf2.getFilename())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        container.icon = IconManager.ADD;
                    }
                    MovieRenamerPreviewDialog.this.newMediaFileEventList.add((Object)container);
                }
            }
            catch (Exception exception) {
            }
            finally {
                MovieRenamerPreviewDialog.this.oldMediaFileEventList.getReadWriteLock().writeLock().unlock();
                MovieRenamerPreviewDialog.this.newMediaFileEventList.getReadWriteLock().writeLock().unlock();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            if (arg0.getValueIsAdjusting()) {
                return;
            }
            if (!this.selectedResults.isEmpty() && this.selectedResult != this.selectedResults.get(0)) {
                this.setSelectedResult(this.selectedResults.get(0));
            }
            if (this.selectedResults.isEmpty()) {
                this.setSelectedResult(this.emptyResult);
            }
        }
    }

    private class MoviePreviewWorker
    extends SwingWorker<Void, Void> {
        private final List<Movie> moviesToProcess;

        private MoviePreviewWorker(List<Movie> movies) {
            this.moviesToProcess = new ArrayList<Movie>(movies);
        }

        @Override
        protected Void doInBackground() {
            this.moviesToProcess.sort(new MovieComparator());
            for (Movie movie : this.moviesToProcess) {
                MovieRenamerPreviewContainer container = MovieRenamerPreview.renameMovie(movie);
                if (!container.isNeedsRename()) continue;
                MovieRenamerPreviewDialog.this.results.add((Object)container);
            }
            SwingUtilities.invokeLater(() -> {
                if (MovieRenamerPreviewDialog.this.results.isEmpty()) {
                    JOptionPane.showMessageDialog(MovieRenamerPreviewDialog.this, TmmResourceBundle.getString("movie.renamerpreview.nothingtorename"));
                    MovieRenamerPreviewDialog.this.setVisible(false);
                }
            });
            return null;
        }
    }

    private static class MediaFileTableFormat
    extends TmmTableFormat<MediaFileContainer> {
        public MediaFileTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "indicator", container -> container.icon, ImageIcon.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", container -> container.mediaFile.getFilename(), String.class);
            col.setColumnTooltip(container -> container.mediaFile.getFilename());
            this.addColumn(col);
        }
    }

    private static class ResultTableFormat
    extends TmmTableFormat<MovieRenamerPreviewContainer> {
        public ResultTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.movie"), "title", container -> container.getMovie().getTitleSortable(), String.class);
            col.setColumnTooltip(container -> container.getMovie().getTitleSortable());
            this.addColumn(col);
        }
    }
}

