/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioTitleFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieAudioTitleFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildAudioTitleArray();
        this.movieList.addPropertyChangeListener("audioTitle", evt -> SwingUtilities.invokeLater(this::buildAudioTitleArray));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.audiotitle"));
    }

    @Override
    public String getId() {
        return "movieAudioTitle";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<MediaFile> mediaFileList = movie.getMediaFiles(MediaFileType.VIDEO);
        for (MediaFile mf : mediaFileList) {
            if (selectedItems.isEmpty() && mf.getAudioTitleList().isEmpty()) {
                return true;
            }
            for (String title : mf.getAudioTitleList()) {
                if (!selectedItems.contains(title)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    private void buildAudioTitleArray() {
        ArrayList<String> audioTitles = new ArrayList<String>(this.movieList.getAudioTitlesInMovies());
        Collections.sort(audioTitles);
        this.setValues(audioTitles);
    }
}

